/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.io.OutputStream;
import org.eclipse.osgi.util.NLS;

public class ListComponentsCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        IWorkspaceConnection workspaceConnection;
        ConnectionInfo info = config.getConnectionInfo();
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)info);
        ICommandLine cli = config.getSubcommandCommandLine();
        String wsSelector = cli.getOption(CommonOptions.OPT_WORKSPACE);
        try {
            workspaceConnection = RepoUtil.findNamedWorkspaceConnection((String)wsSelector, (boolean)true, (boolean)true, (ITeamRepository)repo);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateBaselineCmd_1, (Object)e.getSelector()));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateBaselineCmd_0, (Object)e.getSelector()));
        }
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.enablePrinter(1);
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
            options.enablePrinter(11);
        }
        PendingChangesUtil.printWorkspace((IWorkspaceConnection)workspaceConnection, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)new IndentingPrintStream((OutputStream)System.out));
    }
}

