/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.flowcommands;

public class DifferenceEngine {
    private static final double TOO_LONG = 1.0E7;
    private static final double POW_LIMIT = 1.5;
    private int max_differences;

    public TextLine[][] longestCommonSubsequence(TextLine[] l1, TextLine[] l2) {
        if (l1.length == 0 || l2.length == 0) {
            return new TextLine[2][0];
        }
        this.max_differences = (l1.length + l2.length + 1) / 2;
        if ((double)l1.length * (double)l2.length > 1.0E7) {
            this.max_differences = (int)Math.pow(this.max_differences, 0.5);
        }
        TextLine[][] lcs = new TextLine[2][l1.length];
        int max = Math.min(l1.length, l2.length);
        int forwardBound = 0;
        while (forwardBound < max && l1[forwardBound].sameText(l2[forwardBound])) {
            lcs[0][forwardBound] = l1[forwardBound];
            lcs[1][forwardBound] = l2[forwardBound];
            ++forwardBound;
        }
        int backBoundL1 = l1.length - 1;
        int backBoundL2 = l2.length - 1;
        while (backBoundL1 >= forwardBound && backBoundL2 >= forwardBound && l1[backBoundL1].sameText(l2[backBoundL2])) {
            lcs[0][backBoundL1] = l1[backBoundL1];
            lcs[1][backBoundL1] = l2[backBoundL2];
            --backBoundL1;
            --backBoundL2;
        }
        int len = forwardBound + l1.length - backBoundL1 - 1 + this.lcs_rec(l1, forwardBound, backBoundL1, l2, forwardBound, backBoundL2, new int[2][l1.length + l2.length + 1], new int[3], lcs);
        TextLine[][] result = new TextLine[][]{this.compactAndShiftLCS(lcs[0], len, l1), this.compactAndShiftLCS(lcs[1], len, l2)};
        return result;
    }

    private int lcs_rec(TextLine[] l1, int bottoml1, int topl1, TextLine[] l2, int bottoml2, int topl2, int[][] V, int[] snake, TextLine[][] lcs) {
        if (bottoml1 > topl1 || bottoml2 > topl2) {
            return 0;
        }
        int d = this.find_middle_snake(l1, bottoml1, topl1, l2, bottoml2, topl2, V, snake);
        int len = snake[2];
        int startx = snake[0];
        int starty = snake[1];
        int i = 0;
        while (i < len) {
            lcs[0][startx + i] = l1[startx + i];
            lcs[1][startx + i] = l2[starty + i];
            ++i;
        }
        if (d > 1) {
            return len + this.lcs_rec(l1, bottoml1, startx - 1, l2, bottoml2, starty - 1, V, snake, lcs) + this.lcs_rec(l1, startx + len, topl1, l2, starty + len, topl2, V, snake, lcs);
        }
        if (d == 1) {
            int max = Math.min(startx - bottoml1, starty - bottoml2);
            int i2 = 0;
            while (i2 < max) {
                lcs[0][bottoml1 + i2] = l1[bottoml1 + i2];
                lcs[1][bottoml1 + i2] = l2[bottoml2 + i2];
                ++i2;
            }
            return max + len;
        }
        return len;
    }

    private int find_middle_snake(TextLine[] l1, int bottoml1, int topl1, TextLine[] l2, int bottoml2, int topl2, int[][] V, int[] snake) {
        int N = topl1 - bottoml1 + 1;
        int M = topl2 - bottoml2 + 1;
        int delta = N - M;
        boolean isEven = (delta & 1) != 1;
        int limit = Math.min(this.max_differences, (N + M + 1) / 2);
        int value_to_add_forward = (M & 1) == 1 ? 1 : 0;
        int value_to_add_backward = (N & 1) == 1 ? 1 : 0;
        int start_forward = -M;
        int end_forward = N;
        int start_backward = -N;
        int end_backward = M;
        V[0][limit + 1] = 0;
        V[1][limit - 1] = N;
        int d = 0;
        while (d <= limit) {
            int y;
            int x;
            int start_diag = Math.max(value_to_add_forward + start_forward, -d);
            int end_diag = Math.min(end_forward, d);
            value_to_add_forward = 1 - value_to_add_forward;
            int k = start_diag;
            while (k <= end_diag) {
                x = k == -d || k < d && V[0][limit + k - 1] < V[0][limit + k + 1] ? V[0][limit + k + 1] : V[0][limit + k - 1] + 1;
                y = x - k;
                snake[0] = x + bottoml1;
                snake[1] = y + bottoml2;
                snake[2] = 0;
                while (x < N && y < M && l1[x + bottoml1].sameText(l2[y + bottoml2])) {
                    ++x;
                    ++y;
                    snake[2] = snake[2] + 1;
                }
                V[0][limit + k] = x;
                if (!isEven && k >= delta - d + 1 && k <= delta + d - 1 && x >= V[1][limit + k - delta]) {
                    return 2 * d - 1;
                }
                if (x >= N && end_forward > k - 1) {
                    end_forward = k - 1;
                } else if (y >= M) {
                    start_forward = k + 1;
                    value_to_add_forward = 0;
                }
                k += 2;
            }
            start_diag = Math.max(value_to_add_backward + start_backward, -d);
            end_diag = Math.min(end_backward, d);
            value_to_add_backward = 1 - value_to_add_backward;
            k = start_diag;
            while (k <= end_diag) {
                x = k == d || k != -d && V[1][limit + k - 1] < V[1][limit + k + 1] ? V[1][limit + k - 1] : V[1][limit + k + 1] - 1;
                y = x - k - delta;
                snake[2] = 0;
                while (x > 0 && y > 0 && l1[x - 1 + bottoml1].sameText(l2[y - 1 + bottoml2])) {
                    --x;
                    --y;
                    snake[2] = snake[2] + 1;
                }
                V[1][limit + k] = x;
                if (isEven && k >= -delta - d && k <= d - delta && x <= V[0][limit + k + delta]) {
                    snake[0] = bottoml1 + x;
                    snake[1] = bottoml2 + y;
                    return 2 * d;
                }
                if (x <= 0) {
                    start_backward = k + 1;
                    value_to_add_backward = 0;
                } else if (y <= 0 && end_backward > k - 1) {
                    end_backward = k - 1;
                }
                k += 2;
            }
            ++d;
        }
        int[] most_progress = DifferenceEngine.findMostProgress(M, N, limit, V);
        snake[0] = bottoml1 + most_progress[0];
        snake[1] = bottoml2 + most_progress[1];
        snake[2] = 0;
        return 5;
    }

    private static int[] findMostProgress(int M, int N, int limit, int[][] V) {
        int delta = N - M;
        int forward_start_diag = (M & 1) == (limit & 1) ? Math.max(-M, -limit) : Math.max(1 - M, -limit);
        int forward_end_diag = Math.min(N, limit);
        int backward_start_diag = (N & 1) == (limit & 1) ? Math.max(-N, -limit) : Math.max(1 - N, -limit);
        int backward_end_diag = Math.min(M, limit);
        int[][] max_progress = new int[Math.max(forward_end_diag - forward_start_diag, backward_end_diag - backward_start_diag) / 2 + 1][3];
        int num_progress = 0;
        int k = forward_start_diag;
        while (k <= forward_end_diag) {
            int x = V[0][limit + k];
            int y = x - k;
            if (x <= N && y <= M) {
                int progress = x + y;
                if (progress > max_progress[0][2]) {
                    num_progress = 0;
                    max_progress[0][0] = x;
                    max_progress[0][1] = y;
                    max_progress[0][2] = progress;
                } else if (progress == max_progress[0][2]) {
                    max_progress[++num_progress][0] = x;
                    max_progress[num_progress][1] = y;
                    max_progress[num_progress][2] = progress;
                }
            }
            k += 2;
        }
        boolean max_progress_forward = true;
        int k2 = backward_start_diag;
        while (k2 <= backward_end_diag) {
            int x = V[1][limit + k2];
            int y = x - k2 - delta;
            if (x >= 0 && y >= 0) {
                int progress = N - x + M - y;
                if (progress > max_progress[0][2]) {
                    num_progress = 0;
                    max_progress_forward = false;
                    max_progress[0][0] = x;
                    max_progress[0][1] = y;
                    max_progress[0][2] = progress;
                } else if (progress == max_progress[0][2] && !max_progress_forward) {
                    max_progress[++num_progress][0] = x;
                    max_progress[num_progress][1] = y;
                    max_progress[num_progress][2] = progress;
                }
            }
            k2 += 2;
        }
        return max_progress[num_progress / 2];
    }

    /*
     * Unable to fully structure code
     */
    private TextLine[] compactAndShiftLCS(TextLine[] lcs, int len, TextLine[] original) {
        result = new TextLine[len];
        if (len == 0) {
            return result;
        }
        j = 0;
        while (lcs[j] == null) {
            ++j;
        }
        result[0] = lcs[j];
        ++j;
        i = 1;
        ** GOTO lbl18
        {
            ++j;
            do {
                if (lcs[j] == null) continue block1;
                result[i] = original[result[i - 1].lineNumber() + 1].sameText(lcs[j]) != false ? original[result[i - 1].lineNumber() + 1] : lcs[j];
                ++j;
                ++i;
lbl18:
                // 2 sources

            } while (i < len);
        }
        return result;
    }

    public static class TextLine {
        private int number;
        private String text;
        private int originalNumber;

        public TextLine(int number, boolean original, String text) {
            this.number = number;
            this.text = text;
            this.originalNumber = original ? number : -1;
        }

        public boolean sameText(TextLine l) {
            return this.text.hashCode() == l.text.hashCode() && l.text.equals(this.text);
        }

        public int lineNumber() {
            return this.number;
        }

        public boolean original() {
            return this.originalNumber != -1;
        }

        public int originalLineNumber() {
            return this.originalNumber;
        }

        public void setOriginalLineNumber(int number) {
            this.originalNumber = number;
        }

        public String toString() {
            return String.valueOf(this.original() ? "(orig)" : "      ") + this.number + " " + this.text + "\n";
        }

        public String getText() {
            return this.text;
        }
    }
}

