/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.flowcommands;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.AbstractFlowGroup;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.DeliverFlowGroup;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.FlowCmd;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.WorkspaceComponentGrouping;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ChangeSetAlreadyInHistoryException;
import com.ibm.team.scm.common.DeliveryIntroducesConflictsException;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.OutstandingConflictsException;
import com.ibm.team.scm.common.SyncReportInappropriateException;
import java.util.Collection;
import java.util.List;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliverCmd
extends FlowCmd {
    @Override
    protected List<AbstractFlowGroup> findFlows(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine subargs = config.getSubcommandCommandLine();
        Collection<WorkspaceComponentGrouping> subject = this.findSubject(config, subargs.getOption(CommonOptions.OPT_STREAM_SOURCE_SELECTOR, null));
        List<AbstractFlowGroup> toFlow = this.findCollaboration(subject, subargs.getOption(CommonOptions.OPT_STREAM_TARGET_SELECTOR, null));
        return toFlow;
    }

    @Override
    protected IOptionKey getFlowSourceOptKey() {
        return CommonOptions.OPT_STREAM_SOURCE_SELECTOR;
    }

    @Override
    protected IWorkspaceHandle findCollaboration(IWorkspaceConnection wsConn, IFlowTable flowTable, IComponentHandle component) {
        IFlowEntry entry = flowTable.getCurrentDeliverFlow(component);
        if (entry == null) {
            entry = flowTable.getCurrentDeliverFlow();
        }
        if (entry == null) {
            entry = flowTable.getDefaultDeliverFlow();
        }
        if (entry == null) {
            return null;
        }
        return (IWorkspaceHandle)entry.getFlowNode();
    }

    @Override
    protected IWorkspaceHandle findTargetWorkspace(IWorkspaceConnection wsConn, IFlowTable flowTable) throws FileSystemClientException {
        IFlowEntry entry = flowTable.getCurrentDeliverFlow();
        if (entry == null) {
            entry = flowTable.getDefaultDeliverFlow();
        }
        if (entry == null) {
            return null;
        }
        return (IWorkspaceHandle)entry.getFlowNode();
    }

    @Override
    protected void flow(List<AbstractFlowGroup> toFlow, IClientConfiguration config) throws FileSystemClientException {
        if (config.isDryRun()) {
            return;
        }
        for (AbstractFlowGroup flow : toFlow) {
            this.flow(flow);
        }
    }

    protected void flow(AbstractFlowGroup flow) throws FileSystemClientException {
        try {
            flow.getSubject().deliver(flow.syncReport, flow.getNewBasis(), flow.getChangesToFlow(), null);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            throw StatusHelper.ambiguousSelector((String)Messages.DeliverCmd_0);
        }
        catch (StaleDataException staleDataException) {
            throw StatusHelper.staleData((String)Messages.DeliverCmd_1);
        }
        catch (DeliveryIntroducesConflictsException deliveryIntroducesConflictsException) {
            throw StatusHelper.conflict((String)Messages.DeliverCmd_2);
        }
        catch (SyncReportInappropriateException e) {
            throw StatusHelper.failure((String)Messages.DeliverCmd_3, (Throwable)e);
        }
        catch (OutstandingConflictsException outstandingConflictsException) {
            throw StatusHelper.conflict((String)Messages.DeliverCmd_4);
        }
        catch (GapException gapException) {
            throw StatusHelper.gap((String)Messages.DeliverCmd_5);
        }
        catch (ChangeSetAlreadyInHistoryException changeSetAlreadyInHistoryException) {
            throw StatusHelper.argSyntax((String)Messages.DeliverCmd_6);
        }
        catch (TeamOperationCanceledException e) {
            throw StatusHelper.processFailure((String)Messages.DeliverCmd_7, (TeamOperationCanceledException)e);
        }
        catch (PermissionDeniedException e) {
            throw StatusHelper.permissionFailure((PermissionDeniedException)e);
        }
        catch (TeamRepositoryException e) {
            if (this.hasMismatchedComponents(flow.syncReport)) {
                throw StatusHelper.disallowed((String)Messages.AcceptCmd_19);
            }
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.DeliverCmd_8);
        }
    }

    @Override
    protected AbstractFlowGroup createFlowGroup(IWorkspaceConnection start, List<IComponentHandle> componentsToFlow, IWorkspaceConnection collab) {
        return new DeliverFlowGroup(start, componentsToFlow, collab);
    }

    @Override
    protected String findFlowDescription(AbstractFlowGroup flow) {
        return NLS.bind((String)Messages.DeliverCmd_9, (Object)flow.getSource().getName(), (Object)flow.getTarget().getName());
    }
}

