/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.flowcommands;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.AbstractFlowGroup;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.AcceptCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.AcceptFlowGroup;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.ChangeDisplayer;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.FlowCmd;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.conflicthandlers.AbstractConflictHandler;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.conflicthandlers.InPlaceConflictHandler;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.conflicthandlers.NonModifyingConflictHandler;
import com.ibm.team.filesystem.cli.client.internal.subcommands.DownloadProgressWriter;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.cli.core.util.WorkspaceComponentGrouping;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.internal.utils.ExceptionUtil;
import com.ibm.team.filesystem.client.operations.AcceptDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.rcp.core.IEclipseFileSystemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.NWayConflictUnsupportedException;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptCmd
extends FlowCmd {
    boolean useInPlaceConflictHandler = false;

    @Override
    protected void handleArguments(ICommandLine subargs) {
        super.handleArguments(subargs);
        this.useInPlaceConflictHandler = subargs.hasOption((IOptionKey)AcceptCmdOptions.OPT_INPLACE_CONFLICT_HANDLER);
    }

    @Override
    protected IOptionKey getFlowSourceOptKey() {
        return CommonOptions.OPT_STREAM_TARGET_SELECTOR;
    }

    @Override
    protected List<AbstractFlowGroup> findFlows(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine subargs = config.getSubcommandCommandLine();
        Collection<WorkspaceComponentGrouping> subjWorkspace = this.findSubject(config, subargs.getOption(CommonOptions.OPT_STREAM_TARGET_SELECTOR, null));
        List<AbstractFlowGroup> toFlow = this.findCollaboration(subjWorkspace, subargs.getOption(CommonOptions.OPT_STREAM_SOURCE_SELECTOR, null));
        return toFlow;
    }

    @Override
    protected IWorkspaceHandle findCollaboration(IWorkspaceConnection wsConn, IFlowTable flowTable, IComponentHandle component) {
        IFlowEntry entry = flowTable.getCurrentDeliverFlow(component);
        if (entry == null) {
            entry = flowTable.getCurrentAcceptFlow();
        }
        if (entry == null) {
            entry = flowTable.getDefaultAcceptFlow();
        }
        if (entry == null) {
            return null;
        }
        return (IWorkspaceHandle)entry.getFlowNode();
    }

    @Override
    protected IWorkspaceHandle findTargetWorkspace(IWorkspaceConnection wsConn, IFlowTable flowTable) throws FileSystemClientException {
        IFlowEntry entry = flowTable.getCurrentDeliverFlow();
        if (entry == null) {
            entry = flowTable.getDefaultAcceptFlow();
        }
        if (entry == null) {
            return null;
        }
        return (IWorkspaceHandle)entry.getFlowNode();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void flow(List<AbstractFlowGroup> toFlow, IClientConfiguration config) throws FileSystemClientException {
        preflight = config.isDryRun();
        conflict = false;
        for (AbstractFlowGroup flow : toFlow) {
            block25: {
                if (this.cfaRoot == null || preflight) {
                    updateReport = this.flowRemote(flow, preflight);
                } else {
                    block26: {
                        updateReport = this.flowRemote(flow, true);
                        if (!config.getSubcommandCommandLine().hasOption((IOptionKey)AcceptCmdOptions.OPT_FORCE)) {
                            repo = flow.getCollab().teamRepository();
                            workspaces = new LinkedList<IWorkspaceConnection>();
                            cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config, (IPath)this.cfaRoot, (IPath)this.cfaRoot);
                            repoViews = cfaView.getLoadedWorkspaces();
                            wsManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                            try {
                                for (ICopyFileAreaView.IRepoView repoView : repoViews) {
                                    workspaces.add(wsManager.getWorkspaceConnection(repoView.getHandle(), null));
                                }
                            }
                            catch (TeamRepositoryException e) {
                                throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.AcceptCmd_14);
                            }
                            lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
                            for (IWorkspaceConnection wsConn : workspaces) {
                                try {
                                    cpHandles = wsConn.getComponents();
                                }
                                catch (TeamRepositoryException e) {
                                    throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.AcceptCmd_15);
                                }
                                for (IComponentHandle cpHandle : cpHandles) {
                                    lcm.syncPendingChanges(wsConn.getContextHandle(), cpHandle, this.cfaRoot);
                                    lcs = lcm.getPendingChanges(wsConn.getContextHandle(), cpHandle, this.cfaRoot);
                                    if (lcs.length <= 0) continue;
                                    throw StatusHelper.conflict((String)Messages.AcceptCmd_16);
                                }
                            }
                        }
                        handler = new VerboseAcceptProblemHandler();
                        op = IEclipseFileSystemManager.instance.getAcceptOperation((AcceptDilemmaHandler)handler);
                        op.acceptCombined(flow.getSubject(), flow.syncReport, flow.getNewBasis(), flow.getChangesToFlow());
                        if (!this.quiet && !preflight) {
                            System.out.println(Messages.AcceptCmd_1);
                        }
                        try {
                            writer = null;
                            if (!this.quiet) {
                                writer = new DownloadProgressWriter((IProgressMonitor)new NullProgressMonitor(), this.verbose, this.quiet);
                            }
                            op.run(writer);
                            if (writer != null) {
                                writer.join();
                            }
                            break block25;
                        }
                        catch (FileSystemClientException e) {
                            statuses = ExceptionUtil.findDescendents((IStatus)e.getStatus());
                            ** for (descendent : statuses)
                        }
lbl-1000:
                        // 1 sources

                        {
                            if (descendent.getCode() == 369) continue;
                            throw StatusHelper.internalError((String)Messages.AcceptCmd_20, (Exception)e);
                        }
lbl53:
                        // 1 sources

                        throw StatusHelper.misconfiguredLocalFS((String)e.getMessage());
                        catch (TeamRepositoryException e) {
                            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.AcceptCmd_2);
                        }
                        catch (OperationCanceledException v0) {
                            if (handler.exceptions.size() <= 0) break block26;
                            if (handler.exceptions.size() == 1) {
                                throw StatusHelper.wrap((TeamRepositoryException)handler.exceptions.get((int)0).exception, (String)Messages.AcceptCmd_3);
                            }
                            System.err.println(Messages.AcceptCmd_4);
                            ** for (rec : handler.exceptions)
                        }
lbl-1000:
                        // 1 sources

                        {
                            fsce = StatusHelper.wrap((TeamRepositoryException)rec.exception, (String)rec.exception.getLocalizedMessage());
                            System.err.println(NLS.bind((String)("  " + Messages.AcceptCmd_5), (Object)rec.workspaceConnection.getName(), (Object)fsce.getLocalizedMessage()));
                            continue;
                        }
lbl65:
                        // 1 sources

                        throw StatusHelper.failure((String)Messages.AcceptCmd_6, null);
                    }
                    if (handler.outOfSyncShares != null) {
                        System.err.println(Messages.AcceptCmd_7);
                        for (IShareOutOfSync sync : handler.outOfSyncShares) {
                            System.err.println("  " + sync.getShare().getAnchor());
                        }
                        throw StatusHelper.outOfSync((String)Messages.AcceptCmd_8);
                    }
                    throw StatusHelper.failure((String)Messages.AcceptCmd_9, null);
                }
            }
            if (!this.quiet && !preflight) {
                System.out.println(Messages.AcceptCmd_10);
            }
            this.handleChanges(flow, updateReport, this.cfaRoot == null);
            if (!updateReport.hasErrors()) continue;
            conflict = true;
            this.handleConflicts(flow, updateReport, this.cfaRoot == null);
        }
        if (conflict) {
            throw StatusHelper.conflict((String)Messages.AcceptCmd_11);
        }
    }

    protected IUpdateReport flowRemote(AbstractFlowGroup flow, boolean preflight) throws FileSystemClientException {
        try {
            return flow.getSubject().accept(preflight ? 1 : 0, flow.syncReport, flow.getNewBasis(), flow.getChangesToFlow(), null);
        }
        catch (GapException gapException) {
            throw StatusHelper.gap((String)Messages.AcceptCmd_18);
        }
        catch (NWayConflictUnsupportedException nWayConflictUnsupportedException) {
            throw StatusHelper.nWayConflict((String)Messages.AcceptCmd_17);
        }
        catch (TeamRepositoryException e) {
            if (this.hasMismatchedComponents(flow.syncReport)) {
                throw StatusHelper.disallowed((String)Messages.AcceptCmd_19);
            }
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.AcceptCmd_12);
        }
    }

    private void handleChanges(AbstractFlowGroup flow, IUpdateReport updateReport, boolean isRemote) throws FileSystemClientException {
        IndentingPrintStream out = new IndentingPrintStream((OutputStream)System.out).indent();
        ChangeDisplayer.showChanges(this.cfaRoot, flow.getSubject(), flow.getChangesToFlow(), this.verbose, this.quiet, out);
        ChangeDisplayer.showConflicts(flow.getSubject(), this.cfaRoot, updateReport, out);
    }

    private void handleConflicts(AbstractFlowGroup flow, IUpdateReport updateReport, boolean isRemote) throws FileSystemClientException {
        AbstractConflictHandler handler = this.useInPlaceConflictHandler && !isRemote ? new InPlaceConflictHandler() : new NonModifyingConflictHandler();
        handler.configureVerbose(this.verbose);
        handler.configureQuiet(this.quiet);
        handler.handleConflicts(this.cfaRoot, flow.getSubject(), flow.includedComponents, updateReport);
    }

    @Override
    protected AbstractFlowGroup createFlowGroup(IWorkspaceConnection subject, List<IComponentHandle> componentsToFlow, IWorkspaceConnection collab) {
        return new AcceptFlowGroup(subject, componentsToFlow, collab);
    }

    @Override
    protected String findFlowDescription(AbstractFlowGroup flow) {
        return NLS.bind((String)Messages.AcceptCmd_13, (Object)flow.getSource().getName(), (Object)flow.getTarget().getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VerboseAcceptProblemHandler
    extends AcceptDilemmaHandler {
        LinkedList<ExceptionRecord> exceptions = new LinkedList();
        Collection<IShareOutOfSync> outOfSyncShares = null;

        public int acceptChangeSetsProblem(IWorkspaceConnection workspaceConnection, List<? extends IChangeSetHandle> changeSets, TeamRepositoryException exception) {
            this.exceptions.add(new ExceptionRecord(workspaceConnection, exception));
            return 1;
        }

        public int acceptCombinedProblem(IWorkspaceConnection workspaceConnection, IChangeHistorySyncReport syncReport, List<? extends IBaselineHandle> baselines, List<? extends IChangeSetHandle> changeSets, TeamRepositoryException exception) {
            this.exceptions.add(new ExceptionRecord(workspaceConnection, exception));
            return 1;
        }

        public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
            this.outOfSyncShares = sharesOutOfSync;
            return 1;
        }

        public boolean willIgnoreAllSharesOutOfSync() {
            return false;
        }

        protected static class ExceptionRecord {
            final IWorkspaceConnection workspaceConnection;
            final TeamRepositoryException exception;

            public ExceptionRecord(IWorkspaceConnection conn, TeamRepositoryException e) {
                this.workspaceConnection = conn;
                this.exception = e;
            }
        }
    }
}

