/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.createcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.OptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.PositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspaceHandle;
import org.eclipse.osgi.util.NLS;

public class CreateWorkspaceCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final IOptionKey OPT_STREAM = new OptionKey("stream");
    public static final IOptionKey OPT_DESC = new OptionKey("desc");
    public static final IOptionKey OPT_WORKSPACE_NAME = new OptionKey("workspace-name");

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        options.setLongHelp(Messages.CreateWorkspaceCmd_3);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(OPT_WORKSPACE_NAME, "name", 1, 1), Messages.CreateWorkspaceCmd_5).addOption(OPT_STREAM, "s", "stream", Messages.CreateWorkspaceCmd_8, 1).addOption(OPT_DESC, "d", "description", Messages.CreateWorkspaceCmd_11, 1);
        return options;
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        IWorkspaceConnection wsConn;
        ConnectionInfo connectionInfo = config.getConnectionInfo();
        ICommandLine subargs = config.getSubcommandCommandLine();
        String wsName = subargs.getOption(OPT_WORKSPACE_NAME);
        String wsDesc = "";
        if (subargs.hasOption(OPT_DESC)) {
            wsDesc = subargs.getOption(OPT_DESC);
        }
        String flowToStream = null;
        if (subargs.hasOption(OPT_STREAM)) {
            flowToStream = subargs.getOption(OPT_STREAM);
        }
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)connectionInfo);
        IContributor contrib = repo.loggedInContributor();
        IWorkspaceHandle stream = null;
        if (flowToStream != null) {
            try {
                stream = RepoUtil.findNamedWorkspace((String)flowToStream, (boolean)false, (boolean)true, (ITeamRepository)repo);
            }
            catch (RepoUtil.UnmatchedSelectorException e) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateWorkspaceCmd_2, (Object)flowToStream));
            }
            catch (RepoUtil.AmbiguousSelectorException e) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateWorkspaceCmd_1, (Object)flowToStream));
            }
        }
        try {
            wsConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).createWorkspace((IContributorHandle)contrib, wsName, wsDesc, stream, stream, null);
        }
        catch (PermissionDeniedException e) {
            throw StatusHelper.permissionFailure((PermissionDeniedException)e);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.CreateWorkspaceCmd_0);
        }
        IComponent component = null;
        if (flowToStream == null) {
            component = RepoUtil.createComponentOnWorkspace((IWorkspaceConnection)wsConn, (String)NLS.bind((String)Messages.CreateWorkspaceCmd_13, (Object)wsName));
        }
        System.out.println(NLS.bind((String)Messages.CreateWorkspaceCmd_12, (Object)AliasUtil.selector((String)wsConn.getName(), (UUID)wsConn.getResolvedWorkspace().getItemId())));
        if (component != null) {
            System.out.println(NLS.bind((String)Messages.CreateWorkspaceCmd_14, (Object)AliasUtil.selector((String)component.getName(), (UUID)component.getItemId())));
        }
    }
}

