/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.createcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.INamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.NamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.PositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ConflictsProhibitOperationException;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class CreateBaselineCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final NamedOptionDefinition OPT_BASELINE_DESCRIPTION = new NamedOptionDefinition(null, "description", 1);
    public static final PositionalOptionDefinition OPT_WORKSPACE_NAME = new PositionalOptionDefinition("workspace-name", 1, 1);
    public static final PositionalOptionDefinition OPT_BASELINE_NAME = new PositionalOptionDefinition("baseline-name", 1, 1);

    public void run(IClientConfiguration config) throws FileSystemClientException {
        List componentHandles;
        IWorkspaceConnection workspaceConnection;
        ICommandLine subargs = config.getSubcommandCommandLine();
        String workspaceName = null;
        List componentNames = null;
        String baselineDescription = null;
        workspaceName = subargs.getOption((IOptionKey)OPT_WORKSPACE_NAME);
        boolean allComponents = subargs.hasOption((IOptionKey)CommonOptions.OPT_ALL);
        if (allComponents && subargs.hasOption((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR)) {
            throw StatusHelper.argSyntax((String)Messages.CreateBaselineCmd_5);
        }
        if (!allComponents) {
            if (!subargs.hasOption((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR)) {
                throw StatusHelper.argSyntax((String)Messages.CreateBaselineCmd_6);
            }
            componentNames = subargs.getOptions((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR);
        }
        String baselineName = subargs.getOption((IOptionKey)OPT_BASELINE_NAME);
        if (subargs.hasOption((IOptionKey)OPT_BASELINE_DESCRIPTION)) {
            baselineDescription = subargs.getOption((IOptionKey)OPT_BASELINE_DESCRIPTION);
        }
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)config.getConnectionInfo());
        try {
            workspaceConnection = RepoUtil.findNamedWorkspaceConnection((String)workspaceName, (boolean)true, (boolean)false, (ITeamRepository)repo);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateBaselineCmd_1, (Object)e.getSelector()));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateBaselineCmd_0, (Object)e.getSelector()));
        }
        if (allComponents) {
            try {
                componentHandles = workspaceConnection.getComponents();
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.CreateBaselineCmd_11);
            }
        }
        try {
            componentHandles = RepoUtil.findNamedComponents((List)componentNames, (boolean)false, (IWorkspaceConnection)workspaceConnection, (ITeamRepository)repo);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
            throw StatusHelper.ambiguousSelector((String)Messages.CreateBaselineCmd_12);
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
            throw StatusHelper.ambiguousSelector((String)Messages.CreateBaselineCmd_13);
        }
        if (!config.isDryRun()) {
            try {
                for (IComponentHandle component : componentHandles) {
                    workspaceConnection.createBaseline(component, baselineName, baselineDescription, null);
                }
            }
            catch (ConflictsProhibitOperationException conflictsProhibitOperationException) {
                throw StatusHelper.conflict((String)Messages.CreateBaselineCmd_20);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.CreateBaselineCmd_14);
            }
        }
    }

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        options.setLongHelp(Messages.CreateBaselineCmd_15);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)OPT_BASELINE_DESCRIPTION, Messages.CreateBaselineCmd_16).addOption((INamedOptionDefinition)CommonOptions.OPT_ALL, CommonOptions.OPT_ALL_HELP).addOption((IPositionalOptionDefinition)OPT_WORKSPACE_NAME, Messages.CreateBaselineCmd_17).addOption((IPositionalOptionDefinition)OPT_BASELINE_NAME, Messages.CreateBaselineCmd_18).addOption((IPositionalOptionDefinition)CommonOptions.OPT_COMPONENTS_SELECTOR, CommonOptions.OPT_COMPONENTS_SELECTOR_HELP);
        return options;
    }
}

