/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal.xml;

import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.serialize.IPrimitiveHandler;
import com.ibm.team.repository.common.serialize.IPrimitiveRegistry;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.serialize.internal.NamespaceRegistry;
import com.ibm.team.repository.common.serialize.internal.ObjectGraphVisitor;
import com.ibm.team.repository.common.serialize.internal.ObjectGraphVisitorInfo;
import com.ibm.team.repository.common.serialize.internal.ObjectGraphWalker;
import com.ibm.team.repository.common.serialize.internal.Serializer;
import com.ibm.team.repository.common.serialize.internal.SerializingWriter;
import com.ibm.team.repository.common.serialize.internal.Util;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;

public class XMLSerializer_03
extends Serializer {
    private static final IPrimitiveRegistry PrimitiveReg = IPrimitiveRegistry.INSTANCE;
    private static final NamespaceRegistry NamespaceReg = NamespaceRegistry.INSTANCE;
    public static final String STRING_SER_PREFIX = NamespaceReg.getPrefix("http://www.ibm.com/team/1.0.0/Serializer/0.3");
    public static final String STRING_LIST_TAG = "list";
    public static final String STRING_ITEM_TAG = "item";
    public static final String STRING_NULL_TAG = "null";
    public static final String STRING_LIST_BEGIN = "<" + STRING_SER_PREFIX + ":" + "list" + ">";
    public static final String STRING_LIST_END = "</" + STRING_SER_PREFIX + ":" + "list" + ">";
    public static final String STRING_ITEM_BEGIN = "<" + STRING_SER_PREFIX + ":" + "item" + ">";
    public static final String STRING_ITEM_END = "</" + STRING_SER_PREFIX + ":" + "item" + ">";
    public static final String STRING_ITEM_NULL = "<" + STRING_SER_PREFIX + ":" + "null" + "/>";

    public String getFormat() {
        return "xml";
    }

    public String getVersion() {
        return "0.3";
    }

    public void serializeEObject(SerializingWriter sWriter, EObject eObject, Class expectedType) throws SerializeException {
        try {
            this.serializeEObject(sWriter, eObject, expectedType, true);
        }
        catch (IOException e) {
            throw SerializeException.from(e);
        }
    }

    private void serializeEObject(SerializingWriter sWriter, EObject eObject, Class expectedType, boolean first) throws SerializeException, IOException {
        if (eObject == null) {
            return;
        }
        if (this.shouldMorphItemToHandle(eObject, expectedType)) {
            eObject = this.morphItemToHandle(eObject);
        }
        EClass eClass = eObject.eClass();
        String nsPrefix = NamespaceReg.getPrefix(eClass.getEPackage());
        sWriter.indent();
        sWriter.write("<");
        sWriter.write(nsPrefix);
        sWriter.write(":");
        sWriter.write(eClass.getName());
        sWriter.indentPush();
        if (first) {
            sWriter.nl();
            sWriter.indent();
            sWriter.write(" xmlns:");
            sWriter.write(NamespaceReg.getPrefix("http://www.ibm.com/team/1.0.0/Serializer"));
            sWriter.write("=\"");
            sWriter.write("http://www.ibm.com/team/1.0.0/Serializer");
            sWriter.write("\"");
            sWriter.nl();
            sWriter.indent();
            sWriter.write(" xmlns:");
            sWriter.write(NamespaceReg.getPrefix("http://www.ibm.com/team/1.0.0/Serializer/0.3"));
            sWriter.write("=\"");
            sWriter.write("http://www.ibm.com/team/1.0.0/Serializer/0.3");
            sWriter.write("\"");
            List ePackages = this.gatherNsURIs(eObject);
            for (EPackage ePackage : ePackages) {
                String prefix = NamespaceReg.getPrefix(ePackage);
                String nsURI = ePackage.getNsURI();
                sWriter.nl();
                sWriter.indent();
                sWriter.write(" xmlns:");
                sWriter.write(prefix);
                sWriter.write("=\"");
                sWriter.write(nsURI);
                sWriter.write("\"");
            }
            sWriter.nl();
            sWriter.indent();
            sWriter.write(" ");
            sWriter.write(NamespaceReg.getPrefix("http://www.ibm.com/team/1.0.0/Serializer"));
            sWriter.write(":");
            sWriter.write("serializeVersion");
            sWriter.write("=\"");
            sWriter.write("0.3");
            sWriter.write("\"");
            sWriter.nl();
            sWriter.indent();
        }
        sWriter.indentPop();
        sWriter.write(">");
        sWriter.nl();
        sWriter.indentPush();
        List sfs = Util.getStructuralFeatures(eClass, null);
        for (EStructuralFeature sf : sfs) {
            if (!eObject.eIsSet(sf)) continue;
            Object value = eObject.eGet(sf);
            sWriter.indent();
            sWriter.write("<");
            sWriter.write(nsPrefix);
            sWriter.write(":");
            sWriter.write(sf.getName());
            sWriter.write(">");
            this.serializeObject(sWriter, value, sf.getEType().getInstanceClass());
            sWriter.write("</");
            sWriter.write(nsPrefix);
            sWriter.write(":");
            sWriter.write(sf.getName());
            sWriter.write(">");
            sWriter.nl();
        }
        sWriter.indentPop();
        sWriter.indent();
        sWriter.write("</");
        sWriter.write(NamespaceReg.getPrefixedName(eClass));
        sWriter.write(">");
        sWriter.nl();
    }

    private void serializeObject(SerializingWriter sWriter, Object object, Class expectedType) throws SerializeException, IOException {
        if (object == null) {
            sWriter.write(STRING_ITEM_NULL);
            return;
        }
        if (PrimitiveReg.isPrimitive(object.getClass())) {
            this.serializePrimitive(sWriter, object);
            return;
        }
        if (object instanceof Enumerator) {
            this.writeEscapedString(((Enumerator)object).getLiteral(), sWriter);
            return;
        }
        if (object instanceof List) {
            this.serializeArrayOrList(sWriter, object, expectedType);
            return;
        }
        if (object.getClass().isArray()) {
            this.serializeArrayOrList(sWriter, object, expectedType);
            return;
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            sWriter.nl();
            sWriter.indentPush();
            this.serializeEObject(sWriter, eObject, expectedType, false);
            sWriter.indentPop();
            sWriter.indent();
            return;
        }
        throw new SerializeException(NLS.bind((String)Messages.getServerString("XMLSerializer_03.ErrorUnserializableObject"), (Object[])new Object[]{object}));
    }

    private void serializePrimitive(SerializingWriter sWriter, Object object) throws SerializeException, IOException {
        IPrimitiveHandler primHandler = IPrimitiveRegistry.INSTANCE.getHandler(object.getClass());
        if (primHandler == null) {
            throw new SerializeException(NLS.bind((String)Messages.getServerString("XMLSerializer_03.ErrorMissingHandler"), (Object[])new Object[]{object.getClass()}));
        }
        String value = primHandler.objectToString(object);
        this.writeEscapedString(value, sWriter);
    }

    private void serializeArrayOrList(SerializingWriter sWriter, Object arrayOrList, Class expectedType) throws SerializeException, IOException {
        int length;
        List list = null;
        Object array = null;
        if (arrayOrList instanceof List) {
            list = (List)arrayOrList;
            length = list.size();
        } else {
            array = arrayOrList;
            length = Array.getLength(array);
        }
        sWriter.indentPush();
        sWriter.nl();
        sWriter.indent();
        sWriter.write(STRING_LIST_BEGIN);
        sWriter.indentPush();
        sWriter.nl();
        int index = 0;
        while (index < length) {
            Object element = list != null ? list.get(index) : Array.get(array, index);
            sWriter.indent();
            sWriter.write(STRING_ITEM_BEGIN);
            this.serializeObject(sWriter, element, expectedType);
            sWriter.write(STRING_ITEM_END);
            sWriter.nl();
            ++index;
        }
        sWriter.indentPop();
        sWriter.indent();
        sWriter.write(STRING_LIST_END);
        sWriter.nl();
        sWriter.indentPop();
        sWriter.indent();
    }

    private List gatherNsURIs(Object object) throws SerializeException {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        List list = NamespaceRegistry.INSTANCE.getAllURIs();
        for (String uri : list) {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(uri);
            if (ePackage == null) continue;
            ePackages.add(ePackage);
        }
        return ePackages;
    }

    private List gatherNsURIsShortest(Object object) throws SerializeException {
        final HashSet ePackages = new HashSet();
        ObjectGraphVisitor visitor = new ObjectGraphVisitor(){

            public void visit(ObjectGraphVisitorInfo info) throws SerializeException {
                if (info.object == null) {
                    return;
                }
                if (info.structuralFeature != null) {
                    ePackages.add(info.structuralFeature.getEContainingClass().getEPackage());
                    ePackages.add(info.structuralFeature.getEType().getEPackage());
                }
                if (!(info.object instanceof EObject)) {
                    return;
                }
                EObject eObject = (EObject)info.object;
                EClass eClass = eObject.eClass();
                if (eClass == null) {
                    return;
                }
                if (eClass != null) {
                    ePackages.add(eClass.getEPackage());
                }
            }
        };
        ObjectGraphWalker walker = ObjectGraphWalker.newInstance(object);
        walker.walk(visitor);
        return new ArrayList(ePackages);
    }

    private void writeEscapedString(String string, SerializingWriter sWriter) throws SerializeException, IOException {
        StringBuffer sb = new StringBuffer(string);
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            switch (c) {
                case '&': {
                    sb.replace(i, i + 1, "&amp;");
                    i += 4;
                    break;
                }
                case '<': {
                    sb.replace(i, i + 1, "&lt;");
                    i += 3;
                    break;
                }
                case '>': {
                    sb.replace(i, i + 1, "&gt;");
                    i += 3;
                }
            }
            ++i;
        }
        sWriter.write(sb.toString());
    }
}

