/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal.xml;

import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.serialize.IDeserializeResult;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.serialize.internal.DeserializeResult;
import com.ibm.team.repository.common.serialize.internal.Deserializer;
import com.ibm.team.repository.common.serialize.internal.xml.ParserPool;
import com.ibm.team.repository.common.serialize.internal.xml.XMLDeserializer_03;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.emf.ecore.EObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLDeserializer
extends Deserializer {
    private static XMLDeserializer_03 xmlDeserializer_03 = new XMLDeserializer_03();

    public String getFormat() {
        return "xml";
    }

    public IDeserializeResult deserialize(Reader reader) throws SerializeException {
        DocumentBuilder documentBuilder = ParserPool.INSTANCE.obtainDocumentBuilder();
        try {
            InputSource inputSource = new InputSource(reader);
            Document document = documentBuilder.parse(inputSource);
            Element root = document.getDocumentElement();
            String mvAttr = root.getAttributeNS("http://www.ibm.com/team/1.0.0/Serializer", "serializeVersion");
            if (mvAttr == null) {
                throw new SerializeException(NLS.bind((String)Messages.getServerString("XMLDeserializer.ErrorMissingAttr"), (Object[])new Object[]{"http://www.ibm.com/team/1.0.0/Serializer", "serializeVersion"}));
            }
            if (mvAttr.equals("0.3")) {
                EObject eObject = xmlDeserializer_03.deserializeEObject(root);
                DeserializeResult deserializeResult = new DeserializeResult(eObject, mvAttr);
                return deserializeResult;
            }
            try {
                throw new SerializeException(NLS.bind((String)Messages.getServerString("XMLDeserializer.ErrorWrongVersion"), (Object[])new Object[]{mvAttr}));
            }
            catch (SAXException e) {
                throw SerializeException.from(e);
            }
            catch (IOException e) {
                throw SerializeException.from(e);
            }
        }
        finally {
            ParserPool.INSTANCE.releaseParser(documentBuilder);
        }
    }
}

