/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;

public class NamespaceRegistry {
    public static final NamespaceRegistry INSTANCE = new NamespaceRegistry();
    public static final String NSURI_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String NSURI_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String NSURI_SERIALIZER = "http://www.ibm.com/team/1.0.0/Serializer";
    public static final String NSURI_SERIALIZER_0_3 = "http://www.ibm.com/team/1.0.0/Serializer/0.3";
    public static final String NSURI_SERIALIZER_0_4 = "http://www.ibm.com/team/1.0.0/Serializer/0.4";
    private final Map uri2prefix = new HashMap();
    private final Map prefix2uri = new HashMap();
    private final Object lock = new Object();
    private int nsIndex = 0;

    private NamespaceRegistry() {
        this.registerDefaults();
    }

    private void registerDefaults() {
        this.register(NSURI_SERIALIZER);
        this.register(NSURI_SERIALIZER_0_3);
        this.register(NSURI_SERIALIZER_0_4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String register(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        Object object = this.lock;
        synchronized (object) {
            String prefix = String.valueOf(String.valueOf('n')) + this.nsIndex;
            ++this.nsIndex;
            this.uri2prefix.put(uri, prefix);
            this.prefix2uri.put(prefix, uri);
            return prefix;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURI(String prefix) {
        Object object = this.lock;
        synchronized (object) {
            return (String)this.prefix2uri.get(prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPrefix(EPackage ePackage) {
        Object object = this.lock;
        synchronized (object) {
            String result = (String)this.uri2prefix.get(ePackage.getNsURI());
            if (result != null) {
                return result;
            }
            return this.register(ePackage.getNsURI());
        }
    }

    public String getPrefix(EClass eClass) {
        return this.getPrefix(eClass.getEPackage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPrefix(String nsURI) {
        Object object = this.lock;
        synchronized (object) {
            return (String)this.uri2prefix.get(nsURI);
        }
    }

    public String getPrefixedName(EClass eClass) {
        String prefix = this.getPrefix(eClass.getEPackage());
        StringBuffer sb = new StringBuffer();
        sb.append(prefix);
        sb.append(':');
        sb.append(eClass.getName());
        return sb.toString();
    }

    public List getAllPrefixes() {
        return new ArrayList(this.prefix2uri.keySet());
    }

    public List getAllURIs() {
        return new ArrayList(this.uri2prefix.keySet());
    }
}

