/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.serialize.IPrimitiveRegistry;
import com.ibm.team.repository.common.serialize.ISerializer2;
import com.ibm.team.repository.common.serialize.IURISerializer;
import com.ibm.team.repository.common.transport.HttpUtil;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractSerializer
implements ISerializer2 {
    protected static final IPrimitiveRegistry PrimitiveReg = IPrimitiveRegistry.INSTANCE;
    private final HttpUtil.MediaType _mType;
    private final String _repoUri;
    private final boolean _format;
    protected final IURISerializer _uriSerializer;

    AbstractSerializer(HttpUtil.MediaType mType, String repoUri, boolean format, IURISerializer uriSerializer) {
        if (mType == null) {
            throw new IllegalArgumentException("MediaType must not be null");
        }
        if (repoUri == null) {
            throw new IllegalArgumentException("Repository URI must not be null");
        }
        if (uriSerializer == null) {
            throw new IllegalArgumentException("URI Serializer must not be null");
        }
        this._mType = mType;
        this._repoUri = repoUri;
        this._format = format;
        this._uriSerializer = uriSerializer;
    }

    public HttpUtil.MediaType getMediaType() {
        return this._mType;
    }

    public String getRepoUri() {
        return this._repoUri;
    }

    public boolean format() {
        return this._format;
    }

    protected boolean shouldMorphItemToHandle(EObject eObject, Class expectedType) {
        if (eObject == null) {
            return false;
        }
        if (!(eObject instanceof IItem)) {
            return false;
        }
        return !IItem.class.isAssignableFrom(expectedType);
    }

    public EObject morphItemToHandle(EObject item) {
        if (item == null) {
            return null;
        }
        return (EObject)((IItem)item).getItemHandle();
    }
}

