/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize;

import java.lang.reflect.Method;

public abstract class StackUtil {
    public static StackTraceElement[] pruneDownTo(Method m, StackTraceElement[] trace) {
        int pruneTo = 0;
        String className = m.getDeclaringClass().getCanonicalName();
        String methodName = m.getName();
        while (pruneTo < trace.length) {
            StackTraceElement frame = trace[pruneTo];
            if (frame.getClassName().equals(className) && frame.getMethodName().equals(methodName)) break;
            ++pruneTo;
        }
        if (pruneTo >= trace.length) {
            return trace;
        }
        int start = 0;
        int length = trace.length - pruneTo;
        StackTraceElement[] toReturn = new StackTraceElement[length];
        System.arraycopy(trace, pruneTo, toReturn, start, length - start);
        return toReturn;
    }

    public static StackTraceElement[] pruneUpTo(String className, StackTraceElement[] trace) {
        int pruneTo = trace.length - 1;
        while (pruneTo >= 0) {
            StackTraceElement frame = trace[pruneTo];
            if (frame.getClassName().endsWith(className)) break;
            --pruneTo;
        }
        if (pruneTo < 0) {
            return trace;
        }
        int size = pruneTo + 1;
        StackTraceElement[] toReturn = new StackTraceElement[size];
        System.arraycopy(trace, 0, toReturn, 0, toReturn.length);
        return toReturn;
    }

    public static StackTraceElement[] append(StackTraceElement[] trace, StackTraceElement[] toAppend) {
        StackTraceElement[] toReturn = new StackTraceElement[trace.length + toAppend.length];
        System.arraycopy(trace, 0, toReturn, 0, trace.length);
        System.arraycopy(toAppend, 0, toReturn, trace.length, toAppend.length);
        return toReturn;
    }
}

