/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.nls;

import com.ibm.team.repository.common.util.CommonMessages;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static final String BUNDLE_NAME = "com.ibm.team.repository.common.internal.nls.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.team.repository.common.internal.nls.messages");

    public static String getClientString(String key) {
        return CommonMessages.getString(Messages.class, (String)BUNDLE_NAME, (String)key);
    }

    public static String getServerString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            Messages.checkForWrongKey(key);
            return String.valueOf('!') + key + '!';
        }
    }

    private static void checkForWrongKey(String key) {
        String prefix = "_NoId.";
        boolean prefixExists = key.startsWith(prefix);
        String newKey = prefixExists ? key.substring(prefix.length()) : String.valueOf(prefix) + key;
        try {
            RESOURCE_BUNDLE.getString(newKey);
            String error = String.format("The message key \"%s\" is wrong.  It should be \"%s\".", key, newKey);
            System.err.println(error);
            throw new RuntimeException(error);
        }
        catch (MissingResourceException missingResourceException) {
            return;
        }
    }

    private Messages() {
    }
}

