/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.marshal.util;

import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.marshal.Marshaller;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.serialize.IStackAdjuster;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.xmlsoap.schemas.soap.envelope.Fault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshallerUtil {
    public static final String CAUSE = "cause:";
    private static final String NEXT = "next:";
    private static final String ERROR_CODE = "errorCode:";
    private static final String SQLSTATE = "SQLState:";
    public static final String MARSHALLER_ANNOTATION = "http:///com/ibm/team/core/marshal";
    public static final String MARSHALLER_CONTAINMENT_ANNOTATION_KEY = "containment";
    private static final String STACK_TRACE_TOKEN = "Stack Trace follows:";

    public static boolean isComplexMarshaller(Marshaller marshaller) {
        return (marshaller.getMarshallerType().getValue() & MarshallerType.COMPLEX_LITERAL.getValue()) != 0;
    }

    public static boolean shouldConsiderAsContainment(EReference reference) {
        boolean containment;
        if (reference.isContainment()) {
            return true;
        }
        if (reference.getEReferenceType().getEPackage() == EcorePackage.eINSTANCE && reference.getEReferenceType() != EcorePackage.eINSTANCE.getEObject()) {
            return false;
        }
        String marshallerAnnotation = MarshallerUtil.getAnnotation((EStructuralFeature)reference, MARSHALLER_ANNOTATION, MARSHALLER_CONTAINMENT_ANNOTATION_KEY);
        boolean bl = containment = marshallerAnnotation != null && marshallerAnnotation.equals(String.valueOf(true));
        if (!containment) {
            return !ItemUtil.isHandle((EReference)reference);
        }
        return containment;
    }

    public static String getAnnotation(EStructuralFeature structuralFeature, String sourceAnnotationName, String detailsKey) {
        EAnnotation annotation = structuralFeature.getEAnnotation(sourceAnnotationName);
        if (annotation != null) {
            return (String)annotation.getDetails().get((Object)detailsKey);
        }
        return null;
    }

    public static boolean shouldBeMarshalled(EObject object, EStructuralFeature feature) {
        if (feature.isTransient()) {
            return false;
        }
        return object.eIsSet(feature);
    }

    public static String encodeExceptions(Throwable exception) {
        String marker = UUID.generate().getUuidValue();
        StringWriter result = new StringWriter(1000);
        PrintWriter output = new PrintWriter((Writer)result, true);
        output.println(marker);
        MarshallerUtil.encodeExceptions(marker, output, exception);
        output.close();
        String s = result.toString();
        return s;
    }

    private static void encodeExceptions(String marker, PrintWriter output, Throwable exception) {
        Class<?> exClass = exception.getClass();
        while (true) {
            String className = exClass.getName();
            output.print(className);
            if (className.startsWith("java.lang.")) break;
            output.print('>');
            exClass = exClass.getSuperclass();
        }
        output.println();
        String message = exception.getMessage();
        if (message != null) {
            output.print('>');
            output.print(message);
        }
        output.println(marker);
        StackTraceElement[] traceElements = exception.getStackTrace();
        output.println(traceElements.length);
        StackTraceElement[] stackTraceElementArray = traceElements;
        int n = traceElements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            output.print(element.getClassName());
            output.print(',');
            output.print(element.getMethodName());
            output.print(',');
            output.print(element.getFileName());
            output.print(',');
            output.print(element.getLineNumber());
            output.println();
            ++n2;
        }
        if (exception instanceof java.sql.SQLException) {
            java.sql.SQLException se = (java.sql.SQLException)exception;
            output.print(SQLSTATE);
            if (se.getSQLState() != null) {
                output.print(se.getSQLState());
            }
            output.println();
            output.print(ERROR_CODE);
            output.println(se.getErrorCode());
            se = se.getNextException();
            if (se == null) {
                return;
            }
            output.println(NEXT);
            MarshallerUtil.encodeExceptions(marker, output, se);
            return;
        }
        Throwable cause = exception.getCause();
        if (cause == null) {
            return;
        }
        output.println(CAUSE);
        MarshallerUtil.encodeExceptions(marker, output, cause);
    }

    public static Throwable decodeFault(Fault fault, ClassLoader classLoader) {
        Throwable throwable = MarshallerUtil.decodeExceptions(fault.getFaultstring(), classLoader);
        if (throwable == null) {
            return null;
        }
        EMap extraData = fault.getExtraData();
        MarshallerUtil.populateExtraData(throwable, (EMap<String, EObject>)extraData);
        return throwable;
    }

    private static void populateExtraData(Throwable throwable, EMap<String, EObject> extraData) {
        EObject value;
        if (extraData == null || extraData.isEmpty()) {
            return;
        }
        if (throwable instanceof PermissionDeniedException && (value = (EObject)extraData.get((Object)"processReportData")) != null) {
            ((PermissionDeniedException)throwable).setProcessReportData((Object)value);
        }
        if (throwable instanceof TeamRepositoryException && (value = (EObject)extraData.get((Object)"exceptionData")) != null) {
            ((TeamRepositoryException)throwable).setData((Object)value);
        }
    }

    public static Throwable decodeExceptions(String encodedException, ClassLoader classLoader) {
        return MarshallerUtil.decodeExceptions(encodedException, classLoader, null);
    }

    public static Throwable decodeExceptions(String encodedException, ClassLoader classLoader, IStackAdjuster adj) {
        StringReader sr = new StringReader(encodedException);
        LineNumberReader input = new LineNumberReader(sr);
        Throwable throwable = null;
        StackTraceElement[] localStackTrace = new Exception().fillInStackTrace().getStackTrace();
        try {
            String marker = input.readLine();
            if (marker == null) {
                MarshallerUtil.unparsable("Unable to read marker", input, encodedException);
            }
            throwable = MarshallerUtil.decodeExceptions(marker, input, classLoader, localStackTrace, adj, encodedException);
        }
        catch (IOException iOException) {
            MarshallerUtil.unparsable(null, input, encodedException);
        }
        return throwable;
    }

    private static Throwable decodeExceptions(String marker, LineNumberReader input, ClassLoader classLoader, StackTraceElement[] localStackTrace, IStackAdjuster adj, String encodedException) throws IOException {
        String line;
        String typeHierarchy = input.readLine();
        if (typeHierarchy == null) {
            return null;
        }
        String message = MarshallerUtil.extractExceptionMessage(marker, input);
        StackTraceElement[] elems = MarshallerUtil.extractStackTrace(input, localStackTrace, adj);
        String SQLState = null;
        int errorCode = 0;
        Throwable cause = null;
        SQLException next = null;
        while ((line = input.readLine()) != null) {
            Object tmp;
            if (line.startsWith(SQLSTATE)) {
                SQLState = line.substring(SQLSTATE.length());
                continue;
            }
            if (line.startsWith(ERROR_CODE)) {
                tmp = line.substring(ERROR_CODE.length());
                errorCode = Integer.parseInt((String)tmp);
                continue;
            }
            if (line.startsWith(NEXT)) {
                try {
                    tmp = MarshallerUtil.decodeExceptions(marker, input, classLoader, localStackTrace, adj, encodedException);
                    next = (SQLException)tmp;
                }
                catch (StackOverflowError stackOverflowError) {}
                break;
            }
            if (!line.startsWith(CAUSE)) break;
            try {
                cause = MarshallerUtil.decodeExceptions(marker, input, classLoader, localStackTrace, adj, encodedException);
            }
            catch (StackOverflowError error) {
                cause = error;
            }
            break;
        }
        if (SQLState != null || next != null) {
            SQLException se = new SQLException(message, SQLState, errorCode, next);
            se.setStackTrace(elems);
            return se;
        }
        String[] typeNames = typeHierarchy.split(">");
        Throwable exception = null;
        String backupMessage = "<Remote exception was of type '" + typeNames[0] + "'>\n" + message;
        int i = 0;
        while (i < typeNames.length) {
            String type = typeNames[i];
            try {
                exception = MarshallerUtil.constructException(type, i == 0 ? message : backupMessage, classLoader, elems, cause);
                if (exception != null) {
                    return exception;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            ++i;
        }
        exception = new Throwable(backupMessage, cause);
        exception.setStackTrace(elems);
        return exception;
    }

    private static StackTraceElement[] extractStackTrace(LineNumberReader input, StackTraceElement[] localStackTrace, IStackAdjuster adj) throws IOException {
        String line = input.readLine();
        int numElements = Integer.parseInt(line);
        StackTraceElement[] elems = new StackTraceElement[numElements + localStackTrace.length];
        int ndx = 0;
        while (ndx < numElements) {
            StackTraceElement elem;
            line = input.readLine();
            String[] parts = line.split(",");
            String className = parts[0];
            String methodName = parts[1];
            String fileName = parts[2];
            String lineNumber = parts[3];
            elems[ndx] = elem = new StackTraceElement(className, methodName, fileName, Integer.valueOf(lineNumber));
            ++ndx;
        }
        ndx = 0;
        while (ndx < localStackTrace.length) {
            elems[numElements + ndx] = localStackTrace[ndx];
            ++ndx;
        }
        if (adj != null) {
            elems = adj.adjustFrames(elems, numElements);
        }
        return elems;
    }

    private static String extractExceptionMessage(String marker, LineNumberReader input) throws IOException {
        StringBuilder msg = new StringBuilder();
        while (true) {
            int indexOf;
            String line = input.readLine();
            if (msg.length() > 0) {
                msg.append('\n');
            }
            if ((indexOf = line.indexOf(marker)) == 0) break;
            if (indexOf > 0) {
                msg.append(line, 0, indexOf);
                break;
            }
            msg.append(line);
        }
        if (msg.length() == 0) {
            return null;
        }
        msg.deleteCharAt(0);
        String message = msg.toString();
        return message;
    }

    private static void unparsable(String msg, LineNumberReader input, String encodedException) {
        if (msg == null) {
            msg = "Unparsable encoded exception";
        }
        msg = String.valueOf(msg) + "\nAt line " + input.getLineNumber() + "\nEncoded exception: " + encodedException;
        throw new RuntimeException(msg);
    }

    private static Throwable constructException(String exceptionType, String exceptionMesg, ClassLoader classLoader, StackTraceElement[] elems, Throwable cause) throws ClassNotFoundException {
        Class<?> exceptionClass = Class.forName(exceptionType, true, classLoader);
        Throwable result = null;
        result = MarshallerUtil.constructException(exceptionClass, new Class[]{String.class, Throwable.class}, new Object[]{exceptionMesg, cause});
        if (result == null && (result = MarshallerUtil.constructException(exceptionClass, new Class[]{String.class}, new Object[]{exceptionMesg})) == null) {
            if (exceptionMesg != null) {
                return null;
            }
            result = MarshallerUtil.constructException(exceptionClass, new Class[]{Throwable.class}, new Object[]{cause});
            if (result == null && (result = MarshallerUtil.constructException(exceptionClass, new Class[0], new Object[0])) == null) {
                return null;
            }
        }
        if (cause != result.getCause()) {
            try {
                result.initCause(cause);
            }
            catch (RuntimeException runtimeException) {
                cause = null;
            }
        }
        if (elems != null && elems.length > 0) {
            result.setStackTrace(elems);
        }
        return result;
    }

    private static Throwable constructException(Class exceptionClass, Class[] parameterTypes, Object[] parameterValues) {
        Constructor exceptionConstructor = null;
        Throwable result = null;
        try {
            exceptionConstructor = exceptionClass.getConstructor(parameterTypes);
            result = (Throwable)exceptionConstructor.newInstance(parameterValues);
            return result;
        }
        catch (SecurityException ex) {
        }
        catch (NoSuchMethodException ex) {
        }
        catch (IllegalArgumentException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (InvocationTargetException ex) {
        }
        catch (RuntimeException ex) {
        }
        return null;
    }

    public static String encodeStackTrace(Throwable exception) {
        StackTraceElement[] traceElements;
        StringBuffer buffer = new StringBuffer();
        StackTraceElement[] stackTraceElementArray = traceElements = exception.getStackTrace();
        int n = traceElements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            String encoded = String.valueOf(MarshallerUtil.nonNull(element.getClassName())) + ',' + MarshallerUtil.nonNull(element.getMethodName()) + ',' + MarshallerUtil.nonNull(element.getFileName()) + ',' + element.getLineNumber() + ',';
            buffer.append(encoded);
            ++n2;
        }
        return STACK_TRACE_TOKEN + buffer.toString();
    }

    public static Throwable decodeStackTrace(String encodedStackTrace) {
        Throwable stackTraceException = null;
        int stackTraceTextIndex = encodedStackTrace.indexOf(STACK_TRACE_TOKEN);
        String stackTraceText = null;
        if (stackTraceTextIndex != -1) {
            stackTraceText = encodedStackTrace.substring(stackTraceTextIndex + STACK_TRACE_TOKEN.length(), encodedStackTrace.length());
            int endMessageIndex = stackTraceTextIndex;
            String exceptionMesg = "Undefined Exception";
            if (endMessageIndex != 0) {
                exceptionMesg = encodedStackTrace.substring(0, endMessageIndex);
            }
            ArrayList<StackTraceElement> traceElements = new ArrayList<StackTraceElement>();
            StringTokenizer tokenizer = new StringTokenizer(stackTraceText, ",");
            while (tokenizer.hasMoreTokens()) {
                String className = tokenizer.nextToken();
                String methodName = tokenizer.nextToken();
                String fileName = tokenizer.nextToken();
                String lineNumber = tokenizer.nextToken();
                traceElements.add(new StackTraceElement(className, methodName, fileName, Integer.valueOf(lineNumber)));
            }
            stackTraceException = new Throwable(exceptionMesg);
            Exception e = new Exception();
            e.fillInStackTrace();
            StackTraceElement[] elements = e.getStackTrace();
            ArrayList<StackTraceElement> completedTrace = new ArrayList<StackTraceElement>();
            completedTrace.addAll(traceElements);
            completedTrace.addAll((Collection)Arrays.asList(elements));
            stackTraceException.setStackTrace(completedTrace.toArray(new StackTraceElement[completedTrace.size()]));
        }
        return stackTraceException;
    }

    private static String nonNull(String s) {
        return s == null ? "unknown" : s;
    }

    static class SQLException
    extends java.sql.SQLException {
        private final String SQLState;
        private final int vendorCode;
        private final SQLException next;

        public SQLException(String reason, String SQLState, int vendorCode, SQLException next) {
            super(reason);
            this.SQLState = "".equals(SQLState) ? null : SQLState;
            this.vendorCode = vendorCode;
            this.next = next;
        }

        public int getErrorCode() {
            return this.vendorCode;
        }

        public SQLException getNextException() {
            return this.next;
        }

        public String getSQLState() {
            return this.SQLState;
        }

        public Throwable getCause() {
            return this.next;
        }

        public String toString() {
            String msg = this.getLocalizedMessage();
            String name = "java.sql.SQLException";
            if (msg == null) {
                return name;
            }
            return new StringBuffer(name.length() + 2 + msg.length()).append(name).append(": ").append(msg).toString();
        }
    }
}

