/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.marshal.impl;

import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.impl.PrimitiveTypeMarshallerImpl;
import com.ibm.team.repository.common.transport.internal.services.DataArg;
import com.ibm.team.repository.common.transport.internal.services.DataArgType;
import com.ibm.team.repository.common.transport.internal.services.PrimitiveDataArg;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public class EnumeratorMarshaller
extends PrimitiveTypeMarshallerImpl {
    public static final String GETTER_METHOD_NAME = "get";

    public EnumeratorMarshaller() {
        this.setSupportedType(Enumerator.class);
        this.setMarshallerType(MarshallerType.ENUMERATOR_LITERAL);
    }

    public boolean canMarshal(Class type) {
        return Enumerator.class.isAssignableFrom(type);
    }

    public DataArgType getSupportedDataArgType() {
        return DataArgType.ENUMERATOR_LITERAL;
    }

    public void marshalObjectToOutputStream(Object object, OutputStream outputStream) throws MarshallingException {
    }

    public String marshalObjectToString(Object object) throws MarshallingException {
        return ((Enumerator)object).getName();
    }

    public Object demarshalInputStreamToObject(InputStream inputStream) throws MarshallingException {
        return null;
    }

    public Object demarshalInputStreamToObject(InputStream inputStream, Charset charset) throws MarshallingException {
        return null;
    }

    public Object demarshalDataArgToObject(DataArg dataArg, Class classZ) {
        String value = ((PrimitiveDataArg)dataArg).getValue();
        return this.getEnumerator(value, classZ);
    }

    protected List getTopLevelEObjects(DataArg dataArg) {
        return null;
    }

    public Object demarshalObjectFromString(String value) {
        return null;
    }

    private Enumerator getEnumerator(String enumeratorValue, Class classZ) {
        try {
            Method enumeratorGetterMethod = classZ.getDeclaredMethod(GETTER_METHOD_NAME, String.class);
            return (Enumerator)enumeratorGetterMethod.invoke(null, enumeratorValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

