/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.osgi.framework.ServicePermission;

final class ServicePermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = 662615640374640621L;
    private Hashtable permissions = new Hashtable();
    private boolean all_allowed = false;

    public void add(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            throw (Throwable)new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw (Throwable)new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        ServicePermission servicePermission = (ServicePermission)permission;
        String string = servicePermission.getName();
        ServicePermission servicePermission2 = (ServicePermission)this.permissions.get(string);
        if (servicePermission2 != null) {
            int n;
            int n2 = servicePermission2.getMask();
            if (n2 != (n = servicePermission.getMask())) {
                this.permissions.put(string, new ServicePermission(string, n2 | n));
            }
        } else {
            this.permissions.put(string, permission);
        }
        if (!this.all_allowed && string.equals("*")) {
            this.all_allowed = true;
        }
    }

    public boolean implies(Permission permission) {
        int n;
        ServicePermission servicePermission;
        if (!(permission instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission2 = (ServicePermission)permission;
        int n2 = servicePermission2.getMask();
        int n3 = 0;
        if (this.all_allowed && (servicePermission = (ServicePermission)this.permissions.get("*")) != null && ((n3 |= servicePermission.getMask()) & n2) == n2) {
            return true;
        }
        String string = servicePermission2.getName();
        servicePermission = (ServicePermission)this.permissions.get(string);
        if (servicePermission != null && ((n3 |= servicePermission.getMask()) & n2) == n2) {
            return true;
        }
        int n4 = string.length() - 1;
        while ((n = string.lastIndexOf(".", n4)) != -1) {
            servicePermission = (ServicePermission)this.permissions.get(string = String.valueOf(string.substring(0, n + 1)) + "*");
            if (servicePermission != null && ((n3 |= servicePermission.getMask()) & n2) == n2) {
                return true;
            }
            n4 = n - 1;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

