/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.osgi.framework.PackagePermission;

final class PackagePermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = -3350758995234427603L;
    private Hashtable permissions = new Hashtable();
    private boolean all_allowed = false;

    public void add(Permission permission) {
        if (!(permission instanceof PackagePermission)) {
            throw (Throwable)new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw (Throwable)new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        PackagePermission packagePermission = (PackagePermission)permission;
        String string = packagePermission.getName();
        PackagePermission packagePermission2 = (PackagePermission)this.permissions.get(string);
        if (packagePermission2 != null) {
            int n;
            int n2 = packagePermission2.getMask();
            if (n2 != (n = packagePermission.getMask())) {
                this.permissions.put(string, new PackagePermission(string, n2 | n));
            }
        } else {
            this.permissions.put(string, permission);
        }
        if (!this.all_allowed && string.equals("*")) {
            this.all_allowed = true;
        }
    }

    public boolean implies(Permission permission) {
        int n;
        PackagePermission packagePermission;
        if (!(permission instanceof PackagePermission)) {
            return false;
        }
        PackagePermission packagePermission2 = (PackagePermission)permission;
        int n2 = packagePermission2.getMask();
        int n3 = 0;
        if (this.all_allowed && (packagePermission = (PackagePermission)this.permissions.get("*")) != null && ((n3 |= packagePermission.getMask()) & n2) == n2) {
            return true;
        }
        String string = packagePermission2.getName();
        packagePermission = (PackagePermission)this.permissions.get(string);
        if (packagePermission != null && ((n3 |= packagePermission.getMask()) & n2) == n2) {
            return true;
        }
        int n4 = string.length() - 1;
        while ((n = string.lastIndexOf(".", n4)) != -1) {
            packagePermission = (PackagePermission)this.permissions.get(string = String.valueOf(string.substring(0, n + 1)) + "*");
            if (packagePermission != null && ((n3 |= packagePermission.getMask()) & n2) == n2) {
                return true;
            }
            n4 = n - 1;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

