/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.framework.PackagePermissionCollection;

public final class PackagePermission
extends BasicPermission {
    static final long serialVersionUID = -5107705877071099135L;
    public static final String EXPORT = "export";
    public static final String IMPORT = "import";
    private static final int ACTION_EXPORT = 1;
    private static final int ACTION_IMPORT = 2;
    private static final int ACTION_ALL = 3;
    private static final int ACTION_NONE = 0;
    private transient int action_mask = 0;
    private String actions = null;

    public PackagePermission(String string, String string2) {
        this(string, PackagePermission.getMask(string2));
    }

    PackagePermission(String string, int n) {
        super(string);
        this.init(n);
    }

    private void init(int n) {
        if (n == 0 || (n & 3) != n) {
            throw (Throwable)new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String var0) {
        var1_1 = false;
        var2_2 = 0;
        if (var0 == null) {
            return var2_2;
        }
        var3_3 = var0.toCharArray();
        var4_4 = var3_3.length - 1;
        if (var4_4 >= 0) ** GOTO lbl33
        return var2_2;
        {
            --var4_4;
            do {
                if (var4_4 != -1 && ((var5_5 = var3_3[var4_4]) == ' ' || var5_5 == '\r' || var5_5 == '\n' || var5_5 == '\f' || var5_5 == '\t')) continue block4;
                if (!(var4_4 < 5 || var3_3[var4_4 - 5] != 'i' && var3_3[var4_4 - 5] != 'I' || var3_3[var4_4 - 4] != 'm' && var3_3[var4_4 - 4] != 'M' || var3_3[var4_4 - 3] != 'p' && var3_3[var4_4 - 3] != 'P' || var3_3[var4_4 - 2] != 'o' && var3_3[var4_4 - 2] != 'O' || var3_3[var4_4 - 1] != 'r' && var3_3[var4_4 - 1] != 'R' || var3_3[var4_4] != 't' && var3_3[var4_4] != 'T')) {
                    var6_6 = 6;
                    var2_2 |= 2;
                } else if (!(var4_4 < 5 || var3_3[var4_4 - 5] != 'e' && var3_3[var4_4 - 5] != 'E' || var3_3[var4_4 - 4] != 'x' && var3_3[var4_4 - 4] != 'X' || var3_3[var4_4 - 3] != 'p' && var3_3[var4_4 - 3] != 'P' || var3_3[var4_4 - 2] != 'o' && var3_3[var4_4 - 2] != 'O' || var3_3[var4_4 - 1] != 'r' && var3_3[var4_4 - 1] != 'R' || var3_3[var4_4] != 't' && var3_3[var4_4] != 'T')) {
                    var6_6 = 6;
                    var2_2 |= 3;
                } else {
                    throw (Throwable)new IllegalArgumentException("invalid permission: " + var0);
                }
                var1_1 = false;
                while (var4_4 >= var6_6 && !var1_1) {
                    switch (var3_3[var4_4 - var6_6]) {
                        case ',': {
                            var1_1 = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw (Throwable)new IllegalArgumentException("invalid permission: " + var0);
                        }
                    }
                    --var4_4;
                }
                var4_4 -= var6_6;
lbl33:
                // 2 sources

            } while (var4_4 != -1);
        }
        if (var1_1) {
            throw (Throwable)new IllegalArgumentException("invalid permission: " + var0);
        }
        return var2_2;
    }

    public boolean implies(Permission permission) {
        if (permission instanceof PackagePermission) {
            PackagePermission packagePermission = (PackagePermission)permission;
            return (this.action_mask & packagePermission.action_mask) == packagePermission.action_mask && super.implies(permission);
        }
        return false;
    }

    public String getActions() {
        if (this.actions == null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if ((this.action_mask & 1) == 1) {
                stringBuffer.append(EXPORT);
                bl = true;
            }
            if ((this.action_mask & 2) == 2) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(IMPORT);
            }
            this.actions = stringBuffer.toString();
        }
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new PackagePermissionCollection();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PackagePermission)) {
            return false;
        }
        PackagePermission packagePermission = (PackagePermission)object;
        return this.action_mask == packagePermission.action_mask && this.getName().equals(packagePermission.getName());
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getActions().hashCode();
    }

    int getMask() {
        return this.action_mask;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(PackagePermission.getMask(this.actions));
    }
}

