/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.internal.provisional.verifier.CertificateChain;
import org.eclipse.osgi.internal.provisional.verifier.CertificateTrustAuthority;
import org.eclipse.osgi.internal.provisional.verifier.CertificateVerifier;
import org.eclipse.osgi.internal.verifier.Base64;
import org.eclipse.osgi.internal.verifier.DNChainMatching;
import org.eclipse.osgi.internal.verifier.DefaultTrustAuthority;
import org.eclipse.osgi.internal.verifier.JarVerifierConstant;
import org.eclipse.osgi.internal.verifier.JarVerifierMessages;
import org.eclipse.osgi.internal.verifier.PKCS7Processor;
import org.eclipse.osgi.internal.verifier.SignedBundleFile$SignedBundleEntry;
import org.eclipse.osgi.internal.verifier.SignedBundleHook;
import org.eclipse.osgi.util.NLS;

public class SignedBundleFile
extends BundleFile
implements CertificateVerifier,
JarVerifierConstant {
    private static DefaultTrustAuthority trustAllAuthority = new DefaultTrustAuthority(0);
    private BundleFile bundleFile;
    CertificateChain[] chains;
    Hashtable digests4entries;
    Hashtable results4entries;
    String manifestSHAResult = null;
    String manifestMD5Result = null;
    boolean certsInitialized = false;

    SignedBundleFile() {
    }

    SignedBundleFile(CertificateChain[] certificateChainArray, Hashtable hashtable, Hashtable hashtable2, String string, String string2) {
        this.chains = certificateChainArray;
        this.digests4entries = hashtable;
        this.results4entries = hashtable2;
        this.manifestMD5Result = string;
        this.manifestSHAResult = string2;
        this.certsInitialized = true;
    }

    private void verifyManifestAndSingatureFile(byte[] byArray, byte[] byArray2) {
        String string = new String(byArray2);
        int n = (string = this.stripContinuations(string)).indexOf("-Digest-Manifest: ");
        if (n != -1) {
            int n2 = string.lastIndexOf(10, n);
            String string2 = null;
            if (n2 != -1) {
                String string3 = string.substring(n2 + 1, n);
                if (string3.equalsIgnoreCase("MD5")) {
                    if (this.manifestMD5Result == null) {
                        this.manifestMD5Result = this.calculateDigest(SignedBundleFile.getMessageDigest("MD5"), byArray);
                    }
                    string2 = this.manifestMD5Result;
                } else if (string3.equalsIgnoreCase("SHA1")) {
                    if (this.manifestSHAResult == null) {
                        this.manifestSHAResult = this.calculateDigest(SignedBundleFile.getMessageDigest("SHA1"), byArray);
                    }
                    string2 = this.manifestSHAResult;
                }
                int n3 = string.indexOf(10, n += digestManifestSearchLen);
                String string4 = string.substring(n, n3 - 1);
                if (!string2.equals(string4)) {
                    SecurityException securityException = new SecurityException(NLS.bind(JarVerifierMessages.Security_File_Is_Tampered, new String[]{this.bundleFile.getBaseFile().toString()}));
                    SignedBundleHook.log(((Exception)securityException).getMessage(), 4, securityException);
                    throw (Throwable)securityException;
                }
            }
        }
    }

    private String getDigAlgFromSF(byte[] byArray) {
        String string = null;
        String string2 = new String(byArray);
        String string3 = null;
        int n = string2.indexOf("\nName: ");
        int n2 = string2.length();
        if (n != -1 && n < n2) {
            int n3 = string2.indexOf("\nName: ", n + 1);
            if (n3 == -1) {
                n3 = string2.length();
            }
            string3 = string2.substring(n + 1, n3);
            string3 = this.stripContinuations(string3);
        }
        if (string3 != null) {
            String string4 = this.getDigestLine(string3, null);
            string = this.getMessageDigestName(string4);
        }
        return string;
    }

    private void populateManifest(byte[] byArray, String string) {
        String string2 = new String(byArray);
        int n = string2.indexOf("\nName: ");
        int n2 = string2.length();
        while (n != -1 && n < n2) {
            String string3;
            int n3 = string2.indexOf("\nName: ", n + 1);
            if (n3 == -1) {
                n3 = string2.length();
            }
            String string4 = string2.substring(n + 1, n3);
            String string5 = this.getEntryFileName(string4 = this.stripContinuations(string4));
            if (string5 != null && (string3 = this.getDigestLine(string4, string)) != null) {
                String string6 = this.getDigestAlgorithmFromString(string3);
                byte[] byArray2 = this.getDigestResultsList(string3);
                if (this.digests4entries == null) {
                    this.digests4entries = new Hashtable(10);
                    this.results4entries = new Hashtable(10);
                }
                if (!this.digests4entries.contains(string5)) {
                    this.digests4entries.put(string5, string6);
                    this.results4entries.put(string5, byArray2);
                }
            }
            n = n3;
        }
    }

    private String stripContinuations(String string) {
        if (string.indexOf("\n ") < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.indexOf("\n ");
        int n2 = 0;
        while (n >= 0) {
            stringBuffer.append(string.substring(n2, n - 1));
            n2 = n + 2;
            int n3 = n = n + 2 < string.length() ? string.indexOf("\n ", n + 2) : -1;
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    private String getEntryFileName(String string) {
        int n = string.indexOf("Name: ");
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(10, n);
        if (n2 == -1) {
            return null;
        }
        if (string.charAt(n2 - 1) == '\r') {
            --n2;
        }
        if ((n += "Name: ".length()) >= n2) {
            return null;
        }
        return string.substring(n, n2);
    }

    /*
     * Unable to fully structure code
     */
    private String getDigestLine(String var1_1, String var2_2) {
        var3_3 = null;
        var4_4 = var1_1.indexOf("-Digest: ");
        if (var4_4 != -1) ** GOTO lbl23
        return null;
lbl-1000:
        // 1 sources

        {
            var5_5 = var1_1.lastIndexOf(10, var4_4);
            if (var5_5 == -1) {
                return null;
            }
            var6_6 = var1_1.indexOf(10, var4_4);
            if (var6_6 == -1) {
                return null;
            }
            var7_7 = var6_6;
            if (var1_1.charAt(var7_7 - 1) == '\r') {
                --var7_7;
            }
            if ((var8_8 = var5_5 + 1) >= var7_7) {
                return null;
            }
            var9_9 = var1_1.substring(var8_8, var7_7);
            var10_10 = this.getMessageDigestName(var9_9);
            if (var2_2 != null && var2_2.equalsIgnoreCase(var10_10)) {
                var3_3 = var9_9;
                break;
            }
            var3_3 = var9_9;
            var4_4 = var1_1.indexOf("-Digest: ", var6_6);
lbl23:
            // 2 sources

            ** while (var4_4 != -1)
        }
lbl24:
        // 2 sources

        return var3_3;
    }

    private String getDigestAlgorithmFromString(String string) {
        if (string != null) {
            int n = string.indexOf("-Digest: ");
            String string2 = string.substring(0, n);
            if (string2.equalsIgnoreCase("MD5")) {
                return "MD5";
            }
            if (string2.equalsIgnoreCase("SHA1")) {
                return "SHA1";
            }
            throw (Throwable)new SecurityException(NLS.bind(JarVerifierMessages.Algorithm_Not_Supported, string2));
        }
        return null;
    }

    private String getMessageDigestName(String string) {
        int n;
        String string2 = null;
        if (string != null && (n = string.indexOf("-Digest: ")) != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private byte[] getDigestResultsList(String string) {
        byte[] byArray = null;
        if (string != null) {
            String string2 = string;
            int n = string2.indexOf("-Digest: ");
            if ((n += "-Digest: ".length()) >= string2.length()) {
                byArray = null;
            }
            String string3 = string2.substring(n);
            try {
                byArray = Base64.decode(string3.getBytes());
            }
            catch (Throwable throwable) {
                byArray = null;
            }
        }
        return byArray;
    }

    private static int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2 = byArray.length;
        int n3 = 0;
        while ((n = inputStream.read(byArray, n3, n2)) > 0) {
            n2 -= n;
            n3 += n;
        }
        return n3;
    }

    byte[] readIntoArray(BundleEntry bundleEntry) throws IOException {
        byte[] byArray;
        int n = (int)bundleEntry.getSize();
        InputStream inputStream = bundleEntry.getInputStream();
        int n2 = SignedBundleFile.readFully(inputStream, byArray = new byte[n]);
        if (n2 != n) {
            throw (Throwable)new IOException("Couldn't read all of " + bundleEntry.getName() + ": " + n2 + " != " + n);
        }
        return byArray;
    }

    void setBundleFile(BundleFile bundleFile, int n) throws IOException {
        Object object;
        this.bundleFile = bundleFile;
        if (this.certsInitialized) {
            return;
        }
        BundleEntry bundleEntry = bundleFile.getEntry("META-INF/MANIFEST.MF");
        if (bundleEntry == null) {
            return;
        }
        Enumeration enumeration = bundleFile.getEntryPaths("META-INF/");
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).endsWith(".DSA") && !((String)object).endsWith(".RSA") || ((String)object).indexOf(47) != ((String)object).lastIndexOf(47)) continue;
            arrayList.add(object);
        }
        if (arrayList.size() == 0) {
            return;
        }
        object = this.readIntoArray(bundleEntry);
        String string = this.findLatestSigner(bundleFile, arrayList);
        try {
            ArrayList<PKCS7Processor> arrayList2 = new ArrayList<PKCS7Processor>(arrayList.size());
            Iterator iterator = arrayList.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                PKCS7Processor pKCS7Processor = this.processSigner(bundleFile, (byte[])object, string2, string, n);
                boolean bl = false;
                try {
                    pKCS7Processor.validateCerts();
                    this.determineCertsTrust(pKCS7Processor, n);
                }
                catch (CertificateExpiredException certificateExpiredException) {
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                }
                catch (InvalidKeyException invalidKeyException) {
                    bl = true;
                }
                if (!bl) {
                    if (string2 == string) {
                        arrayList2.add(0, pKCS7Processor);
                    } else {
                        arrayList2.add(pKCS7Processor);
                    }
                }
                ++n2;
            }
            this.chains = arrayList2.size() == 0 ? null : arrayList2.toArray(new CertificateChain[arrayList2.size()]);
        }
        catch (SignatureException signatureException) {
            throw (Throwable)new SecurityException(NLS.bind(JarVerifierMessages.Signature_Not_Verify_1, new String[]{string, bundleFile.toString()}));
        }
    }

    private void determineCertsTrust(PKCS7Processor pKCS7Processor, int n) {
        CertificateTrustAuthority certificateTrustAuthority = (n & 2) != 0 ? SignedBundleHook.getTrustAuthority() : trustAllAuthority;
        if (certificateTrustAuthority != null) {
            pKCS7Processor.determineTrust(certificateTrustAuthority);
        }
    }

    private PKCS7Processor processSigner(BundleFile bundleFile, byte[] byArray, String string, String string2, int n) throws IOException, SignatureException {
        BundleEntry bundleEntry = bundleFile.getEntry(string);
        byte[] byArray2 = this.readIntoArray(bundleEntry);
        int n2 = string.lastIndexOf(46);
        bundleEntry = bundleFile.getEntry(String.valueOf(string.substring(0, n2)) + ".SF");
        byte[] byArray3 = this.readIntoArray(bundleEntry);
        PKCS7Processor pKCS7Processor = null;
        try {
            pKCS7Processor = new PKCS7Processor(byArray2, 0, byArray2.length);
            pKCS7Processor.verifySFSignature(byArray3, 0, byArray3.length);
            String string3 = this.getDigAlgFromSF(byArray3);
            if (string3 == null) {
                throw (Throwable)new SecurityException(NLS.bind(JarVerifierMessages.SF_File_Parsing_Error, new String[]{bundleFile.toString()}));
            }
            if (string2 == string) {
                this.verifyManifestAndSingatureFile(byArray, byArray3);
                if ((n & 4) != 0) {
                    this.populateManifest(byArray, string3);
                }
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            SignedBundleHook.log(invalidKeyException.getMessage(), 4, invalidKeyException);
            throw (Throwable)new SecurityException(NLS.bind(JarVerifierMessages.Invalid_Key_Exception, new String[]{bundleFile.getBaseFile().toString(), invalidKeyException.getMessage()}));
        }
        catch (CertificateException certificateException) {
            SignedBundleHook.log(certificateException.getMessage(), 4, certificateException);
            throw (Throwable)new SecurityException(NLS.bind(JarVerifierMessages.PKCS7_Cert_Excep, new String[]{bundleFile.getBaseFile().toString(), certificateException.getMessage()}));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            SignedBundleHook.log(noSuchAlgorithmException.getMessage(), 4, noSuchAlgorithmException);
            throw (Throwable)new SecurityException(NLS.bind(JarVerifierMessages.PKCS7_No_Such_Algorithm, new String[]{bundleFile.getBaseFile().toString(), noSuchAlgorithmException.getMessage()}));
        }
        return pKCS7Processor;
    }

    private String findLatestSigner(BundleFile bundleFile, List list) {
        String string = null;
        long l = Long.MIN_VALUE;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            BundleEntry bundleEntry = bundleFile.getEntry(string2);
            if (bundleEntry.getTime() <= l) continue;
            string = string2;
            l = bundleEntry.getTime();
        }
        return string;
    }

    private String calculateDigest(MessageDigest messageDigest, byte[] byArray) {
        return new String(Base64.encode(messageDigest.digest(byArray)));
    }

    public File getFile(String string, boolean bl) {
        return this.bundleFile.getFile(string, bl);
    }

    public BundleEntry getEntry(String string) {
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        BundleEntry bundleEntry = this.bundleFile.getEntry(string);
        if (this.digests4entries == null) {
            return bundleEntry;
        }
        if (bundleEntry == null) {
            if (this.digests4entries.get(string) == null) {
                return null;
            }
            throw (Throwable)new SecurityException(NLS.bind(JarVerifierMessages.file_is_removed_from_jar, this.getBaseFile().toString(), string));
        }
        if (bundleEntry.getName().startsWith("META-INF/")) {
            return bundleEntry;
        }
        if (!this.isSigned()) {
            return bundleEntry;
        }
        return new SignedBundleFile$SignedBundleEntry(this, bundleEntry);
    }

    public Enumeration getEntryPaths(String string) {
        return this.bundleFile.getEntryPaths(string);
    }

    public void close() throws IOException {
        this.bundleFile.close();
    }

    public void open() throws IOException {
        this.bundleFile.open();
    }

    public boolean containsDir(String string) {
        return this.bundleFile.containsDir(string);
    }

    boolean matchDNChain(String string) {
        CertificateChain[] certificateChainArray = this.getChains();
        int n = 0;
        while (n < certificateChainArray.length) {
            if (certificateChainArray[n].isTrusted() && DNChainMatching.match(certificateChainArray[n].getChain(), string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public File getBaseFile() {
        return this.bundleFile.getBaseFile();
    }

    public void checkContent() throws CertificateException, CertificateExpiredException, SignatureException {
        Object object;
        if (!this.isSigned() || this.digests4entries == null) {
            return;
        }
        Enumeration enumeration = this.digests4entries.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            BundleEntry bundleEntry = this.getEntry((String)object);
            if (bundleEntry == null) {
                throw (Throwable)new SecurityException(NLS.bind(JarVerifierMessages.Jar_Is_Tampered, this.bundleFile.getBaseFile().getName()));
            }
            try {
                bundleEntry.getBytes();
            }
            catch (IOException iOException) {
                SignedBundleHook.log(iOException.getMessage(), 4, iOException);
                throw (Throwable)new SecurityException(NLS.bind(JarVerifierMessages.File_In_Jar_Is_Tampered, new String[]{object, this.bundleFile.getBaseFile().toString()}));
            }
        }
        int n = 0;
        while (n < this.chains.length) {
            object = (PKCS7Processor)this.chains[n];
            try {
                ((PKCS7Processor)object).validateCerts();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw (Throwable)new CertificateException(invalidKeyException.getMessage());
            }
            this.determineCertsTrust((PKCS7Processor)object, 7);
            ++n;
        }
    }

    public String[] verifyContent() {
        if (!this.isSigned() || this.digests4entries == null) {
            return EMPTY_STRING;
        }
        ArrayList<String> arrayList = new ArrayList<String>(0);
        Enumeration enumeration = this.digests4entries.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            BundleEntry bundleEntry = this.getEntry(string);
            if (bundleEntry == null) {
                arrayList.add(string);
                continue;
            }
            try {
                bundleEntry.getBytes();
            }
            catch (IOException iOException) {
                arrayList.add(string);
            }
        }
        return arrayList.size() == 0 ? EMPTY_STRING : arrayList.toArray(new String[arrayList.size()]);
    }

    public CertificateChain[] getChains() {
        if (!this.isSigned()) {
            return new CertificateChain[0];
        }
        return this.chains;
    }

    public boolean isSigned() {
        return this.chains != null;
    }

    static synchronized MessageDigest getMessageDigest(String string) {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            SignedBundleHook.log(noSuchAlgorithmException.getMessage(), 4, noSuchAlgorithmException);
            return null;
        }
    }
}

