/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.internal.verifier.SignedBundleHook;

public class KeyStores {
    private static final String JAVA_POLICY_URL = "policy.url.";
    private static final String DEFAULT_KEYSTORE_TYPE = "keystore.type";
    private List keyStores;

    public KeyStores() {
        this.initializeDefaultKeyStores();
    }

    private void processKeyStore(String string, String string2, URL uRL) {
        block20: {
            if (string2 == null) {
                string2 = KeyStore.getDefaultType();
            }
            InputStream inputStream = null;
            try {
                try {
                    URL uRL2;
                    try {
                        uRL2 = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        uRL2 = new URL(uRL, string);
                    }
                    KeyStore keyStore = KeyStore.getInstance(string2);
                    try {
                        inputStream = uRL2.openStream();
                    }
                    catch (IOException iOException) {}
                    if (inputStream != null) {
                        keyStore.load(inputStream, null);
                        this.keyStores.add(keyStore);
                    }
                }
                catch (Exception exception) {
                    SignedBundleHook.log(exception.getMessage(), 2, exception);
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void initializeDefaultKeyStores() {
        this.keyStores = new ArrayList(5);
        String string = Security.getProperty(DEFAULT_KEYSTORE_TYPE);
        String string2 = "file:" + FrameworkProperties.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        this.processKeyStore(string2, string, null);
        string2 = "file:" + FrameworkProperties.getProperty("user.home") + File.separator + ".keystore";
        this.processKeyStore(string2, string, null);
        string2 = FrameworkProperties.getProperty("osgi.framework.keystore");
        if (string2 != null) {
            this.processKeyStore(string2, string, null);
        }
        int n = 1;
        String string3 = Security.getProperty(JAVA_POLICY_URL + n);
        while (string3 != null) {
            this.processKeystoreFromLocation(string3);
            string3 = Security.getProperty(JAVA_POLICY_URL + ++n);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processKeystoreFromLocation(String object) {
        InputStream inputStream;
        block18: {
            String string;
            int n;
            Object object2;
            Object object3;
            inputStream = null;
            char[] cArray = new char[4096];
            int n2 = ((String)object).indexOf("${");
            int n3 = ((String)object).indexOf(125, n2);
            if (n2 != -1 && n3 != -1) {
                object3 = FrameworkProperties.getProperty(((String)object).substring(n2 + 2, n3));
                object2 = ((String)object).substring(0, n2);
                object2 = String.valueOf(object2) + (String)object3;
                object = object2 = String.valueOf(object2) + ((String)object).substring(n3 + 1);
            }
            object3 = new URL((String)object);
            inputStream = ((URL)object3).openStream();
            object2 = new InputStreamReader(inputStream);
            int n4 = ((Reader)object2).read(cArray);
            StringBuffer stringBuffer = new StringBuffer();
            while (n4 != -1) {
                stringBuffer.append(cArray, 0, n4);
                n4 = ((Reader)object2).read(cArray);
            }
            if (stringBuffer.length() <= 0 || (n = (string = new String(stringBuffer.toString())).indexOf("keystore")) == -1) break block18;
            int n5 = string.indexOf(59, n);
            this.processKeystoreFromString(string.substring(n, n5), (URL)object3);
            if (inputStream == null) return;
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {}
            return;
            catch (MalformedURLException malformedURLException) {
                SignedBundleHook.log(malformedURLException.getMessage(), 2, malformedURLException);
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException iOException) {
                if (inputStream == null) return;
                {
                    catch (Throwable throwable) {
                        if (inputStream == null) throw throwable;
                        try {
                            inputStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                }
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException3) {}
                return;
            }
        }
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    private void processKeystoreFromString(String string, URL uRL) {
        String string2 = null;
        int n = string.indexOf(32);
        if (n == -1) {
            return;
        }
        int n2 = string.lastIndexOf(44);
        if (n2 == -1) {
            n2 = string.length();
        } else {
            string2 = string.substring(n2 + 1, string.length()).trim();
        }
        this.processKeyStore(string.substring(n, n2), string2, uRL);
    }

    public boolean isTrusted(Certificate certificate) {
        Iterator iterator = this.keyStores.iterator();
        while (iterator.hasNext()) {
            KeyStore keyStore = (KeyStore)iterator.next();
            try {
                if (keyStore.getCertificateAlias(certificate) == null) continue;
                return true;
            }
            catch (KeyStoreException keyStoreException) {
                SignedBundleHook.log(keyStoreException.getMessage(), 2, keyStoreException);
            }
        }
        return false;
    }
}

