/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.eclipse.osgi.internal.verifier.SignedBundleFile;

class DigestedInputStream
extends FilterInputStream {
    MessageDigest digest;
    byte[] result;
    long remaining;

    DigestedInputStream(InputStream inputStream, String string, byte[] byArray, long l) {
        super(inputStream);
        this.remaining = l;
        this.digest = SignedBundleFile.getMessageDigest(string);
        this.result = byArray;
    }

    public synchronized void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        int n = super.read();
        if (n != -1) {
            this.digest.update((byte)n);
            --this.remaining;
        } else {
            this.remaining = 0L;
        }
        if (this.remaining == 0L) {
            this.verifyDigests();
        }
        return n;
    }

    private void verifyDigests() throws IOException {
        byte[] byArray = this.digest.digest();
        if (!MessageDigest.isEqual(this.result, byArray)) {
            throw (Throwable)new IOException("Corrupted file: the digest is valid for " + this.digest.getAlgorithm());
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.digest.update(byArray, n, n3);
            this.remaining -= (long)n3;
        } else {
            this.remaining = 0L;
        }
        if (this.remaining <= 0L) {
            this.verifyDigests();
        }
        return n3;
    }

    public synchronized void reset() throws IOException {
        throw (Throwable)new IOException("Reset not supported");
    }

    public long skip(long l) throws IOException {
        byte[] byArray = new byte[4096];
        long l2 = 0L;
        while (l - l2 > 0L) {
            int n = l - l2 > (long)byArray.length ? byArray.length : (int)(l - l2);
            if ((n = this.read(byArray, 0, n)) == -1) break;
            l2 += (long)n;
            l -= (long)n;
        }
        return l2;
    }
}

