/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;

public class DNChainMatching {
    private static boolean rdnmatch(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList.size() != arrayList2.size()) {
            return false;
        }
        int n = 0;
        while (n < arrayList.size()) {
            int n2;
            String string = (String)arrayList.get(n);
            String string2 = (String)arrayList2.get(n);
            int n3 = string.indexOf(61);
            if (n3 != (n2 = string2.indexOf(61)) || !string.regionMatches(0, string2, 0, n3)) {
                return false;
            }
            String string3 = string2.substring(n2);
            String string4 = string.substring(n3);
            if (!(string4.equals(string3) || string3.equals("=*") || string3.equals("=#16012a"))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean dnmatch(ArrayList arrayList, ArrayList arrayList2) {
        int n = 0;
        int n2 = 0;
        int n3 = arrayList2.size();
        if (n3 == 0) {
            return false;
        }
        if (arrayList2.get(0).equals("*")) {
            n2 = 1;
            --n3;
        }
        if (arrayList.size() < n3) {
            return false;
        }
        if (arrayList.size() > n3) {
            if (!arrayList2.get(0).equals("*")) {
                return false;
            }
            n = arrayList.size() - n3;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (!DNChainMatching.rdnmatch((ArrayList)arrayList.get(n4 + n), (ArrayList)arrayList2.get(n4 + n2))) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ArrayList parseDNchain(String string) throws IllegalArgumentException {
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        n2 = DNChainMatching.skipSpaces(string, n2);
        while (n2 < string.length()) {
            n = n2;
            boolean bl = false;
            block6: while (n < string.length()) {
                char c = string.charAt(n);
                switch (c) {
                    case '\"': {
                        bl = !bl;
                        break;
                    }
                    case '\\': {
                        ++n;
                        break;
                    }
                    case ';': {
                        if (!bl) break block6;
                    }
                }
                ++n;
            }
            if (n > string.length()) {
                throw (Throwable)new IllegalArgumentException("unterminated escape");
            }
            arrayList.add(string.substring(n2, n));
            n2 = n + 1;
            n2 = DNChainMatching.skipSpaces(string, n2);
        }
        n = 0;
        while (n < arrayList.size()) {
            String string2 = (String)arrayList.get(n);
            if (!string2.equals("*")) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (string2.charAt(0) == '*') {
                    if (string2.charAt(1) != ',') {
                        throw (Throwable)new IllegalArgumentException("invalid wildcard prefix");
                    }
                    arrayList2.add("*");
                    string2 = new X500Principal(string2.substring(2)).getName("CANONICAL");
                } else {
                    string2 = new X500Principal(string2).getName("CANONICAL");
                }
                DNChainMatching.parseDN(string2, arrayList2);
                arrayList.set(n, arrayList2);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            throw (Throwable)new IllegalArgumentException("empty DN chain");
        }
        return arrayList;
    }

    private static int skipSpaces(String string, int n) {
        while (n < string.length() && string.charAt(n) == ' ') {
            ++n;
        }
        return n;
    }

    private static void parseDN(String string, ArrayList arrayList) throws IllegalArgumentException {
        int n = 0;
        char c = '\u0000';
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (n < string.length()) {
            int n2 = n;
            while (n2 < string.length()) {
                c = string.charAt(n2);
                if (c == ',' || c == '+') break;
                if (c == '\\') {
                    ++n2;
                }
                ++n2;
            }
            if (n2 > string.length()) {
                throw (Throwable)new IllegalArgumentException("unterminated escape " + string);
            }
            arrayList2.add(string.substring(n, n2));
            if (c != '+') {
                arrayList.add(arrayList2);
                arrayList2 = n2 != string.length() ? new ArrayList() : null;
            }
            n = n2 + 1;
        }
        if (arrayList2 != null) {
            throw (Throwable)new IllegalArgumentException("improperly terminated DN " + string);
        }
    }

    private static int skipWildCards(ArrayList arrayList, int n) throws IllegalArgumentException {
        int n2 = n;
        while (n2 < arrayList.size()) {
            Object e = arrayList.get(n2);
            if (e instanceof String) {
                if (!e.equals("*")) {
                    throw (Throwable)new IllegalArgumentException("expected wild-card in DN pattern");
                }
            } else {
                if (e instanceof ArrayList) break;
                throw (Throwable)new IllegalArgumentException("expected String or Arraylist in DN Pattern");
            }
            ++n2;
        }
        return n2;
    }

    private static boolean dnChainMatch(ArrayList arrayList, int n, ArrayList arrayList2, int n2) throws IllegalArgumentException {
        if (n >= arrayList.size()) {
            return false;
        }
        if (n2 >= arrayList2.size()) {
            return false;
        }
        Object e = arrayList2.get(n2);
        if (e instanceof String) {
            if (!e.equals("*")) {
                throw (Throwable)new IllegalArgumentException("expected wild-card in DN pattern");
            }
            if ((n2 = DNChainMatching.skipWildCards(arrayList2, n2)) >= arrayList2.size()) {
                return true;
            }
            int n3 = n;
            while (n3 < arrayList.size()) {
                if (DNChainMatching.dnChainMatch(arrayList, n3, arrayList2, n2)) {
                    return true;
                }
                ++n3;
            }
        } else {
            if (e instanceof ArrayList) {
                do {
                    if (!DNChainMatching.dnmatch((ArrayList)arrayList.get(n), (ArrayList)e)) {
                        return false;
                    }
                    if (++n >= arrayList.size() && ++n2 >= arrayList2.size()) {
                        return true;
                    }
                    if (n >= arrayList.size()) {
                        return (n2 = DNChainMatching.skipWildCards(arrayList2, n2)) >= arrayList2.size();
                    }
                    if (n2 >= arrayList2.size()) {
                        return false;
                    }
                    e = arrayList2.get(n2);
                    if (!(e instanceof String)) continue;
                    if (!e.equals("*")) {
                        throw (Throwable)new IllegalArgumentException("expected wild-card in DN pattern");
                    }
                    return DNChainMatching.dnChainMatch(arrayList, n, arrayList2, n2);
                } while (e instanceof ArrayList);
                throw (Throwable)new IllegalArgumentException("expected String or Arraylist in DN Pattern");
            }
            throw (Throwable)new IllegalArgumentException("expected String or Arraylist in DN Pattern");
        }
        return false;
    }

    public static boolean match(String string, String string2) {
        ArrayList arrayList;
        ArrayList arrayList2;
        try {
            arrayList2 = DNChainMatching.parseDNchain(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(String.valueOf(illegalArgumentException.getMessage()) + ": " + string);
            return false;
        }
        try {
            arrayList = DNChainMatching.parseDNchain(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(String.valueOf(illegalArgumentException.getMessage()) + ": " + string2);
            return false;
        }
        try {
            return DNChainMatching.dnChainMatch(arrayList2, 0, arrayList, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }
}

