/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.Properties;
import java.util.zip.ZipFile;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.util.SecureAction$1;
import org.eclipse.osgi.framework.util.SecureAction$10;
import org.eclipse.osgi.framework.util.SecureAction$11;
import org.eclipse.osgi.framework.util.SecureAction$12;
import org.eclipse.osgi.framework.util.SecureAction$13;
import org.eclipse.osgi.framework.util.SecureAction$14;
import org.eclipse.osgi.framework.util.SecureAction$15;
import org.eclipse.osgi.framework.util.SecureAction$16;
import org.eclipse.osgi.framework.util.SecureAction$17;
import org.eclipse.osgi.framework.util.SecureAction$18;
import org.eclipse.osgi.framework.util.SecureAction$19;
import org.eclipse.osgi.framework.util.SecureAction$20;
import org.eclipse.osgi.framework.util.SecureAction$21;
import org.eclipse.osgi.framework.util.SecureAction$3;
import org.eclipse.osgi.framework.util.SecureAction$4;
import org.eclipse.osgi.framework.util.SecureAction$5;
import org.eclipse.osgi.framework.util.SecureAction$6;
import org.eclipse.osgi.framework.util.SecureAction$7;
import org.eclipse.osgi.framework.util.SecureAction$8;
import org.eclipse.osgi.framework.util.SecureAction$9;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class SecureAction {
    private AccessControlContext controlContext = AccessController.getContext();
    static final ClassLoader bootClassLoader = (ClassLoader)AccessController.doPrivileged(new SecureAction$1());

    SecureAction() {
    }

    public static PrivilegedAction createSecureAction() {
        return new SecureAction$3();
    }

    public String getProperty(String string) {
        if (System.getSecurityManager() == null) {
            return FrameworkProperties.getProperty(string);
        }
        return (String)AccessController.doPrivileged(new SecureAction$4(this, string), this.controlContext);
    }

    public FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        if (System.getSecurityManager() == null) {
            return new FileInputStream(file);
        }
        try {
            return (FileInputStream)AccessController.doPrivileged(new SecureAction$7(this, file), this.controlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof FileNotFoundException) {
                throw (Throwable)privilegedActionException.getException();
            }
            throw (Throwable)privilegedActionException.getException();
        }
    }

    public boolean exists(File file) {
        if (System.getSecurityManager() == null) {
            return file.exists();
        }
        return (Boolean)AccessController.doPrivileged(new SecureAction$10(this, file), this.controlContext);
    }

    public boolean isDirectory(File file) {
        if (System.getSecurityManager() == null) {
            return file.isDirectory();
        }
        return (Boolean)AccessController.doPrivileged(new SecureAction$11(this, file), this.controlContext);
    }

    public long lastModified(File file) {
        if (System.getSecurityManager() == null) {
            return file.lastModified();
        }
        return (Long)AccessController.doPrivileged(new SecureAction$12(this, file), this.controlContext);
    }

    public ZipFile getZipFile(File file) throws IOException {
        if (System.getSecurityManager() == null) {
            return new ZipFile(file);
        }
        try {
            return (ZipFile)AccessController.doPrivileged(new SecureAction$14(this, file), this.controlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof IOException) {
                throw (Throwable)privilegedActionException.getException();
            }
            throw (Throwable)privilegedActionException.getException();
        }
    }

    public URL getURL(String string, String string2, int n, String string3, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        if (System.getSecurityManager() == null) {
            return new URL(string, string2, n, string3, uRLStreamHandler);
        }
        try {
            return (URL)AccessController.doPrivileged(new SecureAction$15(this, string, string2, n, string3, uRLStreamHandler), this.controlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof MalformedURLException) {
                throw (Throwable)privilegedActionException.getException();
            }
            throw (Throwable)privilegedActionException.getException();
        }
    }

    public Thread createThread(Runnable runnable, String string) {
        if (System.getSecurityManager() == null) {
            return new Thread(runnable, string);
        }
        return (Thread)AccessController.doPrivileged(new SecureAction$16(this, runnable, string), this.controlContext);
    }

    public Object getService(ServiceReference serviceReference, BundleContext bundleContext) {
        if (System.getSecurityManager() == null) {
            return bundleContext.getService(serviceReference);
        }
        return AccessController.doPrivileged(new SecureAction$17(this, bundleContext, serviceReference), this.controlContext);
    }

    public Class forName(String string) throws ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            return Class.forName(string);
        }
        try {
            return (Class)AccessController.doPrivileged(new SecureAction$18(this, string), this.controlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof ClassNotFoundException) {
                throw (Throwable)privilegedActionException.getException();
            }
            throw (Throwable)privilegedActionException.getException();
        }
    }

    public void open(ServiceTracker serviceTracker) {
        if (System.getSecurityManager() == null) {
            serviceTracker.open();
            return;
        }
        AccessController.doPrivileged(new SecureAction$20(this, serviceTracker), this.controlContext);
    }

    public void start(Bundle bundle, int n) throws BundleException {
        if (System.getSecurityManager() == null) {
            bundle.start(n);
            return;
        }
        try {
            AccessController.doPrivileged(new SecureAction$21(this, bundle, n), this.controlContext);
            return;
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof BundleException) {
                throw (Throwable)privilegedActionException.getException();
            }
            throw (Throwable)privilegedActionException.getException();
        }
    }

    public void start(Bundle bundle) throws BundleException {
        this.start(bundle, 0);
    }

    public String getProperty(String string, String string2) {
        if (System.getSecurityManager() == null) {
            return FrameworkProperties.getProperty(string, string2);
        }
        return (String)AccessController.doPrivileged(new SecureAction$5(this, string, string2), this.controlContext);
    }

    public Properties getProperties() {
        if (System.getSecurityManager() == null) {
            return FrameworkProperties.getProperties();
        }
        return (Properties)AccessController.doPrivileged(new SecureAction$6(this), this.controlContext);
    }

    public FileOutputStream getFileOutputStream(File file, boolean bl) throws FileNotFoundException {
        if (System.getSecurityManager() == null) {
            return new FileOutputStream(file.getAbsolutePath(), bl);
        }
        try {
            return (FileOutputStream)AccessController.doPrivileged(new SecureAction$8(this, file, bl), this.controlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof FileNotFoundException) {
                throw (Throwable)privilegedActionException.getException();
            }
            throw (Throwable)privilegedActionException.getException();
        }
    }

    public long length(File file) {
        if (System.getSecurityManager() == null) {
            return file.length();
        }
        return (Long)AccessController.doPrivileged(new SecureAction$9(this, file), this.controlContext);
    }

    public String[] list(File file) {
        if (System.getSecurityManager() == null) {
            return file.list();
        }
        return (String[])AccessController.doPrivileged(new SecureAction$13(this, file), this.controlContext);
    }

    public Class loadSystemClass(String string) throws ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            return classLoader != null ? classLoader.loadClass(string) : bootClassLoader.loadClass(string);
        }
        try {
            return (Class)AccessController.doPrivileged(new SecureAction$19(this, string), this.controlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof ClassNotFoundException) {
                throw (Throwable)privilegedActionException.getException();
            }
            throw (Throwable)privilegedActionException.getException();
        }
    }
}

