/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.util.Headers$$Cold;
import org.eclipse.osgi.framework.util.Headers$ArrayEnumeration;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;

public class Headers
extends Dictionary
implements Map {
    private boolean readOnly = false;
    private Object[] headers;
    private Object[] values;
    private int size = 0;

    public Headers(int n) {
        this.headers = new Object[n];
        this.values = new Object[n];
    }

    public synchronized Enumeration keys() {
        return new Headers$ArrayEnumeration(this, this.headers, this.size);
    }

    private int getIndex(Object object) {
        boolean bl = object instanceof String;
        int n = 0;
        while (n < this.size) {
            if (bl && this.headers[n] instanceof String ? ((String)this.headers[n]).equalsIgnoreCase((String)object) : this.headers[n].equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void add(Object object, Object object2) {
        if (this.size == this.headers.length) {
            Object[] objectArray = new Object[this.headers.length + 10];
            Object[] objectArray2 = new Object[this.values.length + 10];
            System.arraycopy(this.headers, 0, objectArray, 0, this.headers.length);
            System.arraycopy(this.values, 0, objectArray2, 0, this.values.length);
            this.headers = objectArray;
            this.values = objectArray2;
        }
        this.headers[this.size] = object;
        this.values[this.size] = object2;
        ++this.size;
    }

    public synchronized Object get(Object object) {
        int n = -1;
        n = this.getIndex(object);
        if (n != -1) {
            return this.values[n];
        }
        return null;
    }

    public synchronized Object set(Object object, Object object2, boolean bl) {
        if (this.readOnly) {
            throw (Throwable)new UnsupportedOperationException();
        }
        if (object instanceof String) {
            object = ((String)object).intern();
        }
        int n = this.getIndex(object);
        if (object2 == null) {
            if (n != -1) {
                return this.remove(n);
            }
        } else {
            if (n != -1) {
                if (!bl) {
                    throw (Throwable)new IllegalArgumentException(NLS.bind(Msg.HEADER_DUPLICATE_KEY_EXCEPTION, object));
                }
                Object object3 = this.values[n];
                this.values[n] = object2;
                return object3;
            }
            this.add(object, object2);
        }
        return null;
    }

    public synchronized Object set(Object object, Object object2) {
        return this.set(object, object2, false);
    }

    public synchronized void setReadOnly() {
        this.readOnly = true;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized Object put(Object object, Object object2) {
        if (this.readOnly) {
            throw (Throwable)new UnsupportedOperationException();
        }
        return this.set(object, object2, true);
    }

    public Object remove(Object object) {
        throw (Throwable)new UnsupportedOperationException();
    }

    public String toString() {
        return this.values.toString();
    }

    public static Headers parseManifest(InputStream inputStream) throws BundleException {
        Headers headers = new Headers(10);
        try {
            ManifestElement.parseBundleManifest(inputStream, headers);
        }
        catch (IOException iOException) {
            throw (Throwable)new BundleException(Msg.MANIFEST_IOEXCEPTION, iOException);
        }
        headers.setReadOnly();
        return headers;
    }

    public synchronized boolean containsKey(Object object) {
        return this.getIndex(object) >= 0;
    }

    public boolean containsValue(Object object) {
        throw (Throwable)new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw (Throwable)new UnsupportedOperationException();
    }

    public Set keySet() {
        throw (Throwable)new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        throw (Throwable)new UnsupportedOperationException();
    }

    public Collection values() {
        throw (Throwable)new UnsupportedOperationException();
    }

    public Headers(Dictionary dictionary) throws  {
        this(dictionary.size());
        Headers$$Cold.$init$(this, dictionary);
    }

    public synchronized Enumeration elements() {
        return new Headers$ArrayEnumeration(this, this.values, this.size);
    }

    private Object remove(int n) {
        Object object = this.values[n];
        int n2 = n;
        while (n2 < this.size) {
            if (n2 == this.headers.length - 1) {
                this.headers[n2] = null;
                this.values[n2] = null;
            } else {
                this.headers[n2] = this.headers[n2 + 1];
                this.values[n2] = this.values[n2 + 1];
            }
            ++n2;
        }
        if (n < this.size) {
            --this.size;
        }
        return object;
    }

    public synchronized void clear() {
        if (this.readOnly) {
            throw (Throwable)new UnsupportedOperationException();
        }
    }
}

