/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.reliablefile;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFile$$Cold;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFile$CacheInfo;

public class ReliableFile {
    public static final int OPEN_BEST_AVAILABLE = 0;
    public static final int OPEN_FAIL_ON_PRIMARY = 1;
    public static final int GENERATION_LATEST = 0;
    public static final int GENERATIONS_INFINITE = 0;
    public static final String tmpExt = ".tmp";
    public static final String PROP_MAX_BUFFER = "osgi.reliableFile.maxInputStreamBuffer";
    public static final String PROP_MAX_GENERATIONS = "osgi.ReliableFile.maxGenerations";
    public static final String PROP_OSGI_LOCKING = "osgi.locking";
    protected static final int FILETYPE_UNKNOWN = -1;
    protected static final int FILETYPE_VALID = 0;
    protected static final int FILETYPE_CORRUPT = 1;
    protected static final int FILETYPE_NOSIGNATURE = 2;
    protected static final byte[] identifier1 = new byte[]{46, 99, 114, 99};
    protected static final byte[] identifier2 = new byte[]{46, 118, 49, 10};
    private static final int BUF_SIZE = 4096;
    private static int maxInputStreamBuffer = 131072;
    private static int defaultMaxGenerations = 2;
    private static boolean fileSharing = true;
    private static File lastGenerationFile = null;
    private static int[] lastGenerations = null;
    private File referenceFile;
    private static Hashtable cacheFiles;
    private File inputFile = null;
    private File outputFile = null;
    private Checksum appendChecksum = null;

    static {
        String string = FrameworkProperties.getProperty(PROP_MAX_BUFFER);
        if (string != null) {
            try {
                maxInputStreamBuffer = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((string = FrameworkProperties.getProperty(PROP_MAX_GENERATIONS)) != null) {
            try {
                defaultMaxGenerations = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((string = FrameworkProperties.getProperty(PROP_OSGI_LOCKING)) != null && string.equals("none")) {
            fileSharing = false;
        }
        cacheFiles = new Hashtable(20);
    }

    protected static ReliableFile getReliableFile(String string) throws IOException {
        return ReliableFile.getReliableFile(new File(string));
    }

    protected static ReliableFile getReliableFile(File file) throws IOException {
        if (file.isDirectory()) {
            throw (Throwable)new FileNotFoundException("file is a directory");
        }
        return new ReliableFile(file);
    }

    private ReliableFile(File file) {
        this.referenceFile = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int[] getFileGenerations(File file) {
        if (!fileSharing && lastGenerationFile != null && file.equals(lastGenerationFile)) {
            return lastGenerations;
        }
        int[] nArray = null;
        try {
            int n;
            String string = file.getName();
            String string2 = String.valueOf(string) + '.';
            int n2 = string2.length();
            File file2 = new File(file.getParent());
            String[] stringArray = file2.list();
            if (stringArray == null) {
                return null;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>(defaultMaxGenerations);
            if (file.exists()) {
                arrayList.add(new Integer(0));
            }
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray[n3].startsWith(string2)) {
                    try {
                        n = Integer.parseInt(stringArray[n3].substring(n2));
                        arrayList.add(new Integer(n));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++n3;
            }
            if (arrayList.size() == 0) {
                return null;
            }
            Object[] objectArray = arrayList.toArray();
            Arrays.sort(objectArray);
            nArray = new int[objectArray.length];
            n = 0;
            int n4 = objectArray.length - 1;
            while (n < objectArray.length) {
                nArray[n] = (Integer)objectArray[n4];
                ++n;
                --n4;
            }
            int[] nArray2 = nArray;
            return nArray2;
        }
        finally {
            if (!fileSharing) {
                lastGenerationFile = file;
                lastGenerations = nArray;
            }
        }
    }

    protected OutputStream getOutputStream(boolean bl, int n) throws IOException {
        InputStream inputStream;
        if (this.outputFile != null) {
            throw (Throwable)new IOException("Output stream is already open");
        }
        String string = this.referenceFile.getName();
        File file = new File(this.referenceFile.getParent());
        File file2 = File.createTempFile(string, tmpExt, file);
        if (!bl) {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            this.outputFile = file2;
            return fileOutputStream;
        }
        try {
            inputStream = this.getInputStream(n, 0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            this.outputFile = file2;
            return fileOutputStream;
        }
        try {
            ReliableFile$CacheInfo reliableFile$CacheInfo = (ReliableFile$CacheInfo)cacheFiles.get(this.inputFile);
            this.appendChecksum = reliableFile$CacheInfo.checksum;
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            if (reliableFile$CacheInfo.filetype == 2) {
                ReliableFile.cp(inputStream, fileOutputStream, 0);
            } else {
                ReliableFile.cp(inputStream, fileOutputStream, 16);
            }
            this.outputFile = file2;
            FileOutputStream fileOutputStream2 = fileOutputStream;
            return fileOutputStream2;
        }
        finally {
            this.closeInputFile();
        }
    }

    protected void closeOutputFile(Checksum checksum) throws IOException {
        if (this.outputFile == null) {
            throw (Throwable)new IOException("Output stream is not open");
        }
        int[] nArray = ReliableFile.getFileGenerations(this.referenceFile);
        String string = this.referenceFile.getName();
        File file = new File(this.referenceFile.getParent());
        File file2 = nArray == null ? new File(file, String.valueOf(string) + ".1") : new File(file, String.valueOf(string) + '.' + (nArray[0] + 1));
        ReliableFile.mv(this.outputFile, file2);
        this.outputFile = null;
        this.appendChecksum = null;
        ReliableFile$CacheInfo reliableFile$CacheInfo = new ReliableFile$CacheInfo(this, 0, checksum, file2.lastModified());
        cacheFiles.put(file2, reliableFile$CacheInfo);
        this.cleanup(nArray, true);
        lastGenerationFile = null;
        lastGenerations = null;
    }

    protected File getOutputFile() {
        return this.outputFile;
    }

    void closeInputFile() {
        this.inputFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(int[] nArray, boolean bl) {
        if (nArray == null) {
            return;
        }
        String string = this.referenceFile.getName();
        File file = new File(this.referenceFile.getParent());
        int n = nArray.length;
        if (nArray[n - 1] == 0) {
            --n;
        }
        int n2 = n - defaultMaxGenerations;
        if (bl) {
            ++n2;
        }
        if (n2 < 1) {
            return;
        }
        Hashtable hashtable = cacheFiles;
        synchronized (hashtable) {
            int n3 = 0;
            int n4 = n - n2;
            while (n3 < n4) {
                File file2 = new File(file, String.valueOf(string) + '.' + nArray[n3]);
                ReliableFile$CacheInfo reliableFile$CacheInfo = (ReliableFile$CacheInfo)cacheFiles.get(file2);
                if (reliableFile$CacheInfo != null && reliableFile$CacheInfo.filetype == 1) {
                    --n2;
                }
                ++n3;
            }
            n3 = n - 1;
            while (n2 > 0) {
                File file3 = new File(file, String.valueOf(string) + '.' + nArray[n3]);
                file3.delete();
                cacheFiles.remove(file3);
                --n3;
                --n2;
            }
        }
    }

    private static void mv(File file, File file2) throws IOException {
        if (!file.renameTo(file2)) {
            throw (Throwable)new IOException("rename failed");
        }
    }

    public static int lastModifiedVersion(File file) {
        int[] nArray = ReliableFile.getFileGenerations(file);
        if (nArray == null) {
            return -1;
        }
        return nArray[0];
    }

    public static void fileUpdated(File file) {
        lastGenerationFile = null;
        lastGenerations = null;
    }

    protected void writeChecksumSignature(OutputStream outputStream, Checksum checksum) throws IOException {
        outputStream.write(identifier1);
        outputStream.write(ReliableFile.intToHex((int)checksum.getValue()));
        outputStream.write(identifier2);
    }

    protected Checksum getChecksumCalculator() {
        return new CRC32();
    }

    private static byte[] intToHex(int n) {
        byte[] byArray = new byte[8];
        int n2 = 8;
        do {
            int n3;
            n3 = (n3 = n & 0xF) > 9 ? n3 - 10 + 97 : (n3 += 48);
            byArray[--n2] = (byte)n3;
            n >>= 4;
        } while (n2 > 0);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStream(int n, int n2) throws IOException {
        boolean bl;
        if (this.inputFile != null) {
            throw (Throwable)new IOException("Input stream already open");
        }
        int[] nArray = ReliableFile.getFileGenerations(this.referenceFile);
        if (nArray == null) {
            throw (Throwable)new FileNotFoundException("File not found");
        }
        String string = this.referenceFile.getName();
        File file = new File(this.referenceFile.getParent());
        boolean bl2 = bl = (n2 & 1) != 0;
        if (bl && n == 0) {
            n = nArray[0];
        }
        File file2 = null;
        FileInputStream fileInputStream = null;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (n == 0 || nArray[n3] <= n && (!bl || nArray[n3] == n)) {
                ReliableFile$CacheInfo reliableFile$CacheInfo;
                File file3 = nArray[n3] != 0 ? new File(file, String.valueOf(string) + '.' + nArray[n3]) : this.referenceFile;
                InputStream inputStream = null;
                Hashtable hashtable = cacheFiles;
                synchronized (hashtable) {
                    reliableFile$CacheInfo = (ReliableFile$CacheInfo)cacheFiles.get(file3);
                }
                long l = file3.lastModified();
                if (reliableFile$CacheInfo == null || l != reliableFile$CacheInfo.timeStamp) {
                    try {
                        inputStream = new FileInputStream(file3);
                        if (((InputStream)inputStream).available() < maxInputStreamBuffer) {
                            inputStream = new BufferedInputStream(inputStream);
                        }
                        Checksum checksum = this.getChecksumCalculator();
                        int n4 = this.getStreamType(inputStream, checksum);
                        reliableFile$CacheInfo = new ReliableFile$CacheInfo(this, n4, checksum, l);
                        Hashtable hashtable2 = cacheFiles;
                        synchronized (hashtable2) {
                            cacheFiles.put(file3, reliableFile$CacheInfo);
                        }
                    }
                    catch (IOException iOException) {}
                }
                if (bl) {
                    if (reliableFile$CacheInfo != null && reliableFile$CacheInfo.filetype == 0) {
                        this.inputFile = file3;
                        if (inputStream != null) {
                            return inputStream;
                        }
                        return new FileInputStream(file3);
                    }
                    throw (Throwable)new IOException("ReliableFile is corrupt");
                }
                if (reliableFile$CacheInfo != null) {
                    switch (reliableFile$CacheInfo.filetype) {
                        case 0: {
                            this.inputFile = file3;
                            if (inputStream != null) {
                                return inputStream;
                            }
                            return new FileInputStream(file3);
                        }
                        case 2: {
                            if (file2 != null) break;
                            file2 = file3;
                            fileInputStream = inputStream;
                        }
                    }
                }
            }
            ++n3;
        }
        if (file2 != null) {
            this.inputFile = file2;
            if (fileInputStream != null) {
                return fileInputStream;
            }
            return new FileInputStream(file2);
        }
        throw (Throwable)new IOException("ReliableFile is corrupt");
    }

    protected void abortOutputFile() {
        if (this.outputFile == null) {
            return;
        }
        this.outputFile.delete();
        this.outputFile = null;
        this.appendChecksum = null;
    }

    private static void cp(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        ReliableFile$$Cold.cp(inputStream, outputStream, n);
    }

    public static boolean exists(File file) throws  {
        return ReliableFile$$Cold.exists(file);
    }

    public static long lastModified(File file) {
        int[] nArray = ReliableFile.getFileGenerations(file);
        if (nArray == null) {
            return 0L;
        }
        if (nArray[0] == 0) {
            return file.lastModified();
        }
        String string = file.getName();
        File file2 = new File(file.getParent());
        File file3 = new File(file2, String.valueOf(string) + '.' + nArray[0]);
        return file3.lastModified();
    }

    public long lastModified() {
        if (this.inputFile != null) {
            return this.inputFile.lastModified();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(File file) {
        int[] nArray = ReliableFile.getFileGenerations(file);
        if (nArray == null) {
            return false;
        }
        String string = file.getName();
        File file2 = new File(file.getParent());
        Hashtable hashtable = cacheFiles;
        synchronized (hashtable) {
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] != 0) {
                    File file3 = new File(file2, String.valueOf(string) + '.' + nArray[n]);
                    if (file3.exists()) {
                        file3.delete();
                    }
                    cacheFiles.remove(file3);
                }
                ++n;
            }
        }
        return true;
    }

    public static String[] getBaseFiles(File file) throws IOException {
        return ReliableFile$$Cold.getBaseFiles(file);
    }

    public static void cleanupGenerations(File file) {
        ReliableFile reliableFile = new ReliableFile(file);
        int[] nArray = ReliableFile.getFileGenerations(file);
        reliableFile.cleanup(nArray, false);
        lastGenerationFile = null;
        lastGenerations = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getSignatureSize() throws IOException {
        if (this.inputFile != null) {
            ReliableFile$CacheInfo reliableFile$CacheInfo;
            Hashtable hashtable = cacheFiles;
            synchronized (hashtable) {
                reliableFile$CacheInfo = (ReliableFile$CacheInfo)cacheFiles.get(this.inputFile);
            }
            if (reliableFile$CacheInfo != null) {
                switch (reliableFile$CacheInfo.filetype) {
                    case 0: 
                    case 1: {
                        return 16;
                    }
                    case 2: {
                        return 0;
                    }
                }
            }
        }
        throw (Throwable)new IOException("ReliableFile signature size is unknown");
    }

    protected Checksum getFileChecksum() throws IOException {
        if (this.appendChecksum == null) {
            throw (Throwable)new IOException("Checksum is invalid!");
        }
        return this.appendChecksum;
    }

    private int getStreamType(InputStream inputStream, Checksum checksum) throws IOException {
        return ReliableFile$$Cold.getStreamType(this, inputStream, checksum);
    }
}

