/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleResourceHandler$$Cold;
import org.eclipse.osgi.framework.internal.core.BundleURLConnection;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class BundleResourceHandler
extends URLStreamHandler {
    public static final String SECURITY_AUTHORIZED = "SECURITY_AUTHORIZED";
    protected static BundleContext context;
    protected BundleEntry bundleEntry;

    public BundleResourceHandler() {
        this(null);
    }

    public BundleResourceHandler(BundleEntry bundleEntry) {
        this.bundleEntry = bundleEntry;
    }

    protected URLConnection openConnection(URL uRL) throws IOException {
        long l;
        if (this.bundleEntry != null) {
            return new BundleURLConnection(uRL, this.bundleEntry);
        }
        String string = uRL.getHost();
        if (string == null) {
            throw (Throwable)new IOException(NLS.bind(AdaptorMsg.URL_NO_BUNDLE_ID, uRL.toExternalForm()));
        }
        AbstractBundle abstractBundle = null;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw (Throwable)new MalformedURLException(NLS.bind(AdaptorMsg.URL_INVALID_BUNDLE_ID, string));
        }
        abstractBundle = (AbstractBundle)context.getBundle(l);
        if (!uRL.getAuthority().equals(SECURITY_AUTHORIZED)) {
            this.checkAdminPermission(abstractBundle);
        }
        if (abstractBundle == null) {
            throw (Throwable)new IOException(NLS.bind(AdaptorMsg.URL_NO_BUNDLE_FOUND, uRL.toExternalForm()));
        }
        return new BundleURLConnection(uRL, this.findBundleEntry(uRL, abstractBundle));
    }

    protected abstract BundleEntry findBundleEntry(URL var1, AbstractBundle var2) throws IOException;

    public static void setContext(BundleContext bundleContext) {
        context = bundleContext;
    }

    protected boolean equals(URL uRL, URL uRL2) {
        return this.sameFile(uRL, uRL2);
    }

    protected synchronized InetAddress getHostAddress(URL uRL) {
        return null;
    }

    protected void parseURL(URL uRL, String string, int n, int n2) throws  {
        BundleResourceHandler$$Cold.parseURL(this, uRL, string, n, n2);
    }

    protected String toExternalForm(URL uRL) throws  {
        return BundleResourceHandler$$Cold.toExternalForm(this, uRL);
    }

    protected int hashCode(URL uRL) throws  {
        return BundleResourceHandler$$Cold.hashCode(this, uRL);
    }

    protected boolean hostsEqual(URL uRL, URL uRL2) throws  {
        return BundleResourceHandler$$Cold.hostsEqual(this, uRL, uRL2);
    }

    protected boolean sameFile(URL uRL, URL uRL2) throws  {
        return BundleResourceHandler$$Cold.sameFile(this, uRL, uRL2);
    }

    protected void checkAdminPermission(Bundle bundle) throws  {
        BundleResourceHandler$$Cold.checkAdminPermission(this, bundle);
    }

    protected static BaseClassLoader getBundleClassLoader(AbstractBundle abstractBundle) throws  {
        return BundleResourceHandler$$Cold.getBundleClassLoader(abstractBundle);
    }
}

