/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.AliasMapper;
import org.eclipse.osgi.framework.internal.core.BundleNativeCode$Attribute;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class BundleNativeCode {
    private BundleNativeCode$Attribute nativepaths;
    private BundleNativeCode$Attribute processor;
    private BundleNativeCode$Attribute osname;
    private BundleNativeCode$Attribute language;
    private BundleNativeCode$Attribute osversion;
    private String filterString;
    private AbstractBundle bundle;
    private static AliasMapper aliasMapper = Framework.aliasMapper;

    protected BundleNativeCode(ManifestElement manifestElement, AbstractBundle abstractBundle) {
        this.bundle = abstractBundle;
        String[] stringArray = manifestElement.getValueComponents();
        int n = 0;
        while (n < stringArray.length) {
            this.addPath(stringArray[n]);
            ++n;
        }
        this.setAttribute(manifestElement, "osname");
        this.setAttribute(manifestElement, "processor");
        this.setAttribute(manifestElement, "osversion");
        this.setAttribute(manifestElement, "language");
        this.setAttribute(manifestElement, "selection-filter");
    }

    private void setAttribute(ManifestElement manifestElement, String string) {
        String[] stringArray = manifestElement.getAttributes(string);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.addAttribute(string, stringArray[n]);
                ++n;
            }
        }
    }

    public String[] getPaths() {
        if (this.nativepaths == null) {
            return null;
        }
        String[] stringArray = new String[this.nativepaths.size()];
        this.nativepaths.toArray(stringArray);
        return stringArray;
    }

    protected void addPath(String string) {
        if (this.nativepaths == null) {
            this.nativepaths = new BundleNativeCode$Attribute();
        }
        this.nativepaths.addElement(string);
    }

    protected synchronized void addAttribute(String string, String string2) {
        if (string.equals("processor")) {
            if (this.processor == null) {
                this.processor = new BundleNativeCode$Attribute();
            }
            this.processor.addElement(aliasMapper.aliasProcessor(string2));
            return;
        }
        if (string.equals("osname")) {
            if (this.osname == null) {
                this.osname = new BundleNativeCode$Attribute();
            }
            this.osname.addElement(aliasMapper.aliasOSName(string2));
            return;
        }
        if (string.equals("osversion")) {
            if (this.osversion == null) {
                this.osversion = new BundleNativeCode$Attribute();
            }
            this.osversion.addElement(new VersionRange(string2));
            return;
        }
        if (string.equals("selection-filter")) {
            if (this.filterString == null) {
                this.filterString = string2;
            }
            return;
        }
        if (string.equals("language")) {
            if (this.language == null) {
                this.language = new BundleNativeCode$Attribute();
            }
            this.language.addElement(string2.toLowerCase());
            return;
        }
    }

    public String toString() {
        int n = this.nativepaths.size();
        StringBuffer stringBuffer = new StringBuffer(50 * n);
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(this.nativepaths.elementAt(n2).toString());
            ++n2;
        }
        if (this.processor != null) {
            n = this.processor.size();
            n2 = 0;
            while (n2 < n) {
                stringBuffer.append(';');
                stringBuffer.append("processor");
                stringBuffer.append('=');
                stringBuffer.append(this.processor.elementAt(n2).toString());
                ++n2;
            }
        }
        if (this.osname != null) {
            n = this.osname.size();
            n2 = 0;
            while (n2 < n) {
                stringBuffer.append(';');
                stringBuffer.append("osname");
                stringBuffer.append('=');
                stringBuffer.append(this.osname.elementAt(n2).toString());
                ++n2;
            }
        }
        if (this.osversion != null) {
            n = this.osversion.size();
            n2 = 0;
            while (n2 < n) {
                stringBuffer.append(';');
                stringBuffer.append("osversion");
                stringBuffer.append('=');
                stringBuffer.append(this.osversion.elementAt(n2).toString());
                ++n2;
            }
        }
        if (this.language != null) {
            n = this.language.size();
            n2 = 0;
            while (n2 < n) {
                stringBuffer.append(';');
                stringBuffer.append("language");
                stringBuffer.append('=');
                stringBuffer.append(this.language.elementAt(n2).toString());
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public int matchProcessorOSNameFilter(String string, String string2) {
        if (this.processor == null || this.osname == null) {
            return 0;
        }
        String string3 = aliasMapper.aliasProcessor(string);
        String string4 = (String)aliasMapper.aliasOSName(string2);
        if (this.processor.equals(string3) && this.osname.equals(string4) && this.matchFilter()) {
            return 1;
        }
        return 0;
    }

    public Version matchOSVersion(Version version) {
        if (this.osversion == null) {
            return Version.emptyVersion;
        }
        Version version2 = null;
        int n = this.osversion.size();
        int n2 = 0;
        while (n2 < n) {
            VersionRange versionRange = (VersionRange)this.osversion.elementAt(n2);
            if (versionRange.isIncluded(version) && (version2 == null || versionRange.getMinimum().compareTo(version2) > 0)) {
                version2 = versionRange.getMinimum();
            }
            ++n2;
        }
        return version2;
    }

    public int matchLanguage(String string) {
        if (this.language == null) {
            return 1;
        }
        if (this.language.equals(string.toLowerCase())) {
            return 2;
        }
        return 0;
    }

    public boolean matchFilter() {
        FilterImpl filterImpl;
        if (this.filterString == null) {
            return true;
        }
        try {
            filterImpl = new FilterImpl(this.filterString);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            BundleException bundleException = new BundleException(Msg.BUNDLE_NATIVECODE_INVALID_FILTER, invalidSyntaxException);
            this.bundle.framework.publishFrameworkEvent(2, this.bundle, bundleException);
            return false;
        }
        try {
            return filterImpl.match(FrameworkProperties.getProperties());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return filterImpl.matchCase(FrameworkProperties.getProperties());
        }
    }
}

