/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import org.eclipse.osgi.framework.eventmgr.EventListeners$ListElement;

public class EventListeners {
    private static final EventListeners$ListElement[] emptyArray = new EventListeners$ListElement[0];
    private final int initialCapacity;
    private EventListeners$ListElement[] list = null;
    private int size = 0;
    private boolean copyOnWrite = false;

    public EventListeners() {
        this(10);
    }

    public EventListeners(int n) {
        if (n < 1) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.initialCapacity = n;
    }

    public synchronized void addListener(Object object, Object object2) {
        if (object == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (this.size == 0) {
            this.list = new EventListeners$ListElement[this.initialCapacity];
        } else {
            if (this.copyOnWrite) {
                this.copyList(this.size);
                this.copyOnWrite = false;
            }
            int n = 0;
            while (n < this.size) {
                if (this.list[n].primary == object) {
                    this.list[n] = new EventListeners$ListElement(object, object2);
                    return;
                }
                ++n;
            }
            if (this.size == this.list.length) {
                this.copyList(this.size);
            }
        }
        this.list[this.size] = new EventListeners$ListElement(object, object2);
        ++this.size;
    }

    public synchronized void removeListener(Object object) {
        if (object == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        int n = 0;
        while (n < this.size) {
            if (this.list[n].primary == object) {
                --this.size;
                if (this.size == 0) {
                    this.list = null;
                    return;
                }
                if (this.copyOnWrite) {
                    this.copyList(n);
                    this.copyOnWrite = false;
                } else {
                    System.arraycopy(this.list, n + 1, this.list, n, this.size - n);
                    this.list[this.size] = null;
                }
                return;
            }
            ++n;
        }
    }

    public synchronized void removeAllListeners() {
        this.list = null;
        this.size = 0;
    }

    synchronized EventListeners$ListElement[] getListeners() {
        if (this.size == 0) {
            return emptyArray;
        }
        this.copyOnWrite = true;
        return this.list;
    }

    private void copyList(int n) {
        if (n > this.size) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        int n2 = this.size * 3 / 2 + 1;
        if (n2 < this.initialCapacity) {
            n2 = this.initialCapacity;
        }
        EventListeners$ListElement[] eventListeners$ListElementArray = new EventListeners$ListElement[n2];
        System.arraycopy(this.list, 0, eventListeners$ListElementArray, 0, n);
        if (n < this.size) {
            System.arraycopy(this.list, n + 1, eventListeners$ListElementArray, n, this.size - n);
        }
        this.list = eventListeners$ListElementArray;
    }
}

