/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.DirZipBundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.MRUBundleFileList;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile$$Cold;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.util.NLS;

public class ZipBundleFile
extends BundleFile {
    protected static MRUBundleFileList mruList = new MRUBundleFileList();
    protected BaseData bundledata;
    protected ZipFile zipFile;
    protected boolean closed = true;

    public ZipBundleFile(File file, BaseData baseData) throws IOException {
        super(file);
        if (!BundleFile.secureAction.exists(file)) {
            throw (Throwable)new IOException(NLS.bind(AdaptorMsg.ADAPTER_FILEEXIST_EXCEPTION, file));
        }
        this.bundledata = baseData;
        this.closed = true;
    }

    protected boolean checkedOpen() {
        try {
            return this.getZipFile() != null;
        }
        catch (IOException iOException) {
            if (this.bundledata != null) {
                this.bundledata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, this.bundledata.getBundle(), iOException);
            }
            return false;
        }
    }

    protected ZipFile basicOpen() throws IOException {
        return BundleFile.secureAction.getZipFile(this.basefile);
    }

    protected synchronized ZipFile getZipFile() throws IOException {
        if (this.closed) {
            mruList.add(this);
            this.zipFile = this.basicOpen();
            this.closed = false;
        } else {
            mruList.use(this);
        }
        return this.zipFile;
    }

    protected ZipEntry getZipEntry(String string) {
        ZipEntry zipEntry;
        ZipEntry zipEntry2;
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if ((zipEntry2 = this.zipFile.getEntry(string)) != null && zipEntry2.getSize() == 0L && !zipEntry2.isDirectory() && (zipEntry = this.zipFile.getEntry(String.valueOf(string) + '/')) != null) {
            zipEntry2 = zipEntry;
        }
        return zipEntry2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized File getFile(String string, boolean bl) {
        InputStream inputStream;
        File file;
        block11: {
            if (!this.checkedOpen()) {
                return null;
            }
            ZipEntry zipEntry = this.getZipEntry(string);
            if (zipEntry == null) {
                return null;
            }
            file = this.getExtractFile(zipEntry.getName());
            if (file == null) return null;
            if (file.exists()) {
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("File already present: " + file.getPath());
                }
                if (!file.isDirectory()) return file;
                this.extractDirectory(zipEntry.getName());
                return file;
            }
            if (zipEntry.getName().endsWith("/")) {
                if (!file.mkdirs()) {
                    if (!Debug.DEBUG_GENERAL) throw (Throwable)new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, file.getAbsolutePath()));
                    Debug.println("Unable to create directory: " + file.getPath());
                    throw (Throwable)new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, file.getAbsolutePath()));
                }
                this.extractDirectory(zipEntry.getName());
                return file;
            }
            inputStream = this.zipFile.getInputStream(zipEntry);
            if (inputStream != null) break block11;
            return null;
        }
        try {
            File file2;
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Creating file: " + file.getPath());
            }
            if (!(file2 = new File(file.getParent())).exists() && !file2.mkdirs()) {
                if (!Debug.DEBUG_GENERAL) throw (Throwable)new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, file2.getAbsolutePath()));
                Debug.println("Unable to create directory: " + file2.getPath());
                throw (Throwable)new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, file2.getAbsolutePath()));
            }
            AdaptorUtil.readFile(inputStream, file);
            if (!bl) return file;
            ZipBundleFile.setPermissions(file);
            return file;
        }
        catch (IOException iOException) {
            if (!Debug.DEBUG_GENERAL) return null;
            Debug.printStackTrace(iOException);
        }
        return null;
    }

    public synchronized BundleEntry getEntry(String string) {
        if (!this.checkedOpen()) {
            return null;
        }
        ZipEntry zipEntry = this.getZipEntry(string);
        if (zipEntry == null) {
            if ((string.length() == 0 || string.charAt(string.length() - 1) == '/') && this.containsDir(string)) {
                return new DirZipBundleEntry(this, string);
            }
            return null;
        }
        return new ZipBundleEntry(zipEntry, this);
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.zipFile.close();
            mruList.remove(this);
        }
    }

    public void open() throws IOException {
    }

    public static void shutdown() {
        mruList.shutdown();
    }

    protected synchronized File extractDirectory(String string) throws  {
        return ZipBundleFile$$Cold.extractDirectory(this, string);
    }

    protected File getExtractFile(String string) throws  {
        return ZipBundleFile$$Cold.getExtractFile(this, string);
    }

    public synchronized boolean containsDir(String string) throws  {
        return ZipBundleFile$$Cold.containsDir(this, string);
    }

    public synchronized Enumeration getEntryPaths(String string) throws  {
        return ZipBundleFile$$Cold.getEntryPaths(this, string);
    }
}

