/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Properties;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.osgi.baseadaptor.BaseAdaptor$$Cold;
import org.eclipse.osgi.baseadaptor.BaseAdaptor$1;
import org.eclipse.osgi.baseadaptor.BaseAdaptor$2;
import org.eclipse.osgi.baseadaptor.BaseAdaptor$ParentClassLoader;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.EventPublisher;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleResourceHandler;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.ServiceRegistryImpl;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.internal.baseadaptor.BaseStorage;
import org.eclipse.osgi.internal.baseadaptor.BaseStorageHook;
import org.eclipse.osgi.internal.baseadaptor.SystemBundleData;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class BaseAdaptor
implements FrameworkAdaptor {
    private static final String PROP_PARENT_CLASSLOADER = "osgi.parentClassloader";
    private static final String PARENT_CLASSLOADER_APP = "app";
    private static final String PARENT_CLASSLOADER_EXT = "ext";
    private static final String PARENT_CLASSLOADER_BOOT = "boot";
    private static final String PARENT_CLASSLOADER_FWK = "fwk";
    private static ClassLoader bundleClassLoaderParent;
    private EventPublisher eventPublisher;
    private ServiceRegistry serviceRegistry;
    private boolean stopping;
    private HookRegistry hookRegistry;
    private FrameworkLog log;
    private BundleContext context;
    private BaseStorage storage;
    private BundleWatcher bundleWatcher;
    static Class class$0;

    static {
        ClassLoader classLoader;
        String string = FrameworkProperties.getProperty(PROP_PARENT_CLASSLOADER, PARENT_CLASSLOADER_BOOT);
        if (PARENT_CLASSLOADER_FWK.equalsIgnoreCase(string)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.framework.adaptor.FrameworkAdaptor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            bundleClassLoaderParent = clazz.getClassLoader();
        } else if (PARENT_CLASSLOADER_APP.equalsIgnoreCase(string)) {
            bundleClassLoaderParent = ClassLoader.getSystemClassLoader();
        } else if (PARENT_CLASSLOADER_EXT.equalsIgnoreCase(string) && (classLoader = ClassLoader.getSystemClassLoader()) != null) {
            bundleClassLoaderParent = classLoader.getParent();
        }
        if (bundleClassLoaderParent == null) {
            bundleClassLoaderParent = new BaseAdaptor$ParentClassLoader();
        }
    }

    public BaseAdaptor(String[] stringArray) {
        if (LocationManager.getConfigurationLocation() == null) {
            LocationManager.initializeLocations();
        }
        this.hookRegistry = new HookRegistry(this);
        FrameworkLogEntry[] frameworkLogEntryArray = this.hookRegistry.initialize();
        if (frameworkLogEntryArray.length > 0) {
            int n = 0;
            while (n < frameworkLogEntryArray.length) {
                this.getFrameworkLog().log(frameworkLogEntryArray[n]);
                ++n;
            }
        }
        this.storage = this.getStorage();
    }

    public void initialize(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.serviceRegistry = new ServiceRegistryImpl();
        ((ServiceRegistryImpl)this.serviceRegistry).initialize();
        AdaptorHook[] adaptorHookArray = this.getHookRegistry().getAdaptorHooks();
        int n = 0;
        while (n < adaptorHookArray.length) {
            adaptorHookArray[n].initialize(this);
            ++n;
        }
    }

    public void initializeStorage() throws IOException {
        this.storage.initialize(this);
    }

    public void compactStorage() throws IOException {
        this.storage.compact();
    }

    public Properties getProperties() {
        Object object;
        Properties properties;
        block13: {
            properties = new Properties();
            String string = FrameworkProperties.getProperty("osgi.framework.properties", "osgi.properties");
            try {
                object = null;
                File file = new File(string);
                if (file.exists()) {
                    object = new FileInputStream(file);
                }
                if (object == null) {
                    object = this.getClass().getResourceAsStream(string);
                }
                if (object != null) {
                    try {
                        properties.load(new BufferedInputStream((InputStream)object));
                    }
                    catch (Throwable throwable) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        ((InputStream)object).close();
                    }
                    catch (IOException iOException) {}
                    break block13;
                }
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("Skipping osgi.properties: " + string);
                }
            }
            catch (IOException iOException) {
                if (!Debug.DEBUG_GENERAL) break block13;
                Debug.println("Unable to load osgi.properties: " + iOException.getMessage());
            }
        }
        this.storage.addProperties(properties);
        object = this.getHookRegistry().getAdaptorHooks();
        int n = 0;
        while (n < ((AdaptorHook[])object).length) {
            object[n].addProperties(properties);
            ++n;
        }
        return properties;
    }

    public BundleData[] getInstalledBundles() {
        return this.storage.getInstalledBundles();
    }

    public BundleOperation installBundle(String string, URLConnection uRLConnection) {
        return this.storage.installBundle(string, uRLConnection);
    }

    public BundleOperation updateBundle(BundleData bundleData, URLConnection uRLConnection) {
        return this.storage.updateBundle((BaseData)bundleData, uRLConnection);
    }

    public BundleOperation uninstallBundle(BundleData bundleData) {
        return this.storage.uninstallBundle((BaseData)bundleData);
    }

    public long getTotalFreeSpace() throws IOException {
        return this.storage.getFreeSpace();
    }

    public PermissionStorage getPermissionStorage() throws IOException {
        return this.storage.getPermissionStorage();
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void frameworkStart(BundleContext bundleContext) throws BundleException {
        this.context = bundleContext;
        this.stopping = false;
        BundleResourceHandler.setContext(bundleContext);
        this.storage.frameworkStart(bundleContext);
        AdaptorHook[] adaptorHookArray = this.getHookRegistry().getAdaptorHooks();
        int n = 0;
        while (n < adaptorHookArray.length) {
            adaptorHookArray[n].frameworkStart(bundleContext);
            ++n;
        }
    }

    public void frameworkStop(BundleContext bundleContext) throws BundleException {
        AdaptorHook[] adaptorHookArray = this.getHookRegistry().getAdaptorHooks();
        int n = 0;
        while (n < adaptorHookArray.length) {
            adaptorHookArray[n].frameworkStop(bundleContext);
            ++n;
        }
        this.storage.frameworkStop(bundleContext);
        bundleContext = null;
    }

    public void frameworkStopping(BundleContext bundleContext) {
        this.stopping = true;
        this.storage.frameworkStopping(bundleContext);
        AdaptorHook[] adaptorHookArray = this.getHookRegistry().getAdaptorHooks();
        int n = 0;
        while (n < adaptorHookArray.length) {
            adaptorHookArray[n].frameworkStopping(bundleContext);
            ++n;
        }
    }

    public int getInitialBundleStartLevel() {
        return this.storage.getInitialBundleStartLevel();
    }

    public void setInitialBundleStartLevel(int n) {
        this.storage.setInitialBundleStartLevel(n);
    }

    public FrameworkLog getFrameworkLog() {
        if (this.log != null) {
            return this.log;
        }
        AdaptorHook[] adaptorHookArray = this.getHookRegistry().getAdaptorHooks();
        int n = 0;
        while (n < adaptorHookArray.length) {
            this.log = adaptorHookArray[n].createFrameworkLog();
            if (this.log != null) {
                return this.log;
            }
            ++n;
        }
        this.log = new BaseAdaptor$1(this);
        return this.log;
    }

    public BundleData createSystemBundleData() throws BundleException {
        return new SystemBundleData(this);
    }

    public BundleWatcher getBundleWatcher() {
        if (this.bundleWatcher != null) {
            return this.bundleWatcher;
        }
        BundleWatcher[] bundleWatcherArray = this.hookRegistry.getWatchers();
        if (bundleWatcherArray.length == 0) {
            return null;
        }
        this.bundleWatcher = new BaseAdaptor$2(this, bundleWatcherArray);
        return this.bundleWatcher;
    }

    public PlatformAdmin getPlatformAdmin() {
        return this.storage.getStateManager();
    }

    public State getState() {
        return this.storage.getStateManager().getSystemState();
    }

    public ClassLoader getBundleClassLoaderParent() {
        ClassLoader classLoader = null;
        ClassLoadingHook[] classLoadingHookArray = this.getHookRegistry().getClassLoadingHooks();
        int n = 0;
        while (n < classLoadingHookArray.length) {
            classLoader = classLoadingHookArray[n].getBundleClassLoaderParent();
            if (classLoader != null) {
                return classLoader;
            }
            ++n;
        }
        return bundleClassLoaderParent;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    public HookRegistry getHookRegistry() {
        return this.hookRegistry;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public BundleFile createBundleFile(Object object, BaseData baseData) throws IOException {
        return this.storage.createBundleFile(object, baseData);
    }

    public boolean isReadOnly() {
        return this.storage.isReadOnly();
    }

    protected BaseStorage getStorage() {
        if (this.storage != null) {
            return this.storage;
        }
        StorageHook[] storageHookArray = this.hookRegistry.getStorageHooks();
        int n = 0;
        while (n < storageHookArray.length && this.storage == null) {
            if (storageHookArray[n] instanceof BaseStorageHook) {
                this.storage = ((BaseStorageHook)storageHookArray[n]).getStorage();
            }
            ++n;
        }
        return this.storage;
    }

    public URLConnection mapLocationToURLConnection(String string) throws BundleException {
        return BaseAdaptor$$Cold.mapLocationToURLConnection(this, string);
    }

    public void handleRuntimeError(Throwable throwable) throws  {
        BaseAdaptor$$Cold.handleRuntimeError(this, throwable);
    }

    public boolean matchDNChain(String string, String[] stringArray) throws  {
        return BaseAdaptor$$Cold.matchDNChain(this, string, stringArray);
    }
}

