/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.stats;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.internal.stats.BundleStats;
import org.eclipse.core.runtime.internal.stats.ClassStats;
import org.eclipse.core.runtime.internal.stats.ClassloaderStats;
import org.eclipse.core.runtime.internal.stats.ResourceBundleStats;
import org.eclipse.core.runtime.internal.stats.StatsManager$$Cold;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingStatsHook;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;

public class StatsManager
implements BundleWatcher,
HookConfigurator,
ClassLoadingStatsHook {
    private Hashtable bundles = new Hashtable(20);
    private Map activationStacks = new HashMap(5);
    private static boolean booting = true;
    private static StatsManager defaultInstance;
    public static boolean MONITOR_ACTIVATION;
    public static boolean MONITOR_CLASSES;
    public static boolean MONITOR_RESOURCES;
    public static String TRACE_FILENAME;
    public static String TRACE_FILTERS;
    public static boolean TRACE_CLASSES;
    public static boolean TRACE_BUNDLES;
    public static final String FRAMEWORK_SYMBOLICNAME = "org.eclipse.osgi";
    private static final String OPTION_MONITOR_ACTIVATION = "org.eclipse.osgi/monitor/activation";
    private static final String OPTION_MONITOR_CLASSES = "org.eclipse.osgi/monitor/classes";
    private static final String OPTION_MONITOR_RESOURCES = "org.eclipse.osgi/monitor/resources";
    private static final String OPTION_TRACE_BUNDLES = "org.eclipse.osgi/trace/activation";
    private static final String OPTION_TRACE_CLASSES = "org.eclipse.osgi/trace/classLoading";
    private static final String OPTION_TRACE_FILENAME = "org.eclipse.osgi/trace/filename";
    private static final String OPTION_TRACE_FILTERS = "org.eclipse.osgi/trace/filters";

    static {
        MONITOR_ACTIVATION = false;
        MONITOR_CLASSES = false;
        MONITOR_RESOURCES = false;
        TRACE_FILENAME = "runtime.traces";
        TRACE_FILTERS = "trace.properties";
        TRACE_CLASSES = false;
        TRACE_BUNDLES = false;
        StatsManager.setDebugOptions();
    }

    public static void setDebugOptions() {
        FrameworkDebugOptions frameworkDebugOptions = FrameworkDebugOptions.getDefault();
        if (frameworkDebugOptions == null) {
            return;
        }
        MONITOR_ACTIVATION = frameworkDebugOptions.getBooleanOption(OPTION_MONITOR_ACTIVATION, false);
        MONITOR_CLASSES = frameworkDebugOptions.getBooleanOption(OPTION_MONITOR_CLASSES, false);
        MONITOR_RESOURCES = frameworkDebugOptions.getBooleanOption(OPTION_MONITOR_RESOURCES, false);
        TRACE_CLASSES = frameworkDebugOptions.getBooleanOption(OPTION_TRACE_CLASSES, false);
        TRACE_BUNDLES = frameworkDebugOptions.getBooleanOption(OPTION_TRACE_BUNDLES, false);
        TRACE_FILENAME = frameworkDebugOptions.getOption(OPTION_TRACE_FILENAME, TRACE_FILENAME);
        TRACE_FILTERS = frameworkDebugOptions.getOption(OPTION_TRACE_FILTERS, TRACE_FILTERS);
    }

    public static void doneBooting() {
        booting = false;
    }

    public static boolean isBooting() {
        return booting;
    }

    public static String[] getArrayFromList(String string) {
        return ManifestElement.getArrayFromList(string, ",");
    }

    public void preFindLocalResource(String string, ClasspathManager classpathManager) {
    }

    public void recordClassDefine(String string, Class clazz, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
    }

    private String getClassloaderId(ClasspathManager classpathManager) {
        return classpathManager.getBaseData().getSymbolicName();
    }

    public void addHooks(HookRegistry hookRegistry) {
        if (Debug.MONITOR_ACTIVATION) {
            hookRegistry.addWatcher(StatsManager.getDefault());
        }
        if (MONITOR_CLASSES || MONITOR_RESOURCES) {
            hookRegistry.addClassLoadingStatsHook(StatsManager.getDefault());
        }
    }

    public static StatsManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new StatsManager();
            defaultInstance.initialize();
        }
        return defaultInstance;
    }

    private void initialize() {
        BundleStats bundleStats = this.findBundle(FRAMEWORK_SYMBOLICNAME, 0L);
        bundleStats.setTimestamp(System.currentTimeMillis());
        bundleStats.setActivationOrder(this.bundles.size());
        bundleStats.setDuringStartup(booting);
    }

    public void watchBundle(Bundle bundle, int n) throws  {
        StatsManager$$Cold.watchBundle(this, bundle, n);
    }

    public void startActivation(Bundle bundle) {
        BundleStats bundleStats = this.findBundle(bundle.getSymbolicName(), bundle.getBundleId());
        bundleStats.setTimestamp(System.currentTimeMillis());
        bundleStats.setActivationOrder(this.bundles.size());
        bundleStats.setDuringStartup(booting);
        Stack<BundleStats> stack = (Stack<BundleStats>)this.activationStacks.get(Thread.currentThread());
        if (stack == null) {
            stack = new Stack<BundleStats>();
            this.activationStacks.put(Thread.currentThread(), stack);
        }
        if (stack.size() != 0) {
            BundleStats bundleStats2 = (BundleStats)stack.peek();
            bundleStats2.activated(bundleStats);
            bundleStats.setActivatedBy(bundleStats2);
        }
        stack.push(bundleStats);
        if (TRACE_BUNDLES) {
            this.traceActivate(bundle, bundleStats);
        }
    }

    public void endActivation(Bundle bundle) {
        Stack stack = (Stack)this.activationStacks.get(Thread.currentThread());
        BundleStats bundleStats = (BundleStats)stack.pop();
        bundleStats.endActivation();
    }

    private void traceActivate(Bundle bundle, BundleStats bundleStats) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(ClassloaderStats.traceFile.getAbsolutePath(), true));
            try {
                long l = ClassloaderStats.traceFile.length();
                printWriter.println("Activating bundle: " + bundle.getSymbolicName());
                printWriter.println("Bundle activation stack:");
                Stack stack = (Stack)this.activationStacks.get(Thread.currentThread());
                int n = stack.size() - 1;
                while (n >= 0) {
                    printWriter.println("\t" + ((BundleStats)stack.get(n)).getSymbolicName());
                    --n;
                }
                printWriter.println("Class loading stack:");
                Stack stack2 = ClassloaderStats.getClassStack();
                int n2 = stack2.size() - 1;
                while (n2 >= 0) {
                    printWriter.println("\t" + ((ClassStats)stack2.get(n2)).getClassName());
                    --n2;
                }
                printWriter.println("Stack trace:");
                new Throwable().printStackTrace(printWriter);
                bundleStats.setTraceStart(l);
            }
            finally {
                printWriter.close();
                bundleStats.setTraceEnd(ClassloaderStats.traceFile.length());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public BundleStats findBundle(String string, long l) {
        BundleStats bundleStats = (BundleStats)this.bundles.get(new Long(l));
        try {
            if (bundleStats == null) {
                bundleStats = new BundleStats(string, l);
                this.bundles.put(new Long(l), bundleStats);
            }
        }
        catch (IllegalAccessError illegalAccessError) {
            illegalAccessError.printStackTrace();
        }
        return bundleStats;
    }

    public BundleStats[] getBundles() {
        return this.bundles.values().toArray(new BundleStats[this.bundles.size()]);
    }

    public BundleStats getBundle(long l) {
        return (BundleStats)this.bundles.get(new Long(l));
    }

    public void preFindLocalClass(String string, ClasspathManager classpathManager) throws ClassNotFoundException {
        if (MONITOR_CLASSES) {
            ClassloaderStats.startLoadingClass(this.getClassloaderId(classpathManager), string);
        }
    }

    public void postFindLocalClass(String string, Class clazz, ClasspathManager classpathManager) {
        if (MONITOR_CLASSES) {
            ClassloaderStats.endLoadingClass(this.getClassloaderId(classpathManager), string, clazz != null);
        }
    }

    public void postFindLocalResource(String string, URL uRL, ClasspathManager classpathManager) {
        if (MONITOR_RESOURCES && uRL != null && string.endsWith(".properties")) {
            ClassloaderStats.loadedBundle(this.getClassloaderId(classpathManager), new ResourceBundleStats(this.getClassloaderId(classpathManager), string, uRL));
        }
    }
}

