/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Dictionary;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.core.runtime.internal.adaptor.CachedManifest;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.EclipseStorageHook$$Cold;
import org.eclipse.core.runtime.internal.adaptor.PluginConverterImpl;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public final class EclipseStorageHook
implements StorageHook,
HookConfigurator {
    private static final String PROP_CHECK_CONFIG = "osgi.checkConfiguration";
    private static final String PROP_COMPATIBILITY_LAZYSTART = "osgi.compatibility.eagerStart.LazyActivation";
    private static final boolean COMPATIBILITY_LAZYSTART = Boolean.valueOf(FrameworkProperties.getProperty("osgi.compatibility.eagerStart.LazyActivation", "true"));
    private static final int STORAGE_VERION = 2;
    public static final String KEY;
    public static final int HASHCODE;
    private static final byte FLAG_LAZY_START = 1;
    private static final byte FLAG_HAS_PACKAGE_INFO = 2;
    private static final byte FLAG_HAS_LAZY_INCLUDE = 8;
    private long manifestTimeStamp = 0L;
    private byte manifestType = 0;
    private BaseData bundledata;
    private String pluginClass = null;
    private String[] lazyStartExcludes;
    private String[] lazyStartIncludes;
    private String buddyList;
    private String registeredBuddyList;
    private byte flags = 0;
    static Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.internal.adaptor.EclipseStorageHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        KEY = clazz.getName();
        HASHCODE = KEY.hashCode();
    }

    public int getStorageVersion() {
        return 2;
    }

    public StorageHook create(BaseData baseData) throws BundleException {
        EclipseStorageHook eclipseStorageHook = new EclipseStorageHook();
        eclipseStorageHook.bundledata = baseData;
        return eclipseStorageHook;
    }

    public void initialize(Dictionary dictionary) throws BundleException {
        ManifestElement manifestElement;
        String string;
        String string2 = (String)dictionary.get("Bundle-ActivationPolicy");
        if (string2 != null) {
            this.parseActivationPolicy(this, string2);
        } else {
            string = (String)dictionary.get("Eclipse-LazyStart");
            if (string == null) {
                string = (String)dictionary.get("Eclipse-AutoStart");
            }
            this.parseLazyStart(this, string);
        }
        this.pluginClass = (String)dictionary.get("Plugin-Class");
        this.buddyList = (String)dictionary.get("Eclipse-BuddyPolicy");
        this.registeredBuddyList = (String)dictionary.get("Eclipse-RegisterBuddy");
        if (EclipseStorageHook.hasPackageInfo(this.bundledata.getEntry("META-INF/MANIFEST.MF"))) {
            this.flags = (byte)(this.flags | 2);
        }
        if ((string = (String)dictionary.get("Generated-from")) != null && (manifestElement = ManifestElement.parseHeader("Generated-from", string)[0]) != null) {
            this.manifestTimeStamp = Long.parseLong(manifestElement.getValue());
            this.manifestType = Byte.parseByte(manifestElement.getAttribute("type"));
        }
        if (this.isAutoStartable()) {
            this.bundledata.setStatus(this.bundledata.getStatus() | 2);
            if (COMPATIBILITY_LAZYSTART) {
                this.bundledata.setStatus(this.bundledata.getStatus() | 1 | 4);
            }
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        if (this.bundledata == null) {
            throw (Throwable)new IllegalStateException();
        }
        dataOutputStream.writeByte(this.flags);
        String[] stringArray = this.getLazyStartExcludes();
        if (stringArray == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                dataOutputStream.writeUTF(stringArray[n]);
                ++n;
            }
        }
        if ((this.flags & 8) != 0) {
            String[] stringArray2 = this.getLazyStartIncludes();
            if (stringArray2 == null) {
                dataOutputStream.writeInt(0);
            } else {
                dataOutputStream.writeInt(stringArray2.length);
                int n = 0;
                while (n < stringArray2.length) {
                    dataOutputStream.writeUTF(stringArray2[n]);
                    ++n;
                }
            }
        }
        AdaptorUtil.writeStringOrNull(dataOutputStream, this.getBuddyList());
        AdaptorUtil.writeStringOrNull(dataOutputStream, this.getRegisteredBuddyList());
        AdaptorUtil.writeStringOrNull(dataOutputStream, this.getPluginClass());
        dataOutputStream.writeLong(this.getManifestTimeStamp());
        dataOutputStream.writeByte(this.getManifestType());
    }

    public int getKeyHashCode() {
        return HASHCODE;
    }

    public Object getKey() {
        return KEY;
    }

    public boolean isLazyStart() {
        return (this.flags & 1) == 1;
    }

    public String[] getLazyStartExcludes() {
        return this.lazyStartExcludes;
    }

    public String[] getLazyStartIncludes() {
        return this.lazyStartIncludes;
    }

    public String getBuddyList() {
        return this.buddyList;
    }

    public boolean hasPackageInfo() {
        return (this.flags & 2) == 2;
    }

    public String getPluginClass() {
        return this.pluginClass;
    }

    public String getRegisteredBuddyList() {
        return this.registeredBuddyList;
    }

    public long getManifestTimeStamp() {
        return this.manifestTimeStamp;
    }

    public byte getManifestType() {
        return this.manifestType;
    }

    public boolean isAutoStartable() {
        return this.isLazyStart() || this.lazyStartExcludes != null && this.lazyStartExcludes.length > 0;
    }

    private void parseLazyStart(EclipseStorageHook eclipseStorageHook, String string) {
        eclipseStorageHook.lazyStartExcludes = null;
        ManifestElement[] manifestElementArray = null;
        try {
            manifestElementArray = ManifestElement.parseHeader("Eclipse-LazyStart", string);
        }
        catch (BundleException bundleException) {
            String string2 = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_CANNOT_GET_HEADERS, eclipseStorageHook.bundledata.getLocation());
            this.bundledata.getAdaptor().getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string2, 0, bundleException, null));
        }
        if (manifestElementArray == null) {
            return;
        }
        if ("true".equalsIgnoreCase(manifestElementArray[0].getValue())) {
            eclipseStorageHook.flags = (byte)(eclipseStorageHook.flags | 1);
        }
        String[] stringArray = ManifestElement.getArrayFromList(manifestElementArray[0].getAttribute("exceptions"));
        eclipseStorageHook.lazyStartExcludes = stringArray;
    }

    private void parseActivationPolicy(EclipseStorageHook eclipseStorageHook, String string) {
        eclipseStorageHook.lazyStartExcludes = null;
        ManifestElement[] manifestElementArray = null;
        try {
            manifestElementArray = ManifestElement.parseHeader("Bundle-ActivationPolicy", string);
        }
        catch (BundleException bundleException) {
            String string2 = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_CANNOT_GET_HEADERS, eclipseStorageHook.bundledata.getLocation());
            this.bundledata.getAdaptor().getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string2, 0, bundleException, null));
        }
        if (manifestElementArray == null) {
            return;
        }
        if (!"lazy".equalsIgnoreCase(manifestElementArray[0].getValue())) {
            return;
        }
        eclipseStorageHook.flags = (byte)(eclipseStorageHook.flags | 1);
        eclipseStorageHook.lazyStartExcludes = ManifestElement.getArrayFromList(manifestElementArray[0].getDirective("exclude"));
        eclipseStorageHook.lazyStartIncludes = ManifestElement.getArrayFromList(manifestElementArray[0].getDirective("include"));
        if (eclipseStorageHook.lazyStartIncludes != null) {
            eclipseStorageHook.flags = (byte)(eclipseStorageHook.flags | 8);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasPackageInfo(URL var0) {
        if (var0 == null) {
            return false;
        }
        var1_1 = null;
        try {
            var1_1 = new BufferedReader(new InputStreamReader(var0.openStream()));
            ** GOTO lbl-1000
        }
        catch (IOException v0) {
            if (var1_1 == null) return false;
            try {
                var1_1.close();
                return false;
            }
            catch (IOException v1) {
                return false;
            }
        }
        catch (Throwable var3_3) {
            if (var1_1 == null) throw var3_3;
            try {
                var1_1.close();
                throw var3_3;
            }
            catch (IOException v2) {}
            throw var3_3;
        }
lbl21:
        // 1 sources

        while (true) {
            try {
                var1_1.close();
                return true;
            }
            catch (IOException v3) {}
            return true;
        }
lbl-1000:
        // 2 sources

        {
            ** while ((var2_2 = var1_1.readLine()) != null)
        }
lbl-1000:
        // 1 sources

        {
            if (!var2_2.startsWith("Specification-Title: ") && !var2_2.startsWith("Specification-Version: ") && !var2_2.startsWith("Specification-Vendor: ") && !var2_2.startsWith("Implementation-Title: ") && !var2_2.startsWith("Implementation-Version: ") && !var2_2.startsWith("Implementation-Vendor: ")) continue;
            if (var1_1 == null) return true;
            ** continue;
lbl31:
            // 1 sources

            ** GOTO lbl21
        }
lbl32:
        // 1 sources

        if (var1_1 == null) return false;
        try {
            var1_1.close();
            return false;
        }
        catch (IOException v4) {}
        return false;
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addStorageHook(this);
    }

    Dictionary createCachedManifest(boolean bl) throws BundleException {
        return bl ? this.getGeneratedManifest() : new CachedManifest(this);
    }

    public Dictionary getGeneratedManifest() throws BundleException {
        Dictionary dictionary = AdaptorUtil.loadManifestFrom(this.bundledata);
        if (dictionary != null) {
            Dictionary dictionary2;
            if (!this.isComplete(dictionary) && (dictionary2 = this.generateManifest(dictionary)) != null) {
                return dictionary2;
            }
            this.manifestType = 1;
            if (this.bundledata.getBundleFile().getBaseFile().isFile()) {
                this.manifestTimeStamp = this.bundledata.getBundleFile().getBaseFile().lastModified();
                this.manifestType = (byte)(this.manifestType | 8);
            } else {
                this.manifestTimeStamp = this.bundledata.getBundleFile().getEntry("META-INF/MANIFEST.MF").getTime();
            }
            return dictionary;
        }
        Dictionary dictionary3 = this.generateManifest(null);
        if (dictionary3 == null) {
            throw (Throwable)new BundleException(NLS.bind(EclipseAdaptorMsg.ECLIPSE_DATA_MANIFEST_NOT_FOUND, this.bundledata.getLocation()));
        }
        return dictionary3;
    }

    private boolean isComplete(Dictionary dictionary) {
        if (dictionary.get("Bundle-SymbolicName") != null) {
            return true;
        }
        return this.bundledata.getEntry("plugin.xml") == null && this.bundledata.getEntry("fragment.xml") == null;
    }

    public BaseData getBaseData() {
        return this.bundledata;
    }

    public void copy(StorageHook storageHook) {
    }

    public void validate() throws IllegalArgumentException {
        this.checkTimeStamp();
    }

    public Dictionary getManifest(boolean bl) throws BundleException {
        return this.createCachedManifest(bl);
    }

    public boolean forgetStatusChange(int n) {
        return false;
    }

    public boolean forgetStartLevelChange(int n) {
        return false;
    }

    public boolean matchDNChain(String string) {
        return false;
    }

    public StorageHook load(BaseData baseData, DataInputStream dataInputStream) throws IOException {
        EclipseStorageHook eclipseStorageHook = new EclipseStorageHook();
        eclipseStorageHook.bundledata = baseData;
        eclipseStorageHook.flags = dataInputStream.readByte();
        int n = dataInputStream.readInt();
        String[] stringArray = n > 0 ? new String[n] : null;
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = dataInputStream.readUTF();
            ++n2;
        }
        eclipseStorageHook.lazyStartExcludes = stringArray;
        if ((eclipseStorageHook.flags & 8) != 0) {
            n = dataInputStream.readInt();
            stringArray = n > 0 ? new String[n] : null;
            n2 = 0;
            while (n2 < n) {
                stringArray[n2] = dataInputStream.readUTF();
                ++n2;
            }
            eclipseStorageHook.lazyStartIncludes = stringArray;
        }
        eclipseStorageHook.buddyList = AdaptorUtil.readString(dataInputStream, false);
        eclipseStorageHook.registeredBuddyList = AdaptorUtil.readString(dataInputStream, false);
        eclipseStorageHook.pluginClass = AdaptorUtil.readString(dataInputStream, false);
        eclipseStorageHook.manifestTimeStamp = dataInputStream.readLong();
        eclipseStorageHook.manifestType = dataInputStream.readByte();
        if (eclipseStorageHook.isAutoStartable()) {
            if ((baseData.getStatus() & 2) == 0) {
                baseData.setStatus(baseData.getStatus() | 2);
            }
            if (COMPATIBILITY_LAZYSTART && (baseData.getStatus() & 1) == 0) {
                baseData.setStatus(baseData.getStatus() | 1 | 4);
            }
        }
        return eclipseStorageHook;
    }

    public boolean compare(KeyedElement keyedElement) throws  {
        return EclipseStorageHook$$Cold.compare(this, keyedElement);
    }

    private void checkTimeStamp() throws IllegalArgumentException {
        if (!this.checkManifestTimeStamp()) {
            throw (Throwable)new IllegalArgumentException();
        }
    }

    private boolean checkManifestTimeStamp() {
        if (!"true".equalsIgnoreCase(FrameworkProperties.getProperty(PROP_CHECK_CONFIG))) {
            return true;
        }
        if (PluginConverterImpl.getTimeStamp(this.bundledata.getBundleFile().getBaseFile(), this.getManifestType()) == this.getManifestTimeStamp()) {
            if ((this.getManifestType() & 9) != 0) {
                return true;
            }
            String string = FrameworkProperties.getProperty("osgi.manifest.cache");
            Location location = LocationManager.getConfigurationLocation().getParentLocation();
            if (location != null) {
                try {
                    return this.checkManifestAndParent(string, this.bundledata.getSymbolicName(), this.bundledata.getVersion().toString(), this.getManifestType()) != null;
                }
                catch (BundleException bundleException) {
                    return false;
                }
            }
            File file = new File(string, String.valueOf(this.bundledata.getSymbolicName()) + '_' + this.bundledata.getVersion() + ".MF");
            if (file.isFile()) {
                return true;
            }
        }
        return false;
    }

    private Headers checkManifestAndParent(String string, String string2, String string3, byte by) throws BundleException {
        Headers headers = this.basicCheckManifest(string, string2, string3, by);
        if (headers != null) {
            return headers;
        }
        Location location = null;
        location = LocationManager.getConfigurationLocation().getParentLocation();
        if (location != null) {
            headers = this.basicCheckManifest(new File(location.getURL().getFile(), "org.eclipse.osgi/manifests").toString(), string2, string3, by);
        }
        return headers;
    }

    private Headers basicCheckManifest(String string, String string2, String string3, byte by) throws BundleException {
        File file = new File(string, String.valueOf(string2) + '_' + string3 + ".MF");
        if (PluginConverterImpl.upToDate(file, this.bundledata.getBundleFile().getBaseFile(), by)) {
            try {
                return Headers.parseManifest(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    private Dictionary generateManifest(Dictionary dictionary) throws BundleException {
        Object object;
        Dictionary dictionary2;
        Object object2;
        String string = FrameworkProperties.getProperty("osgi.manifest.cache");
        if (this.bundledata.getSymbolicName() != null && (object2 = this.checkManifestAndParent(string, this.bundledata.getSymbolicName(), this.bundledata.getVersion().toString(), this.manifestType)) != null) {
            return (Dictionary)object2;
        }
        object2 = PluginConverterImpl.getDefault();
        if (object2 == null) {
            object2 = new PluginConverterImpl(this.bundledata.getAdaptor(), this.bundledata.getAdaptor().getContext());
        }
        try {
            dictionary2 = ((PluginConverterImpl)object2).convertManifest(this.bundledata.getBundleFile().getBaseFile(), true, null, true, null);
        }
        catch (PluginConversionException pluginConversionException) {
            String string2 = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_ERROR_CONVERTING, this.bundledata.getBundleFile().getBaseFile());
            throw (Throwable)new BundleException(string2, pluginConversionException);
        }
        Version version = Version.parseVersion((String)dictionary2.get("Bundle-Version"));
        String string3 = ManifestElement.parseHeader("Bundle-SymbolicName", (String)dictionary2.get("Bundle-SymbolicName"))[0].getValue();
        ManifestElement manifestElement = ManifestElement.parseHeader("Generated-from", (String)dictionary2.get("Generated-from"))[0];
        Headers headers = this.checkManifestAndParent(string, string3, version.toString(), Byte.parseByte(manifestElement.getAttribute("type")));
        this.manifestTimeStamp = Long.parseLong(manifestElement.getValue());
        this.manifestType = Byte.parseByte(manifestElement.getAttribute("type"));
        if (this.bundledata.getAdaptor().isReadOnly() || headers != null) {
            return headers;
        }
        if (dictionary != null) {
            object = dictionary.keys();
            while (object.hasMoreElements()) {
                Object k = object.nextElement();
                dictionary2.put(k, dictionary.get(k));
            }
        }
        object = new File(string, String.valueOf(string3) + '_' + version.toString() + ".MF");
        try {
            ((PluginConverterImpl)object2).writeManifest((File)object, dictionary2, true);
        }
        catch (Exception exception) {}
        return dictionary2;
    }

    public FrameworkAdaptor getAdaptor() {
        if (this.bundledata != null) {
            return this.bundledata.getAdaptor();
        }
        return null;
    }
}

