/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.Semaphore;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.service.runnable.ApplicationLauncher;
import org.eclipse.osgi.service.runnable.ApplicationRunnable;
import org.eclipse.osgi.service.runnable.ParameterizedRunnable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class EclipseAppLauncher
implements ApplicationLauncher {
    private volatile ParameterizedRunnable runnable = null;
    private Object appContext = null;
    private Semaphore runningLock = new Semaphore(1);
    private Semaphore waitForAppLock = new Semaphore(0);
    private BundleContext context;
    private boolean relaunch = false;
    private boolean failOnNoDefault = false;
    private FrameworkLog log;
    static Class class$0;
    static Class class$1;

    public Object start(Object object) throws Exception {
        if (this.failOnNoDefault && this.runnable == null) {
            throw (Throwable)new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_NO_APPLICATION);
        }
        Object object2 = null;
        do {
            try {
                object2 = this.runApplication(object);
            }
            catch (Exception exception) {
                if (!this.relaunch || (this.context.getBundle().getState() & 0x20) == 0) {
                    throw (Throwable)exception;
                }
                if (this.log == null) continue;
                this.log.log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, EclipseAdaptorMsg.ECLIPSE_STARTUP_APP_ERROR, 1, exception, null));
            }
        } while (this.relaunch && (this.context.getBundle().getState() & 0x20) != 0);
        return object2;
    }

    private Object runApplication(Object object) throws Exception {
        this.waitForAppLock.acquire();
        this.runningLock.acquire();
        if (EclipseStarter.debug) {
            String string = FrameworkProperties.getProperty("eclipse.startTime");
            long l = string == null ? 0L : Long.parseLong(string);
            System.out.println("Starting application: " + (System.currentTimeMillis() - l));
        }
        if (Profile.STARTUP || Profile.BENCHMARK) {
            Profile.logTime("EclipseStarter.run(Object)()", "framework initialized! starting application...");
        }
        try {
            Object object2 = this.runnable.run(this.appContext != null ? this.appContext : object);
            return object2;
        }
        finally {
            if (Profile.STARTUP) {
                Profile.logExit("EclipseStarter.run(Object)()");
            }
            this.runnable = null;
            this.appContext = null;
            this.runningLock.release();
        }
    }

    public EclipseAppLauncher(BundleContext bundleContext, boolean bl, boolean bl2, FrameworkLog frameworkLog) {
        this.context = bundleContext;
        this.relaunch = bl;
        this.failOnNoDefault = bl2;
        this.log = frameworkLog;
        this.findRunnableService();
    }

    private void findRunnableService() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.runnable.ParameterizedRunnable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        String string = clazz.getName();
        ServiceReference[] serviceReferenceArray = null;
        try {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.osgi.service.runnable.ParameterizedRunnable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            serviceReferenceArray = this.context.getServiceReferences(clazz2.getName(), "(&(objectClass=" + string + ")(eclipse.application=*))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (serviceReferenceArray != null && serviceReferenceArray.length > 0) {
            this.runnable = (ParameterizedRunnable)this.context.getService(serviceReferenceArray[0]);
            this.relaunch = false;
            this.waitForAppLock.release();
        }
    }

    public void launch(ParameterizedRunnable parameterizedRunnable, Object object) {
        this.waitForAppLock.acquire(-1L);
        if (!this.runningLock.acquire(-1L)) {
            throw (Throwable)new IllegalStateException("An application is aready running.");
        }
        this.runnable = parameterizedRunnable;
        this.appContext = object;
        this.waitForAppLock.release();
        this.runningLock.release();
    }

    public void shutdown() {
        if (this.runningLock.acquire(-1L)) {
            return;
        }
        ParameterizedRunnable parameterizedRunnable = this.runnable;
        if (parameterizedRunnable instanceof ApplicationRunnable) {
            ((ApplicationRunnable)parameterizedRunnable).stop();
            this.runningLock.acquire(60000L);
        }
    }

    public Object reStart(Object object) throws Exception {
        ServiceReference[] serviceReferenceArray = null;
        serviceReferenceArray = this.context.getServiceReferences("org.osgi.service.application.ApplicationDescriptor", "(eclipse.application.default=true)");
        if (serviceReferenceArray != null && serviceReferenceArray.length > 0) {
            Object object2 = this.context.getService(serviceReferenceArray[0]);
            Class<?> clazz = object2.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.util.Map");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            classArray[0] = clazz2;
            Method method = clazz.getMethod("launch", classArray);
            method.invoke(object2, new Object[1]);
            return this.start(object);
        }
        throw (Throwable)new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_NO_APPLICATION);
    }
}

