/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.adaptor.LocationManager$$Cold;
import org.eclipse.core.runtime.internal.adaptor.BasicLocation;
import org.eclipse.core.runtime.internal.adaptor.LocationHelper;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.datalocation.Location;

public class LocationManager {
    private static Location installLocation = null;
    private static Location configurationLocation = null;
    private static Location userLocation = null;
    private static Location instanceLocation = null;
    public static final String READ_ONLY_AREA_SUFFIX = ".readOnly";
    public static final String PROP_INSTALL_AREA = "osgi.install.area";
    public static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    public static final String PROP_CONFIG_AREA_DEFAULT = "osgi.configuration.area.default";
    public static final String PROP_SHARED_CONFIG_AREA = "osgi.sharedConfiguration.area";
    public static final String PROP_INSTANCE_AREA = "osgi.instance.area";
    public static final String PROP_INSTANCE_AREA_DEFAULT = "osgi.instance.area.default";
    public static final String PROP_USER_AREA = "osgi.user.area";
    public static final String PROP_USER_AREA_DEFAULT = "osgi.user.area.default";
    public static final String PROP_MANIFEST_CACHE = "osgi.manifest.cache";
    public static final String PROP_USER_HOME = "user.home";
    public static final String PROP_USER_DIR = "user.dir";
    public static final String BUNDLES_DIR = "bundles";
    public static final String STATE_FILE = ".state";
    public static final String LAZY_FILE = ".lazy";
    public static final String BUNDLE_DATA_FILE = ".bundledata";
    public static final String MANIFESTS_DIR = "manifests";
    public static final String CONFIG_FILE = "config.ini";
    public static final String ECLIPSE_PROPERTIES = "eclipse.properties";
    private static final String ECLIPSE = "eclipse";
    private static final String PRODUCT_SITE_MARKER = ".eclipseproduct";
    private static final String PRODUCT_SITE_ID = "id";
    private static final String PRODUCT_SITE_VERSION = "version";
    private static final String CONFIG_DIR = "configuration";
    private static final String NONE = "@none";
    private static final String NO_DEFAULT = "@noDefault";
    private static final String USER_HOME = "@user.home";
    private static final String USER_DIR = "@user.dir";

    public static URL buildURL(String string, boolean bl) {
        return LocationHelper.buildURL(string, bl);
    }

    private static void mungeConfigurationLocation() {
        String string = FrameworkProperties.getProperty(PROP_CONFIG_AREA);
        if (string != null && string.endsWith(".cfg")) {
            int n = string.lastIndexOf(47);
            if (n < 0) {
                n = string.lastIndexOf(92);
            }
            string = string.substring(0, n + 1);
            FrameworkProperties.setProperty(PROP_CONFIG_AREA, string);
        }
    }

    public static void initializeLocations() {
        URL uRL;
        installLocation = LocationManager.buildLocation(PROP_INSTALL_AREA, null, "", true);
        Location location = LocationManager.buildLocation(PROP_USER_AREA_DEFAULT, null, "", false);
        URL uRL2 = uRL = location == null ? null : location.getURL();
        if (uRL == null) {
            uRL = LocationManager.buildURL(new File(FrameworkProperties.getProperty(PROP_USER_HOME), "user").getAbsolutePath(), true);
        }
        userLocation = LocationManager.buildLocation(PROP_USER_AREA, uRL, "", false);
        location = LocationManager.buildLocation(PROP_INSTANCE_AREA_DEFAULT, null, "", false);
        URL uRL3 = uRL = location == null ? null : location.getURL();
        if (uRL == null) {
            uRL = LocationManager.buildURL(new File(FrameworkProperties.getProperty(PROP_USER_DIR), "workspace").getAbsolutePath(), true);
        }
        instanceLocation = LocationManager.buildLocation(PROP_INSTANCE_AREA, uRL, "", false);
        LocationManager.mungeConfigurationLocation();
        location = LocationManager.buildLocation(PROP_CONFIG_AREA_DEFAULT, null, "", false);
        URL uRL4 = uRL = location == null ? null : location.getURL();
        if (uRL == null) {
            uRL = LocationManager.buildURL(LocationManager.computeDefaultConfigurationLocation(), true);
        }
        configurationLocation = LocationManager.buildLocation(PROP_CONFIG_AREA, uRL, "", false);
        URL uRL5 = LocationManager.computeSharedConfigurationLocation();
        if (uRL5 != null && !uRL5.equals(configurationLocation.getURL())) {
            BasicLocation basicLocation = new BasicLocation(null, uRL5, true);
            ((BasicLocation)configurationLocation).setParent(basicLocation);
        }
        LocationManager.initializeDerivedConfigurationLocations();
    }

    private static Location buildLocation(String string, URL uRL, String string2, boolean bl) {
        Object object;
        boolean bl2;
        String string3 = FrameworkProperties.clearProperty(string);
        String string4 = FrameworkProperties.getProperty(String.valueOf(string) + READ_ONLY_AREA_SUFFIX);
        boolean bl3 = bl2 = string4 == null ? bl : Boolean.valueOf(string4);
        if (string3 == null) {
            return new BasicLocation(string, uRL, bl2);
        }
        String string5 = string3.trim();
        if (string5.equalsIgnoreCase(NONE)) {
            return null;
        }
        if (string5.equalsIgnoreCase(NO_DEFAULT)) {
            return new BasicLocation(string, null, bl2);
        }
        if (string5.startsWith(USER_HOME)) {
            object = LocationManager.substituteVar(string3, USER_HOME, PROP_USER_HOME);
            string3 = new File((String)object, string2).getAbsolutePath();
        } else if (string5.startsWith(USER_DIR)) {
            object = LocationManager.substituteVar(string3, USER_DIR, PROP_USER_DIR);
            string3 = new File((String)object, string2).getAbsolutePath();
        }
        object = LocationManager.buildURL(string3, true);
        BasicLocation basicLocation = null;
        if (object != null) {
            basicLocation = new BasicLocation(string, null, bl2);
            basicLocation.setURL((URL)object, false);
        }
        return basicLocation;
    }

    private static void initializeDerivedConfigurationLocations() {
        if (FrameworkProperties.getProperty(PROP_MANIFEST_CACHE) == null) {
            FrameworkProperties.setProperty(PROP_MANIFEST_CACHE, LocationManager.getConfigurationFile(MANIFESTS_DIR).getAbsolutePath());
        }
    }

    private static URL computeInstallConfigurationLocation() {
        String string = FrameworkProperties.getProperty(PROP_INSTALL_AREA);
        if (string != null) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    private static URL computeSharedConfigurationLocation() {
        String string = FrameworkProperties.getProperty(PROP_SHARED_CONFIG_AREA);
        if (string == null) {
            return null;
        }
        try {
            URL uRL = new URL(string);
            if (uRL.getPath().startsWith("/")) {
                return uRL;
            }
            URL uRL2 = installLocation.getURL();
            if (!uRL.getProtocol().equals(uRL2.getProtocol())) {
                return uRL;
            }
            uRL = new URL(uRL2, uRL.getPath());
            FrameworkProperties.setProperty(PROP_SHARED_CONFIG_AREA, uRL.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }

    private static String computeDefaultConfigurationLocation() {
        URL uRL = LocationManager.computeInstallConfigurationLocation();
        if (uRL != null) {
            File file = new File(uRL.getFile());
            if ("file".equals(uRL.getProtocol()) && LocationManager.canWrite(file)) {
                return new File(file, CONFIG_DIR).getAbsolutePath();
            }
        }
        return LocationManager.computeDefaultUserAreaLocation(CONFIG_DIR);
    }

    private static boolean canWrite(File file) {
        if (!file.canWrite()) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        File file2 = null;
        try {
            try {
                file2 = File.createTempFile("writtableArea", ".dll", file);
            }
            catch (IOException iOException) {
                if (file2 != null) {
                    file2.delete();
                }
                return false;
            }
        }
        finally {
            if (file2 != null) {
                file2.delete();
            }
        }
        return true;
    }

    public static Location getUserLocation() {
        return userLocation;
    }

    public static Location getConfigurationLocation() {
        return configurationLocation;
    }

    public static Location getInstallLocation() {
        return installLocation;
    }

    public static Location getInstanceLocation() {
        return instanceLocation;
    }

    public static File getOSGiConfigurationDir() {
        return new File(configurationLocation.getURL().getFile(), "org.eclipse.osgi");
    }

    public static File getConfigurationFile(String string) {
        File file = LocationManager.getOSGiConfigurationDir();
        if (!file.exists()) {
            file.mkdirs();
        }
        return new File(file, string);
    }

    private static String substituteVar(String string, String string2, String string3) throws  {
        return LocationManager$$Cold.substituteVar(string, string2, string3);
    }

    private static String computeDefaultUserAreaLocation(String string) throws  {
        return LocationManager$$Cold.computeDefaultUserAreaLocation(string);
    }
}

