/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.runtime.adaptor.EclipseLog$$Cold;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.SecureAction;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;

public class EclipseLog
implements FrameworkLog {
    private static final String PASSWORD = "-password";
    protected static final String SESSION = "!SESSION";
    protected static final String ENTRY = "!ENTRY";
    protected static final String SUBENTRY = "!SUBENTRY";
    protected static final String MESSAGE = "!MESSAGE";
    protected static final String STACK = "!STACK";
    protected static final String LINE_SEPARATOR;
    protected static final String TAB_STRING = "\t";
    public static final int DEFAULT_LOG_SIZE = 1000;
    public static final int DEFAULT_LOG_FILES = 10;
    public static final int LOG_SIZE_MIN = 10;
    public static final String PROP_LOG_SIZE_MAX = "eclipse.log.size.max";
    public static final String PROP_LOG_FILE_MAX = "eclipse.log.backup.max";
    public static final String LOG_EXT = ".log";
    public static final String BACKUP_MARK = ".bak_";
    private static final SecureAction secureAction;
    protected boolean consoleLog;
    protected boolean newSession;
    protected File outFile;
    protected Writer writer;
    int maxLogSize;
    int maxLogFiles;
    int backupIdx;

    static {
        String string = System.getProperty("line.separator");
        LINE_SEPARATOR = string == null ? "\n" : string;
        secureAction = (SecureAction)AccessController.doPrivileged(SecureAction.createSecureAction());
    }

    public EclipseLog(File file) {
        this.consoleLog = false;
        this.newSession = true;
        this.maxLogSize = 1000;
        this.maxLogFiles = 10;
        this.backupIdx = 0;
        this.outFile = file;
        this.writer = null;
        this.readLogProperties();
    }

    public EclipseLog() {
        this((Writer)null);
    }

    public synchronized void setWriter(Writer writer, boolean bl) {
        this.setOutput(null, writer, bl);
    }

    public synchronized File getFile() {
        return this.outFile;
    }

    public void setConsoleLog(boolean bl) {
        this.consoleLog = bl;
    }

    protected void writeln(String string) throws IOException {
        this.write(string);
        this.writeln();
    }

    protected void writeln() throws IOException {
        this.write(LINE_SEPARATOR);
    }

    protected void writeSpace() throws IOException {
        this.write(" ");
    }

    protected void readLogProperties() {
        String string;
        String string2 = secureAction.getProperty(PROP_LOG_SIZE_MAX);
        if (string2 != null) {
            this.maxLogSize = Integer.parseInt(string2);
            if (this.maxLogSize != 0 && this.maxLogSize < 10) {
                this.maxLogSize = 10;
            }
        }
        if ((string = secureAction.getProperty(PROP_LOG_FILE_MAX)) != null) {
            this.maxLogFiles = Integer.parseInt(string);
            if (this.maxLogFiles < 1) {
                this.maxLogFiles = 10;
            }
        }
    }

    public EclipseLog(Writer writer) throws  {
        EclipseLog$$Cold.$init$(this, writer);
    }

    private Throwable getRoot(Throwable throwable) {
        Throwable throwable2;
        Throwable throwable3 = null;
        if (throwable instanceof BundleException) {
            throwable3 = ((BundleException)throwable).getNestedException();
        }
        if (throwable instanceof InvocationTargetException) {
            throwable3 = ((InvocationTargetException)throwable).getTargetException();
        }
        if ((throwable3 instanceof InvocationTargetException || throwable3 instanceof BundleException) && (throwable2 = this.getRoot(throwable3)) != null) {
            throwable3 = throwable2;
        }
        return throwable3;
    }

    protected void writeArgs(String string, String[] stringArray) throws IOException {
        EclipseLog$$Cold.writeArgs(this, string, stringArray);
    }

    protected String getSessionTimestamp() throws  {
        return EclipseLog$$Cold.getSessionTimestamp(this);
    }

    protected void writeSession() throws IOException {
        EclipseLog$$Cold.writeSession(this);
    }

    public void close() throws  {
        EclipseLog$$Cold.close(this);
    }

    protected void openFile() {
        if (this.writer == null) {
            if (this.outFile != null) {
                try {
                    this.writer = this.logForStream(secureAction.getFileOutputStream(this.outFile, true));
                }
                catch (IOException iOException) {
                    this.writer = this.logForStream(System.err);
                }
            } else {
                this.writer = this.logForStream(System.err);
            }
        }
    }

    protected void closeFile() throws  {
        EclipseLog$$Cold.closeFile(this);
    }

    public void log(FrameworkEvent frameworkEvent) throws  {
        EclipseLog$$Cold.log(this, frameworkEvent);
    }

    public synchronized void log(FrameworkLogEntry frameworkLogEntry) throws  {
        EclipseLog$$Cold.log(this, frameworkLogEntry);
    }

    public synchronized void setFile(File file, boolean bl) throws IOException {
        if (file != null && !file.equals(this.outFile)) {
            this.readLogProperties();
            this.backupIdx = 0;
        }
        this.setOutput(file, null, bl);
        FrameworkProperties.setProperty("osgi.logfile", file.getAbsolutePath());
    }

    private void setOutput(File file, Writer writer, boolean bl) {
        if (file == null || !file.equals(this.outFile)) {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.writer = null;
            }
            File file2 = this.outFile;
            this.outFile = file;
            this.writer = writer;
            boolean bl2 = false;
            if (bl && file2 != null && file2.isFile()) {
                InputStreamReader inputStreamReader = null;
                try {
                    try {
                        this.openFile();
                        inputStreamReader = new InputStreamReader((InputStream)secureAction.getFileInputStream(file2), "UTF-8");
                        this.copyReader(inputStreamReader, this.writer);
                    }
                    catch (IOException iOException) {
                        bl2 = true;
                        iOException.printStackTrace();
                        if (inputStreamReader != null) {
                            try {
                                ((Reader)inputStreamReader).close();
                            }
                            catch (IOException iOException2) {
                                iOException2.printStackTrace();
                            }
                            if (!bl2) {
                                file2.delete();
                            }
                        }
                        this.closeFile();
                    }
                }
                finally {
                    if (inputStreamReader != null) {
                        try {
                            ((Reader)inputStreamReader).close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        if (!bl2) {
                            file2.delete();
                        }
                    }
                    this.closeFile();
                }
            }
        }
    }

    private void copyReader(Reader reader, Writer writer) throws IOException {
        EclipseLog$$Cold.copyReader(this, reader, writer);
    }

    protected String getDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        StringBuffer stringBuffer = new StringBuffer();
        this.appendPaddedInt(calendar.get(1), 4, stringBuffer).append('-');
        this.appendPaddedInt(calendar.get(2) + 1, 2, stringBuffer).append('-');
        this.appendPaddedInt(calendar.get(5), 2, stringBuffer).append(' ');
        this.appendPaddedInt(calendar.get(11), 2, stringBuffer).append(':');
        this.appendPaddedInt(calendar.get(12), 2, stringBuffer).append(':');
        this.appendPaddedInt(calendar.get(13), 2, stringBuffer).append('.');
        this.appendPaddedInt(calendar.get(14), 3, stringBuffer);
        return stringBuffer.toString();
    }

    private StringBuffer appendPaddedInt(int n, int n2, StringBuffer stringBuffer) throws  {
        return EclipseLog$$Cold.appendPaddedInt(this, n, n2, stringBuffer);
    }

    protected String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        Throwable throwable2 = this.getRoot(throwable);
        if (throwable2 != null) {
            printWriter.println("Root exception:");
            throwable2.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }

    protected Writer logForStream(OutputStream outputStream) throws  {
        return EclipseLog$$Cold.logForStream(this, outputStream);
    }

    protected void writeLog(int n, FrameworkLogEntry frameworkLogEntry) throws IOException {
        EclipseLog$$Cold.writeLog(this, n, frameworkLogEntry);
    }

    protected void writeEntry(int n, FrameworkLogEntry frameworkLogEntry) throws IOException {
        EclipseLog$$Cold.writeEntry(this, n, frameworkLogEntry);
    }

    protected void writeMessage(FrameworkLogEntry frameworkLogEntry) throws IOException {
        EclipseLog$$Cold.writeMessage(this, frameworkLogEntry);
    }

    protected void writeStack(FrameworkLogEntry frameworkLogEntry) throws IOException {
        EclipseLog$$Cold.writeStack(this, frameworkLogEntry);
    }

    protected void write(String string) throws IOException {
        EclipseLog$$Cold.write(this, string);
    }

    protected boolean checkLogFileSize() {
        if (this.maxLogSize == 0) {
            return true;
        }
        boolean bl = true;
        if (this.outFile != null && this.outFile.length() >> 10 > (long)this.maxLogSize) {
            boolean bl2;
            String string = this.outFile.getAbsolutePath();
            String string2 = "";
            string2 = string.toLowerCase().endsWith(LOG_EXT) ? String.valueOf(string.substring(0, string.length() - LOG_EXT.length())) + BACKUP_MARK + this.backupIdx + LOG_EXT : String.valueOf(string) + BACKUP_MARK + this.backupIdx;
            File file = new File(string2);
            if (file.exists() && !file.delete()) {
                System.err.println("Error when trying to delete old log file: " + file.getName());
                if (file.renameTo(new File(String.valueOf(file.getAbsolutePath()) + System.currentTimeMillis()))) {
                    System.err.println("So we rename it to filename: " + file.getName());
                } else {
                    System.err.println("And we also cannot rename it!");
                    bl = false;
                }
            }
            if (!(bl2 = this.outFile.renameTo(file))) {
                System.err.println("Error when trying to rename log file to backup one.");
                bl = false;
            }
            File file2 = new File(string);
            this.setOutput(file2, null, false);
            this.openFile();
            try {
                this.writeSession();
                this.writeln();
                this.writeln("This is a continuation of log file " + file.getAbsolutePath());
                this.writeln("Created Time: " + this.getDate(new Date(System.currentTimeMillis())));
                this.writer.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
            this.closeFile();
            ++this.backupIdx;
            this.backupIdx %= this.maxLogFiles;
        }
        return bl;
    }
}

