/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class SCMAdvisableOperation
extends AdvisableOperation {
    public SCMAdvisableOperation(String operationId, Object operationData, IProcessArea processArea, IDevelopmentLine developmentLine) {
        super(operationId, operationData, processArea, developmentLine);
    }

    public static ProcessOperationData getOperationDataFor(IWorkspaceConnection remoteConnection, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessItemService processService = (IProcessItemService)remoteConnection.teamRepository().getClientLibrary(IProcessItemService.class);
        if (processService == null) {
            return null;
        }
        IProcessArea processArea = null;
        IAuditableHandle ownerHandle = remoteConnection.getResolvedWorkspace().getOwner();
        if (ownerHandle instanceof ITeamAreaHandle) {
            processArea = (IProcessArea)remoteConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)ownerHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
        if (processArea instanceof ITeamArea) {
            ITeamArea teamArea = (ITeamArea)processArea;
            IClientProcess process = processService.getClientProcess((IProcessArea)teamArea, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            IDevelopmentLine line = processService.getDevelopmentLine(teamArea, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            return new ProcessOperationData(teamArea, line, process, processArea);
        }
        return null;
    }

    public static class ProcessOperationData {
        private ITeamArea area;
        private IDevelopmentLine target;
        private final IClientProcess process;
        private final IProcessArea processArea;

        ProcessOperationData(ITeamArea area, IDevelopmentLine target, IClientProcess process, IProcessArea processArea) {
            this.area = area;
            this.target = target;
            this.process = process;
            this.processArea = processArea;
        }

        public ITeamArea getArea() {
            return this.area;
        }

        public IDevelopmentLine getDevelopmentLine() {
            return this.target;
        }

        public IClientProcess getProcess() {
            return this.process;
        }

        public IProcessArea getProcessArea() {
            return this.processArea;
        }
    }
}

