/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IManagedItem;
import com.ibm.team.repository.common.IManagedItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.ComponentEntry;
import com.ibm.team.scm.common.internal.Configuration;
import com.ibm.team.scm.common.internal.ConfigurationHandle;
import com.ibm.team.scm.common.internal.StateSelection;
import com.ibm.team.scm.common.internal.Versionable;
import com.ibm.team.scm.common.internal.query.BaseComponentEntryQueryModel;
import com.ibm.team.scm.common.providers.ItemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryItemProvider
implements ItemProvider {
    private final IItemManager itemManager;
    private final IVersionableManager versionableManager;
    private final IQueryService queryService;

    public RepositoryItemProvider(ITeamRepository repo) {
        this.itemManager = repo.itemManager();
        this.versionableManager = SCMPlatform.getWorkspaceManager(repo).versionableManager();
        this.queryService = (IQueryService)((IClientLibraryContext)repo).getServiceInterface(IQueryService.class);
    }

    public List<IManagedItem> fetchItems(List<? extends IManagedItemHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.itemManager.fetchCompleteItems(handles, 1, monitor);
    }

    public List<IAuditable> fetchStates(List<? extends IAuditableHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.itemManager.fetchCompleteStates(handles, monitor);
    }

    public Collection<StateSelection> fetchStateSelections(ConfigurationHandle configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Configuration config = (Configuration)this.itemManager.fetchCompleteItem((IItemHandle)configuration, 1, (IProgressMonitor)progress.newChild(20));
        Configuration baseConfig = null;
        if (!config.getOverridesConfiguration().sameItemId((IItemHandle)config)) {
            List cfgs = this.itemManager.fetchCompleteItems(Arrays.asList(config.getOverridesConfiguration(), config.getBaseConfiguration()), 1, (IProgressMonitor)progress.newChild(80));
            config = (Configuration)cfgs.get(0);
            baseConfig = (Configuration)cfgs.get(1);
        } else if (config.getBaseConfiguration() != null) {
            baseConfig = (Configuration)this.itemManager.fetchCompleteItem((IItemHandle)config.getBaseConfiguration(), 1, (IProgressMonitor)progress.newChild(80));
        }
        if (baseConfig == null) {
            progress.done();
            return config.getSelections();
        }
        if (config.getSelections().isEmpty()) {
            progress.done();
            return baseConfig.getSelections();
        }
        HashMap<UUID, StateSelection> selections = new HashMap<UUID, StateSelection>((int)(config.getNumSelectionsInBase() * 2L));
        for (StateSelection sel : baseConfig.getSelections()) {
            if (sel.getState() == null) continue;
            selections.put(sel.getItem().getItemId(), sel);
        }
        for (StateSelection sel : config.getSelections()) {
            if (sel.getState() != null) {
                selections.put(sel.getItem().getItemId(), sel);
                continue;
            }
            selections.remove(sel.getItem().getItemId());
        }
        progress.done();
        return selections.values();
    }

    public List<ItemProvider.VRecord> fetchVersionables(List<? extends IVersionableHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        List versionables = this.versionableManager.fetchCompleteStates(handles, monitor);
        ArrayList<ItemProvider.VRecord> result = new ArrayList<ItemProvider.VRecord>(versionables.size());
        for (Versionable v : versionables) {
            result.add(new ItemProvider.VRecord(v.getParentId(), v.getStateId(), v.getName()));
        }
        return result;
    }

    public String getRepositoryURI() {
        return this.itemManager.teamRepository().getRepositoryURI();
    }

    public IManagedItem fetchItem(IManagedItemHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IManagedItem)this.itemManager.fetchCompleteItem((IItemHandle)handle, 1, monitor);
    }

    public Collection<ComponentEntry> fetchComponentEntriesFor(IWorkspaceHandle workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        BaseComponentEntryQueryModel.ComponentEntryQueryModel ce = BaseComponentEntryQueryModel.ComponentEntryQueryModel.ROOT;
        IItemQuery q = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)ce);
        q.filter(ce.workspace()._eq(q.newItemHandleArg()));
        IItemQueryPage page = this.queryService.queryItems(q, new Object[]{workspace}, 512);
        progress.worked(50);
        ArrayList handles = new ArrayList(page.getResultSize());
        SubMonitor subProgress = progress.newChild(30);
        subProgress.setWorkRemaining(page.getResultSize() - page.getSize());
        while (true) {
            handles.addAll(page.getItemHandles());
            if (!page.hasNext()) break;
            page = (IItemQueryPage)this.queryService.fetchPage(page.getToken(), page.getNextStartPosition(), 512);
            subProgress.worked(page.getSize());
        }
        subProgress.done();
        List<IManagedItem> entries = this.fetchItems(handles, (IProgressMonitor)progress.newChild(20));
        progress.done();
        return entries;
    }

    public int maxItemsPerRequest() {
        return Integer.MAX_VALUE;
    }

    public int maxStatesPerRequest() {
        return Integer.MAX_VALUE;
    }

    public int maxVersionablesPerRequest() {
        return Integer.MAX_VALUE;
    }
}

