/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.dto.WorkspaceRefreshResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSetClientCache {
    private Map<IComponentHandle, IChangeSetHandle> currentChangeSets = new TreeMap<IComponentHandle, IChangeSetHandle>(ItemUtil.itemIdComparator);
    protected ChangeSetTracker activeTracker = new ChangeSetTracker();
    protected ChangeSetTracker suspendTracker = new ChangeSetTracker();
    public static final IChangeSetHandle CURRENT_UNSET = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.generate(), null);

    public void updateCaches(WorkspaceRefreshResult refreshedData, Map<IComponentHandle, IChangeSetHandle> newCurrents, Set<UUID> staleComponents) {
        this.activeTracker.removeChangeSets(refreshedData.getActiveRemoved(), staleComponents);
        this.suspendTracker.removeChangeSets(refreshedData.getSuspendedRemoved(), Collections.EMPTY_SET);
        for (IChangeSet changeSet : refreshedData.getActiveChangeSets()) {
            if (staleComponents.contains(changeSet.getComponent().getItemId())) continue;
            this.activeTracker.addChangeSet(changeSet.getComponent(), (IChangeSetHandle)changeSet.getStateHandle());
        }
        for (IChangeSet changeSet : refreshedData.getSuspendedChangeSets()) {
            this.suspendTracker.addChangeSet(changeSet.getComponent(), (IChangeSetHandle)changeSet.getStateHandle());
        }
        this.updateCurrents(newCurrents);
    }

    private void updateCurrents(Map<IComponentHandle, IChangeSetHandle> newCurrents) {
        for (Map.Entry<IComponentHandle, IChangeSetHandle> entry : newCurrents.entrySet()) {
            IComponentHandle key = entry.getKey();
            if (entry.getValue() == CURRENT_UNSET) {
                this.currentChangeSets.remove(key);
                continue;
            }
            this.currentChangeSets.put(key, (IChangeSetHandle)EcoreUtil.copy((EObject)((EObject)entry.getValue())));
        }
    }

    public List<IChangeSetHandle> getSuspendedChangeSets() {
        return this.suspendTracker.getChangeSets();
    }

    public List<IChangeSetHandle> getSuspendedChangeSetsByComponent(IComponentHandle component) {
        return this.suspendTracker.getByComponent(component);
    }

    public IComponentHandle getComponent(IChangeSetHandle cs) {
        for (Map.Entry<IComponentHandle, IChangeSetHandle> entry : this.currentChangeSets.entrySet()) {
            if (!entry.getValue().sameItemId((IItemHandle)cs)) continue;
            return entry.getKey();
        }
        for (Map.Entry<Object, Object> entry : this.activeTracker.getMap().entrySet()) {
            for (IChangeSetHandle csh : ((Map)entry.getValue()).values()) {
                if (!csh.sameItemId((IItemHandle)cs)) continue;
                return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((UUID)entry.getKey(), null);
            }
        }
        for (Map.Entry<Object, Object> entry : this.suspendTracker.getMap().entrySet()) {
            for (IChangeSetHandle csh : ((Map)entry.getValue()).values()) {
                if (!csh.sameItemId((IItemHandle)cs)) continue;
                return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((UUID)entry.getKey(), null);
            }
        }
        return null;
    }

    public List<IChangeSetHandle> getActiveChangeSets() {
        return this.activeTracker.getChangeSets();
    }

    public List<IChangeSetHandle> getActiveChangeSetsByComponent(IComponentHandle component) {
        return this.activeTracker.getByComponent(component);
    }

    public void addActiveChangeSet(IComponentHandle component, IChangeSetHandle changeSet) {
        this.activeTracker.addChangeSet(component, changeSet);
    }

    public IChangeSetHandle getCurrentChangeSet(IComponentHandle component) {
        return this.currentChangeSets.get(component);
    }

    public Map<IComponentHandle, IChangeSetHandle> getCurrentChangeSets() {
        return this.currentChangeSets;
    }

    public void setCurrentChangeSet(IComponentHandle component, IChangeSetHandle changeSet) {
        this.currentChangeSets.put(component, changeSet);
    }

    public void unsetCurrentChangeSet(IComponentHandle component) {
        this.currentChangeSets.put(component, null);
    }

    public IComponentHandle removeCurrent(IChangeSetHandle changeSet) {
        for (Map.Entry<IComponentHandle, IChangeSetHandle> entry : this.currentChangeSets.entrySet()) {
            if (!changeSet.sameItemId((IItemHandle)entry.getValue())) continue;
            entry.setValue(null);
            return entry.getKey();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ChangeSetTracker {
        private Map<UUID, IChangeSetHandle> changeSets = new LinkedHashMap<UUID, IChangeSetHandle>();
        private Map<UUID, Map<UUID, IChangeSetHandle>> byComponents = new HashMap<UUID, Map<UUID, IChangeSetHandle>>();

        protected ChangeSetTracker() {
        }

        public List<IChangeSetHandle> getChangeSets() {
            return Collections.unmodifiableList(new ArrayList<IChangeSetHandle>(this.changeSets.values()));
        }

        public Map<UUID, Map<UUID, IChangeSetHandle>> getMap() {
            return this.byComponents;
        }

        public List<IChangeSetHandle> getByComponent(IComponentHandle component) {
            Map<UUID, IChangeSetHandle> subMap = this.byComponents.get(component.getItemId());
            if (subMap == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.unmodifiableList(new ArrayList<IChangeSetHandle>(subMap.values()));
        }

        public void addChangeSet(IComponentHandle component, IChangeSetHandle changeSet) {
            UUID csItemId = changeSet.getItemId();
            this.changeSets.put(csItemId, changeSet);
            UUID compItemId = component.getItemId();
            Map<UUID, IChangeSetHandle> subMap = this.byComponents.get(compItemId);
            if (subMap == null) {
                subMap = new LinkedHashMap<UUID, IChangeSetHandle>();
                this.byComponents.put(compItemId, subMap);
            }
            subMap.put(csItemId, changeSet);
        }

        public void removeChangeSets(List<IChangeSetHandle> changeSets, Set<UUID> staleComponents) {
            HashSet staleIds = new HashSet((int)((double)this.changeSets.size() * 0.75));
            for (UUID compId : staleComponents) {
                Map<UUID, IChangeSetHandle> byComponent = this.byComponents.get(compId);
                if (byComponent == null) continue;
                staleIds.addAll(byComponent.keySet());
            }
            for (IChangeSetHandle cs : changeSets) {
                if (staleIds.contains(cs)) continue;
                this.removeChangeSet(cs);
            }
        }

        public void removeChangeSet(IChangeSetHandle changeSet) {
            UUID csItemId = changeSet.getItemId();
            this.changeSets.remove(csItemId);
            for (Map<UUID, IChangeSetHandle> subMap : this.byComponents.values()) {
                if (!subMap.containsKey(csItemId)) continue;
                subMap.remove(csItemId);
                break;
            }
        }

        protected IChangeSetHandle createStateHandle(IChangeSet cs) {
            return (IChangeSetHandle)cs.getItemType().createItemHandle(cs.getItemId(), cs.getStateId());
        }
    }
}

