/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.task;

import com.ibm.team.build.ant.task.AbstractPublisherTask;
import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.operations.ConnectorOps;
import com.ibm.team.connector.scm.task.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.util.List;

public class ConnectorTasks
extends AbstractPublisherTask {
    public static final String ACTION = "action";
    public static final String SYNC_STREAM_LOCATION_STRING = "syncStreamLocationString";
    private String _action;
    private String _syncStreamLocationString;

    protected void collectAntAttributes(List antAttributes) {
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(ACTION, this._action, true){

            public void validate() throws AbstractTeamBuildTask.IllegalAntAttributeException {
                super.validate();
                try {
                    RequestKind.valueOf(this.getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.handleIllegalAttributeValue(this.getName(), this.getValue());
                }
            }
        });
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(SYNC_STREAM_LOCATION_STRING, this._syncStreamLocationString, this.getAction().equals(RequestKind.SYNCHRONIZE.name())));
    }

    protected void updateBuildResult() throws Exception {
        String request = this.getAction();
        this.log(NLS.bind((String)Messages.ConnectorTasks_ACTION, (Object[])new Object[]{request}));
        RequestKind action = RequestKind.valueOf(request);
        JzProvider jazzProvider = null;
        try {
            jazzProvider = ConnectorOps.createJazzProvider((String)this.getRepositoryAddress(), (String)this.getUserId(), (String)this.getProvidedPassword());
            switch (action) {
                case SYNCHRONIZE: {
                    String syncStreamLocationString = this.getSyncStreamLocationString();
                    this.log(NLS.bind((String)Messages.ConnectorTasks_SYNC_STREAM_LOC_STRING, (Object[])new Object[]{syncStreamLocationString}));
                    ConnectorOps.synchronizeStream((JzProvider)jazzProvider, (String)syncStreamLocationString, (String)this.getBuildResultUUID());
                    break;
                }
                case LIST_CLONE_LINKS: {
                    ConnectorOps.listOrUnlinkClones((JzProvider)jazzProvider, (boolean)false, (boolean)this.isVerbose());
                    break;
                }
                case REMOVE_CLONE_LINKS: {
                    ConnectorOps.listOrUnlinkClones((JzProvider)jazzProvider, (boolean)true, (boolean)this.isVerbose());
                }
            }
        }
        catch (Throwable throwable) {
            ConnectorOps.logout(jazzProvider);
            throw throwable;
        }
        ConnectorOps.logout((JzProvider)jazzProvider);
    }

    public String getAction() {
        return this._action;
    }

    public void setAction(String action) {
        this._action = action;
    }

    public String getSyncStreamLocationString() {
        return this._syncStreamLocationString;
    }

    public void setSyncStreamLocationString(String streamLocationString) {
        this._syncStreamLocationString = streamLocationString;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RequestKind {
        SYNCHRONIZE,
        LIST_CLONE_LINKS,
        REMOVE_CLONE_LINKS;

    }
}

