/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.workitems.internal;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkflowUtilities;
import com.ibm.team.workitem.common.model.IApproval;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IApprovals;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemUtils {
    private static IWorkItemWorkingCopyManager getWorkItemWorkingCopyManager(ITeamRepository repo) {
        return ((IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class)).getWorkItemWorkingCopyManager();
    }

    public static IWorkItem createReviewTask(ITeamRepository repo, IWorkItem workItem, String approvalType, String approvalTypeLabel, List<IContributorHandle> verifiers, boolean addReview, String comment, boolean save, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemWorkingCopyManager manager = WorkItemUtils.getWorkItemWorkingCopyManager(repo);
        WorkItemWorkingCopy copy = null;
        if (save) {
            manager.connect((IWorkItemHandle)workItem, IWorkItem.FULL_PROFILE, null);
            copy = manager.getWorkingCopy((IWorkItemHandle)workItem);
            workItem = copy.getWorkItem();
        } else {
            workItem = (IWorkItem)workItem.getWorkingCopy();
        }
        try {
            if (verifiers.size() > 0 || addReview) {
                IApprovals approvals = workItem.getApprovals();
                IApprovalDescriptor descriptor = approvals.createDescriptor(approvalType, approvalTypeLabel);
                for (IContributorHandle reviewer : verifiers) {
                    IApproval approval = approvals.createApproval(descriptor, reviewer);
                    approvals.add(approval);
                    workItem.getSubscriptions().add(reviewer);
                }
                if (verifiers.isEmpty()) {
                    approvals.add(descriptor);
                }
            }
            if (comment != null && comment.length() > 0) {
                IComment wiComment = workItem.getComments().createComment((IContributorHandle)repo.loggedInContributor(), XMLString.createFromPlainText((String)comment));
                workItem.getComments().append(wiComment);
            }
            if (save) {
                copy.save((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            IWorkItem iWorkItem = workItem;
            return iWorkItem;
        }
        finally {
            if (save) {
                manager.disconnect((IWorkItemHandle)workItem);
            }
        }
    }

    public static void closeWorkItems(ITeamRepository repo, Collection<IWorkItem> workItems, String comment, boolean shouldResolve) throws TeamRepositoryException {
        IWorkItemWorkingCopyManager manager = WorkItemUtils.getWorkItemWorkingCopyManager(repo);
        for (IWorkItem workItem : workItems) {
            try {
                Identifier resolveActionId;
                IWorkflowInfo workflowInfo;
                boolean shouldSave;
                manager.connect((IWorkItemHandle)workItem, IWorkItem.FULL_PROFILE, null);
                WorkItemWorkingCopy copy = manager.getWorkingCopy((IWorkItemHandle)workItem);
                boolean bl = shouldSave = !copy.isDirty();
                if (comment != null && comment.length() > 0) {
                    IComment wiComment = copy.getWorkItem().getComments().createComment((IContributorHandle)repo.loggedInContributor(), XMLString.createFromPlainText((String)comment));
                    copy.getWorkItem().getComments().append(wiComment);
                }
                if (shouldResolve && (workflowInfo = WorkflowUtilities.findWorkflowInfo((IWorkItem)copy.getWorkItem(), null)) != null && workflowInfo.getStateGroup(copy.getWorkItem().getState2()) != 2 && (resolveActionId = workflowInfo.getResolveActionId()) != null) {
                    copy.setWorkflowAction(resolveActionId.getStringIdentifier());
                }
                if (!shouldSave) continue;
                copy.save(null);
            }
            finally {
                manager.disconnect((IWorkItemHandle)workItem);
            }
        }
    }

    public static void fillInDefaults(IWorkItemHandle createdWorkItem, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo = (ITeamRepository)createdWorkItem.getOrigin();
        IWorkItemClient service = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
        IWorkItem workItem = null;
        try {
            List iterations;
            service.getWorkItemWorkingCopyManager().connect(createdWorkItem, IWorkItem.FULL_PROFILE, null);
            WorkItemWorkingCopy wc = service.getWorkItemWorkingCopyManager().getWorkingCopy(createdWorkItem);
            workItem = wc.getWorkItem();
            workItem.setCreator((IContributorHandle)repo.loggedInContributor());
            workItem.setOwner((IContributorHandle)repo.loggedInContributor());
            IProjectAreaHandle projectArea = workItem.getProjectArea();
            IDevelopmentLine developmentLine = service.getAuditableCommon().findDefaultDevelopmentLine(projectArea, null);
            if (developmentLine != null && (iterations = service.getAuditableCommon().findCurrentIterations((IDevelopmentLineHandle)developmentLine, null)).size() > 1) {
                workItem.setTarget((IIterationHandle)iterations.get(1));
            }
            wc.save((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (Throwable throwable) {
            if (workItem != null) {
                service.getWorkItemWorkingCopyManager().disconnect(workItem);
            }
            throw throwable;
        }
        if (workItem != null) {
            service.getWorkItemWorkingCopyManager().disconnect((IWorkItemHandle)workItem);
        }
    }
}

