/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.workitems.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.filesystem.client.workitems.internal.WorkItemUtils;
import com.ibm.team.filesystem.common.workitems.internal.IFilesystemWorkItemService;
import com.ibm.team.filesystem.common.workitems.internal.dto.DeliverAndResolveDTO;
import com.ibm.team.filesystem.common.workitems.internal.dto.FilesystemWorkItemsDTOFactory;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.ILink;
import com.ibm.team.process.common.advice.IObjectsResponse;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.ScmClientLibraryContext;
import com.ibm.team.scm.client.internal.isv.IWorkspaceDeliverRunnable;
import com.ibm.team.scm.client.internal.isv.IWorkspaceOperationRunner;
import com.ibm.team.scm.client.internal.process.ClientAdvisableOperation;
import com.ibm.team.scm.client.internal.process.ProcessUtils;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.process.DeliverOperationData;
import com.ibm.team.scm.common.process.ProcessProxy;
import com.ibm.team.scm.common.process.RepositoryRunnable;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemWorkItemManager
implements IFileSystemWorkItemManager {
    private final IFilesystemWorkItemService service;
    private IClientLibraryContext wrappedContext;
    private final ITeamRepository repo;
    private ILinkManager linkManager;

    public FileSystemWorkItemManager(IClientLibraryContext context) {
        this.wrappedContext = new ScmClientLibraryContext(context);
        this.repo = this.wrappedContext.teamRepository();
        this.service = (IFilesystemWorkItemService)this.wrappedContext.getServiceInterface(IFilesystemWorkItemService.class);
        this.linkManager = (ILinkManager)this.repo.getClientLibrary(ILinkManager.class);
    }

    @Override
    public IOperationReport deliverAndResolve(final IChangeHistorySyncReport syncReport, IWorkspaceHandle source, IWorkspaceHandle target, final List<IChangeSetHandle> changeSets, final List<IWorkItem> workItems, boolean shouldResolve, final String comment, final boolean addReview, final String subject, final List<IContributorHandle> reviewers, final IDeliverOperation deliverOperation, IProgressMonitor monitor) throws TeamRepositoryException {
        final DeliverAndResolveDTO data = FilesystemWorkItemsDTOFactory.eINSTANCE.createDeliverAndResolveDTO();
        data.setShouldResolveWorkItem(shouldResolve);
        if (changeSets == null || changeSets.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (workItems == null || workItems.isEmpty()) {
            throw new IllegalArgumentException();
        }
        final IWorkItem[] workItemHandles = workItems.toArray(new IWorkItem[0]);
        final IWorkspaceConnection targetWorkspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)this.wrappedContext.teamRepository()).getWorkspaceConnection(target, monitor);
        final IWorkspaceConnection sourceWorkspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)this.wrappedContext.teamRepository()).getWorkspaceConnection(source, monitor);
        DeliverOperationData deliverData = new DeliverOperationData((ProcessProxy)new ProcessUtils.ClientProcessProxy(this.repo), sourceWorkspaceConnection.getResolvedWorkspace(), targetWorkspaceConnection.getResolvedWorkspace(), Collections.EMPTY_LIST, changeSets);
        ClientAdvisableOperation operation = new ClientAdvisableOperation(this.repo, "com.ibm.team.scm.client.deliver", (Object)deliverData, (IItem)targetWorkspaceConnection.getResolvedWorkspace());
        operation.setIgnoredExceptions(false);
        operation.setBlock(new RepositoryRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                FileSystemWorkItemManager.this.preDeliverConditions(deliverOperation, monitor);
                final ArrayList<IWorkItem> workingCopies = new ArrayList<IWorkItem>(workItems.size());
                List updatedWorkItems = FileSystemWorkItemManager.this.repo.itemManager().fetchCompleteItems(workItems, 0, monitor);
                ArrayList<IWorkItem> refreshedWorkItems = new ArrayList<IWorkItem>(workItems.size());
                int i = 0;
                while (i < updatedWorkItems.size()) {
                    IWorkItem workItem = (IWorkItem)updatedWorkItems.get(i);
                    if (workItem == null) {
                        refreshedWorkItems.add((IWorkItem)workItems.get(i));
                    } else {
                        refreshedWorkItems.add(workItem);
                    }
                    ++i;
                }
                for (IWorkItem workItem : refreshedWorkItems) {
                    workingCopies.add(WorkItemUtils.createReviewTask(FileSystemWorkItemManager.this.repo, workItem, WorkItemApprovals.VERIFICATION_TYPE.getIdentifier(), subject, reviewers, addReview, comment, false, monitor));
                }
                IOperationReport report = ((IWorkspaceOperationRunner)sourceWorkspaceConnection).runDeliver(new IWorkspaceDeliverRunnable(){

                    public IObjectsResponse deliver(IWorkspaceHandle workspaceHandle, IWorkspaceHandle targetWorkspaceHandle, IBaselineHandle[] baseline, IChangeSetHandle[] outgoingChangeSets, IRepositoryProgressMonitor monitor) throws TeamRepositoryException {
                        return FileSystemWorkItemManager.this.service.deliverAndResolve(workspaceHandle, targetWorkspaceHandle, outgoingChangeSets, workingCopies.toArray(new IWorkItem[0]), data, monitor);
                    }
                }, targetWorkspaceConnection, syncReport, Collections.EMPTY_LIST, changeSets, monitor);
                IWorkItemWorkingCopyManager wcManager = ((IWorkItemClient)FileSystemWorkItemManager.this.repo.getClientLibrary(IWorkItemClient.class)).getWorkItemWorkingCopyManager();
                IWorkItem[] iWorkItemArray = workItemHandles;
                int n = workItemHandles.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkItem workItem = iWorkItemArray[n2];
                    try {
                        wcManager.connect((IWorkItemHandle)workItem, IWorkItem.FULL_PROFILE, monitor);
                        wcManager.refreshWithCurrent((IWorkItemHandle)workItem, monitor);
                    }
                    finally {
                        wcManager.disconnect((IWorkItemHandle)workItem);
                    }
                    ++n2;
                }
                return report;
            }
        });
        return operation.processExec(monitor);
    }

    private void preDeliverConditions(IDeliverOperation deliverOperation, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            if (deliverOperation != null) {
                deliverOperation.runPreConditionsOnly(monitor);
            }
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    @Override
    public List<ILink> createLink(IWorkspace workspace, IChangeSetHandle changeSet, IWorkItemHandle[] workItems, IProgressMonitor monitor) throws TeamRepositoryException {
        if (changeSet == null) {
            throw new IllegalArgumentException();
        }
        if (workItems == null || workItems.length == 0) {
            throw new IllegalArgumentException();
        }
        monitor = monitor == null ? new NullProgressMonitor() : monitor;
        try {
            monitor.worked(5);
            ILink[] linkItems = this.service.createLink(workspace, changeSet, workItems, IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor));
            ArrayList<ILink> links = new ArrayList<ILink>(linkItems.length);
            links.addAll((Collection)Arrays.asList(linkItems));
            monitor.worked(75);
            this.repo.itemManager().applyItemUpdates(links);
            this.linkManager.applySavedLinks(links);
            ArrayList<ILink> arrayList = links;
            return arrayList;
        }
        catch (StaleDataException sde) {
            throw sde;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void deleteLinks(List<ILink> links, IProgressMonitor monitor) throws TeamRepositoryException {
        if (links == null || links.size() == 0) {
            throw new IllegalArgumentException();
        }
        monitor = monitor == null ? new NullProgressMonitor() : monitor;
        try {
            monitor.worked(5);
            this.service.deleteLinks(links.toArray(new ILink[0]), IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor));
            monitor.worked(75);
            this.linkManager.applyDeletedLinks(links);
        }
        finally {
            monitor.done();
        }
    }
}

