/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.json.internal;

import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.json.internal.Token;
import com.ibm.team.repository.common.json.internal.Tokenizer;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;

public class Parser {
    private final Tokenizer tokenizer;
    private Token lastToken;

    public Parser(Reader reader) throws IOException {
        this.tokenizer = new Tokenizer(reader);
    }

    public Object parse() throws IOException {
        this.lastToken = this.tokenizer.next();
        return this.parseValue();
    }

    public JSONObject parseObject() throws IOException {
        JSONObject result;
        block6: {
            result = new JSONObject();
            if (this.lastToken != Token.TokenBraceL) {
                throw new IOException(MessageFormat.format("Expecting \"{\" at line/column: {0}", this.tokenizer.onLineCol()));
            }
            this.lastToken = this.tokenizer.next();
            while (true) {
                if (this.lastToken == Token.TokenEOF) {
                    throw new IOException(MessageFormat.format("Unterminated object at line/column: {0}", this.tokenizer.onLineCol()));
                }
                if (this.lastToken == Token.TokenBraceR) break block6;
                if (!this.lastToken.isString()) {
                    throw new IOException(MessageFormat.format("Expecting string key at line/column: {0}", this.tokenizer.onLineCol()));
                }
                String key = this.lastToken.getString();
                this.lastToken = this.tokenizer.next();
                if (this.lastToken != Token.TokenColon) {
                    throw new IOException(MessageFormat.format("Expecting \":\" at line/column: {0}", this.tokenizer.onLineCol()));
                }
                this.lastToken = this.tokenizer.next();
                Object val = this.parseValue();
                result.put(key, val);
                if (this.lastToken == Token.TokenComma) {
                    this.lastToken = this.tokenizer.next();
                    continue;
                }
                if (this.lastToken != Token.TokenBraceR) break;
            }
            throw new IOException(MessageFormat.format("Expecting either \",\" or \"}\" at line/column: {0}", this.tokenizer.onLineCol()));
        }
        this.lastToken = this.tokenizer.next();
        return result;
    }

    public JSONArray parseArray() throws IOException {
        JSONArray result;
        block4: {
            result = new JSONArray();
            if (this.lastToken != Token.TokenBrackL) {
                throw new IOException(MessageFormat.format("Expecting \"{\" at line/column: {0}", this.tokenizer.onLineCol()));
            }
            this.lastToken = this.tokenizer.next();
            while (true) {
                if (this.lastToken == Token.TokenEOF) {
                    throw new IOException(MessageFormat.format("Unterminated array at line/column: {0}", this.tokenizer.onLineCol()));
                }
                if (this.lastToken == Token.TokenBrackR) break block4;
                Object val = this.parseValue();
                result.add(val);
                if (this.lastToken == Token.TokenComma) {
                    this.lastToken = this.tokenizer.next();
                    continue;
                }
                if (this.lastToken != Token.TokenBrackR) break;
            }
            throw new IOException(MessageFormat.format("Expecting either \",\" or \"}\" at line/column: {0}", this.tokenizer.onLineCol()));
        }
        this.lastToken = this.tokenizer.next();
        return result;
    }

    public Object parseValue() throws IOException {
        if (this.lastToken == Token.TokenEOF) {
            throw new IOException(MessageFormat.format("Expecting property value at line/column: {0}", this.tokenizer.onLineCol()));
        }
        if (this.lastToken.isNumber()) {
            Number result = this.lastToken.getNumber();
            this.lastToken = this.tokenizer.next();
            return result;
        }
        if (this.lastToken.isString()) {
            String result = this.lastToken.getString();
            this.lastToken = this.tokenizer.next();
            return result;
        }
        if (this.lastToken == Token.TokenFalse) {
            this.lastToken = this.tokenizer.next();
            return Boolean.FALSE;
        }
        if (this.lastToken == Token.TokenTrue) {
            this.lastToken = this.tokenizer.next();
            return Boolean.TRUE;
        }
        if (this.lastToken == Token.TokenNull) {
            this.lastToken = this.tokenizer.next();
            return null;
        }
        if (this.lastToken == Token.TokenBrackL) {
            return this.parseArray();
        }
        if (this.lastToken == Token.TokenBraceL) {
            return this.parseObject();
        }
        throw new IOException(MessageFormat.format("Invalid token at line/column: {0}", this.tokenizer.onLineCol()));
    }
}

