/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.util.DialogUtil;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnOutOfSync;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import java.util.Collection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarnResolveAsMergedUser
extends MarkAsMergedDilemmaHandler {
    private boolean confirmCheckin;
    private boolean allowUnmerged = true;
    private WarnOutOfSync warnOutOfSync;
    private final Shell shell;

    public WarnResolveAsMergedUser(Shell shell, String title) {
        this.shell = shell;
        this.warnOutOfSync = new WarnOutOfSync(shell, title);
    }

    public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
        return this.warnOutOfSync.outOfSync(sharesOutOfSync);
    }

    public boolean willIgnoreAllSharesOutOfSync() {
        return this.warnOutOfSync.willIgnoreAllSharesOutOfSync();
    }

    public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
        return this.warnOutOfSync.collision(collisions, removedShares, sharesOutOfSync);
    }

    public int uncheckedInChanges(Collection<ILocalChange> changes) {
        if (this.confirmCheckin) {
            final int[] result = new int[]{1};
            if (PlatformUI.isWorkbenchRunning()) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.syncExec(new Runnable(){

                    public void run() {
                        MessageBox dialog = new MessageBox(WarnResolveAsMergedUser.this.shell, 65825);
                        dialog.setText(Messages.WarnResolveAsMergedUser_0);
                        dialog.setMessage(Messages.WarnResolveAsMergedUser_1);
                        if (dialog.open() == 32) {
                            result[0] = 0;
                        }
                    }
                });
            }
            return result[0];
        }
        return 0;
    }

    public int unmergedChanges(Collection<ILogicalChange> changes) {
        if (this.allowUnmerged) {
            return 0;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            String message = Messages.WarnResolveAsMergedUser_2;
            JFaceUtils.showMessageBlocking((String)Messages.WarnResolveAsMergedUser_3, (String)message, (int)4);
        }
        return 1;
    }

    public int missingRequiredChanges(final Collection<ILogicalChange> requiredChanges) {
        final int[] result = new int[]{1};
        if (PlatformUI.isWorkbenchRunning()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    ListDialog dialog = DialogUtil.createConflictDialog(WarnResolveAsMergedUser.this.shell, requiredChanges, Messages.WarnResolveAsMergedUser_4, Messages.WarnResolveAsMergedUser_5);
                    if (dialog.open() == 0) {
                        result[0] = 0;
                    }
                }
            });
        }
        return result[0];
    }

    public Shell getShell() {
        return this.shell;
    }

    public boolean isConfirmCheckin() {
        return this.confirmCheckin;
    }

    public void setConfirmCheckin(boolean confirmCheckin) {
        this.confirmCheckin = confirmCheckin;
    }

    public boolean isAllowUnmerged() {
        return this.allowUnmerged;
    }

    public void setAllowUnmerged(boolean allowUnmerged) {
        this.allowUnmerged = allowUnmerged;
    }
}

