/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileContentInputStreamProvider;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.rcp.core.IEclipseFileSystemManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.operations.EclipseWorkspaceMarkAsMergedOperation;
import com.ibm.team.filesystem.rcp.core.operations.AutoResolveConflictsDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.operations.IAutoResolveConflictsOperation;
import com.ibm.team.filesystem.rcp.core.operations.IFailedAutoResolveRequest;
import com.ibm.team.filesystem.rcp.ui.internal.ImagePool;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.compare.CompareFilePropertiesState;
import com.ibm.team.filesystem.rcp.ui.internal.compare.CompareFilePropertiesViewerPane;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FireChangesDiffNode;
import com.ibm.team.filesystem.rcp.ui.internal.compare.SimpleTypedElement;
import com.ibm.team.filesystem.rcp.ui.internal.util.StandardAutoResolveDilemmaHandler;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnResolveAsMergedUser;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class SimpleConflictCompareEditorInput
extends CompareEditorInput
implements IResourceChangeListener {
    private Shell shell;
    private IConflictItem conflict;
    private BufferedResourceNode left;
    private Image conflictsImage;
    private IFile localFile;
    private Button autoMergeButton;
    private Button resolveButton;
    private boolean saving = false;
    private boolean isEvilTwin = false;
    private IWorkbenchPage page;
    private boolean fileStreamChanges;
    private CompareFilePropertiesState fileProperties;
    private CompareFilePropertiesViewerPane pane;
    private boolean runningAutoResolve;
    private List<DisposableInputStreamProvider> disposableBuffers = new ArrayList<DisposableInputStreamProvider>(2);
    private static final byte[] UTF_8_BOM = new byte[]{-17, -69, -65};
    private static final byte[] UTF_16_BE_BOM = new byte[]{-2, -1};
    private static final byte[] UTF_16_LE_BOM = new byte[]{-1, -2};

    public SimpleConflictCompareEditorInput(IConflictItem conflict) {
        super(new CompareConfiguration());
        this.conflict = conflict;
    }

    private IWorkbenchPage getPage() {
        if (this.page == null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        }
        return this.page;
    }

    public IConflictItem getConflictedItem() {
        return this.conflict;
    }

    public String getTitle() {
        return this.conflict.getResourceName(false);
    }

    public Control createContents(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(top);
        Composite banner = new Composite(top, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)banner);
        this.shell = top.getShell();
        CLabel label = new CLabel(banner, 0);
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
        imageDescriptorArray[1] = ImagePool.UNRESOLVED_OVRL;
        this.conflictsImage = new OverlayIcon(ImagePool.WORKSPACE, imageDescriptorArray, 132096).createImage(true);
        label.setImage(this.conflictsImage);
        Link actions = new Link(banner, 0);
        actions.setText(Messages.SimpleConflictCompareEditorInput_0);
        GridDataFactory.defaultsFor((Control)actions).grab(true, false).applyTo((Control)actions);
        this.autoMergeButton = new Button(banner, 8);
        this.autoMergeButton.setText(Messages.SimpleConflictCompareEditorInput_1);
        this.autoMergeButton.setToolTipText(Messages.SimpleConflictCompareEditorInput_2);
        this.autoMergeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SimpleConflictCompareEditorInput.this.isDirty()) {
                    boolean result = MessageDialogFactory.confirm((Shell)SimpleConflictCompareEditorInput.this.shell, (String)Messages.SimpleConflictCompareEditorInput_3, (String)Messages.SimpleConflictCompareEditorInput_4);
                    if (!result) {
                        return;
                    }
                    try {
                        SimpleConflictCompareEditorInput.this.saveChanges(null);
                    }
                    catch (CoreException e1) {
                        IStatus status = StatusUtil.newStatus((Object)((Object)this), (Throwable)e1);
                        MessageDialogFactory.showMessage((Shell)SimpleConflictCompareEditorInput.this.shell, (IStatus)status);
                        StatusUtil.log((IStatus)status);
                        return;
                    }
                }
                final UIContext currentContext = UIContext.createPageContext((Shell)SimpleConflictCompareEditorInput.this.shell, (IWorkbenchPage)SimpleConflictCompareEditorInput.this.getPage());
                currentContext.getUserOperationRunner().enqueue(Messages.SimpleConflictCompareEditorInput_5, (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                        try {
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                            StandardAutoResolveDilemmaHandler dilemmaHandler = new StandardAutoResolveDilemmaHandler(currentContext, false){

                                @Override
                                public int missingStorageMerger(Collection<IFailedAutoResolveRequest> unknownTypes, Collection<IFailedAutoResolveRequest> itemsWithNoHandlers) {
                                    for (IFailedAutoResolveRequest request : unknownTypes) {
                                        request.setRetryMerge(true);
                                        request.defaultContentTypeMerger("org.eclipse.core.runtime.text");
                                    }
                                    for (IFailedAutoResolveRequest request : itemsWithNoHandlers) {
                                        request.setRetryMerge(true);
                                        request.defaultContentTypeMerger("org.eclipse.core.runtime.text");
                                    }
                                    return 0;
                                }
                            };
                            IAutoResolveConflictsOperation autoResolveOperation = IEclipseFileSystemManager.instance.getAutoResolveConflictsOperation((AutoResolveConflictsDilemmaHandler)dilemmaHandler);
                            IConflictItem conflict = SimpleConflictCompareEditorInput.this.getConflictedItem();
                            IComponentSyncContext context = conflict.getOutgoingActivitySource().getModel();
                            IWorkspaceConnection connection = context.getWorkspaceSyncContext().getLocal();
                            ILogicalConflictReport conflictReport = context.getLogicalConflictReport();
                            autoResolveOperation.autoResolveConflict(connection, conflictReport, conflict.getLogicalChange());
                            SimpleConflictCompareEditorInput.this.runningAutoResolve = true;
                            autoResolveOperation.run((IProgressMonitor)progress.newChild(100));
                            final int successCount = autoResolveOperation.numberOfConflictsResolved();
                            currentContext.getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    if (successCount == 0) {
                                        MessageDialogFactory.showMessage((Shell)SimpleConflictCompareEditorInput.this.shell, (String)Messages.SimpleConflictCompareEditorInput_6, (int)4, (String)Messages.SimpleConflictCompareEditorInput_7);
                                    } else {
                                        SimpleConflictCompareEditorInput.this.closeEditor(false);
                                    }
                                    SimpleConflictCompareEditorInput.this.runningAutoResolve = false;
                                }
                            });
                        }
                        catch (FileSystemClientException e) {
                            throw new TeamRepositoryException((Throwable)e);
                        }
                    }
                });
            }
        });
        this.resolveButton = new Button(banner, 8);
        this.resolveButton.setText(Messages.SimpleConflictCompareEditorInput_8);
        this.resolveButton.setToolTipText(Messages.SimpleConflictCompareEditorInput_9);
        this.resolveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleConflictCompareEditorInput.this.resolveAsMerged();
            }
        });
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(5).generateLayout(banner);
        if (!this.fileProperties.isShareableChanges()) {
            Control c = super.createContents(top);
            GridDataFactory.fillDefaults().grab(true, true).applyTo(c);
            return top;
        }
        this.pane = new CompareFilePropertiesViewerPane(top, this.getCompareConfiguration(), this.fileProperties, this.getWorkbenchPart().getSite()){

            protected void firePropertyChange(PropertyChangeEvent event) {
                SimpleConflictCompareEditorInput.this.firePropertyChange(event);
            }
        };
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.pane);
        if (this.fileStreamChanges) {
            Control c = super.createContents(top);
            GridDataFactory.fillDefaults().grab(true, true).applyTo(c);
        } else {
            Composite c = CompareFilePropertiesViewerPane.createNoStreamChangesLabel(top);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)c);
        }
        return top;
    }

    protected boolean closeEditor(boolean checkForUnsavedChanges) {
        if (this.isSaveNeeded() && checkForUnsavedChanges) {
            return false;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                IEditorPart part = SimpleConflictCompareEditorInput.this.getPage().findEditor((IEditorInput)SimpleConflictCompareEditorInput.this);
                SimpleConflictCompareEditorInput.this.getPage().closeEditor(part, false);
            }
        };
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display display = this.getPage().getWorkbenchWindow().getShell().getDisplay();
            display.asyncExec(runnable);
        }
        return true;
    }

    protected void contentsCreated() {
        if (this.localFile != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        super.contentsCreated();
    }

    protected void handleDispose() {
        if (this.conflictsImage != null) {
            this.conflictsImage.dispose();
        }
        if (this.localFile != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        super.handleDispose();
        for (DisposableInputStreamProvider buffer : this.disposableBuffers) {
            try {
                buffer.dispose();
            }
            catch (IOException iOException) {}
        }
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        return this.prepareCompareInput(monitor);
    }

    protected ICompareInput prepareCompareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        CompareConfiguration cc;
        block13: {
            cc = this.getCompareConfiguration();
            if (this.conflict.getItem() instanceof IFileItemHandle) break block13;
            return null;
        }
        try {
            String name = this.conflict.getResourceName(false);
            int index = name != null ? name.lastIndexOf(46) : -1;
            String extension = index >= 0 && index < name.length() ? name.substring(index + 1) : null;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            IShareable shareable = ComponentSyncUtil.findShareable((IConflictItem)this.conflict, (boolean)true, (IProgressMonitor)progress.newChild(1));
            if (shareable != null) {
                IResource resource = (IResource)shareable.getAdapter(IResource.class);
                IVersionableHandle remote = shareable.getRemote();
                this.isEvilTwin = remote == null || !remote.sameItemId((IItemHandle)this.conflict.getItem());
                String leftLabel = null;
                if (resource instanceof IFile) {
                    this.localFile = (IFile)resource;
                    final String localEncoding = SimpleConflictCompareEditorInput.getEncoding(this.localFile);
                    this.left = new BufferedResourceNode((IResource)this.localFile){

                        public String getCharset() {
                            return localEncoding;
                        }
                    };
                    this.left.addContentChangeListener(new IContentChangeListener(){

                        public void contentChanged(IContentChangeNotifier source) {
                            try {
                                if (!SimpleConflictCompareEditorInput.this.saving) {
                                    SimpleConflictCompareEditorInput.this.saveChanges((IProgressMonitor)new NullProgressMonitor());
                                }
                            }
                            catch (CoreException e) {
                                LoggingHelper.error((String)"com.ibm.team.filesystem.rcp.ui", (String)e.getMessage(), (Throwable)e);
                            }
                        }
                    });
                    String string = leftLabel = this.isEvilTwin ? NLS.bind((String)Messages.SimpleConflictCompareEditorInput_10, (Object)name) : NLS.bind((String)Messages.SimpleConflictCompareEditorInput_11, (Object)name);
                }
                if (resource instanceof IFolder && this.isEvilTwin) {
                    leftLabel = NLS.bind((String)Messages.SimpleConflictCompareEditorInput_12, (Object)name);
                }
                cc.setLeftLabel(leftLabel);
            } else {
                cc.setLeftLabel(Messages.SimpleConflictCompareEditorInput_13);
            }
            IItemConflictReport conflictReport = this.conflict.getItemConflictReport();
            ITeamRepository repo = this.conflict.getOutgoingActivitySource().getModel().teamRepository();
            SimpleTypedElement right = null;
            IFileItem rightItem = null;
            if (conflictReport.getProposedContributorState() instanceof IFileItemHandle) {
                IFileItemHandle handle = (IFileItemHandle)conflictReport.getProposedContributorState();
                rightItem = (IFileItem)SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState((IVersionableHandle)handle, (IProgressMonitor)progress.newChild(1));
                right = this.createTypedElement(repo, rightItem, name, extension, (IProgressMonitor)progress.newChild(1));
                cc.setRightLabel(NLS.bind((String)Messages.SimpleConflictCompareEditorInput_14, (Object)name, (Object)this.conflict.getOutgoingActivitySource().getWorkspace().getName()));
            } else {
                cc.setRightLabel(Messages.SimpleConflictCompareEditorInput_15);
            }
            SimpleTypedElement ancestor = null;
            IFileItem ancestorItem = null;
            if (conflictReport.getCommonAncestorState() instanceof IFileItemHandle) {
                IFileItemHandle handle = (IFileItemHandle)conflictReport.getCommonAncestorState();
                ancestorItem = (IFileItem)SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState((IVersionableHandle)handle, (IProgressMonitor)progress.newChild(1));
                ancestor = this.createTypedElement(repo, ancestorItem, name, extension, (IProgressMonitor)progress.newChild(1));
                cc.setAncestorLabel(NLS.bind((String)Messages.SimpleConflictCompareEditorInput_16, (Object)name));
            }
            this.fileProperties = new CompareFilePropertiesState(shareable, rightItem, ancestorItem);
            Differencer d = new Differencer(){

                protected Object visit(Object parent, int description, Object ancestor, Object left, Object right) {
                    return new FireChangesDiffNode((IDiffContainer)parent, description, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
                }
            };
            Object result = d.findDifferences(ancestor != null, (IProgressMonitor)progress.newChild(95), null, (Object)ancestor, (Object)this.left, (Object)right);
            boolean bl = this.fileStreamChanges = result != null;
            if (result == null && this.fileProperties.isShareableChanges()) {
                result = new FireChangesDiffNode(null, 7, ancestor, (ITypedElement)this.left, right);
            }
            progress.done();
            return (ICompareInput)result;
        }
        catch (TeamRepositoryException e) {
            throw new InvocationTargetException(e);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    SimpleTypedElement createTypedElement(ITeamRepository repository, IFileItem fileItem, String name, String extension, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        DisposableInputStreamProvider buffer = TemporaryOutputStream.createLocalBuffer((IInputStreamProvider)new FileContentInputStreamProvider(repository, fileItem.getContent()), (IProgressMonitor)monitor);
        this.disposableBuffers.add(buffer);
        String encoding = SimpleConflictCompareEditorInput.getEncoding(fileItem.getContent().getCharacterEncoding(), buffer, monitor);
        return new SimpleTypedElement(buffer, name, extension, encoding);
    }

    public static String getEncoding(String encoding, DisposableInputStreamProvider buffer, IProgressMonitor monitor) throws IOException {
        BufferedInputStream stream;
        String utfEncoding;
        if (SimpleConflictCompareEditorInput.requiresCheckForBom(encoding) && (utfEncoding = SimpleConflictCompareEditorInput.getUTFEncoding(stream = new BufferedInputStream(buffer.getInputStream(monitor)))) != null) {
            return utfEncoding;
        }
        return encoding;
    }

    /*
     * Loose catch block
     */
    private static String getUTFEncoding(InputStream stream) {
        block22: {
            block21: {
                int offset;
                byte[] bom;
                block20: {
                    block19: {
                        bom = new byte[3];
                        offset = 0;
                        int count = 0;
                        while (offset < 3 && count != -1) {
                            count = stream.read(bom, offset, 3 - offset);
                            if (count == -1) continue;
                            offset += count;
                        }
                        if (offset != 3 || !SimpleConflictCompareEditorInput.isBytesEqual(bom, UTF_8_BOM, 3)) break block19;
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        return "UTF-8";
                    }
                    if (offset < 2 || !SimpleConflictCompareEditorInput.isBytesEqual(bom, UTF_16_BE_BOM, 2)) break block20;
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    return "UTF-16BE";
                }
                if (offset < 2 || !SimpleConflictCompareEditorInput.isBytesEqual(bom, UTF_16_LE_BOM, 2)) break block21;
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                return "UTF-16LE";
                catch (IOException e) {
                    try {
                        StatusUtil.log((Object)"com.ibm.team.filesystem.rcp.ui", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    break block22;
                }
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static boolean isBytesEqual(byte[] b1, byte[] b2, int length) {
        int i = 0;
        while (i < length) {
            if (b1[i] != b2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean requiresCheckForBom(String encoding) {
        return !encoding.toUpperCase().startsWith("UTF");
    }

    public static String getEncoding(IFile file) throws CoreException {
        BufferedInputStream stream;
        String utfEncoding;
        String encoding = file.getCharset();
        if (SimpleConflictCompareEditorInput.requiresCheckForBom(encoding) && (utfEncoding = SimpleConflictCompareEditorInput.getUTFEncoding(stream = new BufferedInputStream(file.getContents()))) != null) {
            return utfEncoding;
        }
        return encoding;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.localFile != null) {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta = delta.findMember(this.localFile.getFullPath());
            }
            if (delta != null && ((delta.getKind() & 3) > 0 || (delta.getKind() & 4) > 0 && (delta.getFlags() & 0x40100) > 0) && this.shell != null && !this.shell.isDisposed()) {
                this.shell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        SimpleConflictCompareEditorInput.this.fireInputChange();
                    }
                });
            }
        }
    }

    public boolean isSaveNeeded() {
        if (this.pane != null) {
            return this.pane.isDirty() || super.isSaveNeeded();
        }
        return super.isSaveNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChanges(IProgressMonitor monitor) throws CoreException {
        if (this.saving) {
            return;
        }
        SimpleConflictCompareEditorInput simpleConflictCompareEditorInput = this;
        synchronized (simpleConflictCompareEditorInput) {
            this.saving = true;
        }
        if (this.pane != null) {
            this.pane.flush(monitor);
        }
        SimpleConflictCompareEditorInput.super.saveChanges(monitor);
        this.left.commit(monitor);
        simpleConflictCompareEditorInput = this;
        synchronized (simpleConflictCompareEditorInput) {
            this.saving = false;
        }
    }

    protected void resolveAsMerged() {
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor progress) throws InvocationTargetException, InterruptedException {
                    try {
                        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.SimpleConflictCompareEditorInput_17, (int)100);
                        if (SimpleConflictCompareEditorInput.this.isDirty()) {
                            SimpleConflictCompareEditorInput.this.saveChanges((IProgressMonitor)monitor.newChild(50));
                        } else {
                            monitor.setWorkRemaining(50);
                        }
                        SimpleConflictCompareEditorInput.this.shell.getDisplay().syncExec(new Runnable(){

                            public void run() {
                                IWorkbenchPart part = SimpleConflictCompareEditorInput.this.getContainer().getWorkbenchPart();
                                IOperationRunner runner = UIContext.createPartContext((IWorkbenchPart)part).getUserOperationRunner();
                                runner.enqueue(Messages.SimpleConflictCompareEditorInput_18, (Operation)new RepositoryOperation(){

                                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                                        try {
                                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.SimpleConflictCompareEditorInput_19, (int)100);
                                            ComponentSyncContext context = (ComponentSyncContext)SimpleConflictCompareEditorInput.this.conflict.getOutgoingActivitySource().getModel();
                                            IWorkspaceConnection wc = context.getOutgoingTeamPlace();
                                            ILogicalConflictReport conflictReport = context.getLogicalConflictReport();
                                            final boolean[] okToClose = new boolean[1];
                                            WarnResolveAsMergedUser problemHandler = new WarnResolveAsMergedUser(SimpleConflictCompareEditorInput.this.shell, Messages.SimpleConflictCompareEditorInput_20){
                                                private boolean prompted;
                                                {
                                                    super($anonymous0, $anonymous1);
                                                    this.prompted = false;
                                                }

                                                @Override
                                                public int unmergedChanges(Collection<ILogicalChange> changes) {
                                                    if (!changes.isEmpty()) {
                                                        final int[] result = new int[]{1};
                                                        if (PlatformUI.isWorkbenchRunning()) {
                                                            Display display = PlatformUI.getWorkbench().getDisplay();
                                                            display.syncExec(new Runnable(){

                                                                public void run() {
                                                                    MessageDialog dialog = new MessageDialog(SimpleConflictCompareEditorInput.this.shell, Messages.SimpleConflictCompareEditorInput_21, null, Messages.SimpleConflictCompareEditorInput_22, 4, new String[]{Messages.SimpleConflictCompareEditorInput_23, IDialogConstants.CANCEL_LABEL}, 1);
                                                                    int r = dialog.open();
                                                                    if (r == 0) {
                                                                        result[0] = 0;
                                                                    }
                                                                }
                                                            });
                                                        }
                                                        this.prompted = true;
                                                        return result[0];
                                                    }
                                                    return 0;
                                                }

                                                public int confirmMarkAsMerged(Collection<ILogicalChange> changes) {
                                                    final int[] result = new int[]{1};
                                                    if (this.prompted) {
                                                        result[0] = 0;
                                                    } else if (PlatformUI.isWorkbenchRunning()) {
                                                        Display display = PlatformUI.getWorkbench().getDisplay();
                                                        display.syncExec(new Runnable(){

                                                            public void run() {
                                                                if (MessageDialog.openConfirm((Shell)SimpleConflictCompareEditorInput.this.shell, (String)Messages.SimpleConflictCompareEditorInput_24, (String)Messages.SimpleConflictCompareEditorInput_25)) {
                                                                    result[0] = 0;
                                                                }
                                                            }
                                                        });
                                                    }
                                                    if (result[0] == 0) {
                                                        okToClose[0] = true;
                                                    }
                                                    return result[0];
                                                }
                                            };
                                            Collection changes = ComponentConflictUtil.getChanges((ILogicalConflictReport)conflictReport, (Collection)Collections.singletonList(SimpleConflictCompareEditorInput.this.conflict));
                                            EclipseWorkspaceMarkAsMergedOperation mergedOp = new EclipseWorkspaceMarkAsMergedOperation(wc, conflictReport, changes, (MarkAsMergedDilemmaHandler)problemHandler);
                                            mergedOp.run((IProgressMonitor)progress.newChild(90));
                                            if (okToClose[0]) {
                                                SimpleConflictCompareEditorInput.this.closeEditor(true);
                                            }
                                        }
                                        catch (FileSystemClientException e) {
                                            throw new TeamRepositoryException((Throwable)e);
                                        }
                                    }
                                });
                            }
                        });
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            IStatus status = StatusUtil.newStatus((Object)((Object)this), (Throwable)e.getTargetException());
            StatusUtil.log((IStatus)status);
            ErrorDialog.openError((Shell)this.shell, (String)Messages.SimpleConflictCompareEditorInput_26, (String)Messages.SimpleConflictCompareEditorInput_27, (IStatus)status);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected void fireInputChange() {
        if (!this.runningAutoResolve) {
            ((FireChangesDiffNode)((Object)this.getCompareResult())).fireChanges();
        }
    }

    public boolean equals(Object other) {
        SimpleConflictCompareEditorInput otherInput;
        IConflictItem conflictedItem;
        if (other == this) {
            return true;
        }
        if (other instanceof SimpleConflictCompareEditorInput && (conflictedItem = (otherInput = (SimpleConflictCompareEditorInput)((Object)other)).getConflictedItem()) != null && this.conflict != null) {
            return conflictedItem.getItem().sameItemId((IItemHandle)this.conflict.getItem());
        }
        return false;
    }

    public boolean canRunAsJob() {
        return true;
    }

    public void setPage(IWorkbenchPage activePage) {
        this.page = activePage;
    }
}

