/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStateComputer {
    private IVersionable leftItem;
    private IVersionable rightItem;
    private StateId leftState;
    private StateId rightState;
    private ITeamRepository repo;

    public FileStateComputer(ITeamRepository repo, StateId<? extends IItem> state) {
        this(repo, state, state);
    }

    public FileStateComputer(ITeamRepository repo, StateId<? extends IItem> leftState, StateId<? extends IItem> rightState) {
        this.repo = repo;
        this.leftState = leftState;
        this.rightState = rightState;
    }

    private synchronized void fetchItems(IProgressMonitor monitor) throws TeamRepositoryException {
        Collection toFetch = NewCollection.arrayList();
        toFetch.add(this.leftState);
        toFetch.add(this.rightState);
        Map result = RepoFetcher.fetchItems((ITeamRepository)this.repo, (Collection)toFetch, (IProgressMonitor)monitor);
        this.leftItem = (IVersionable)result.get(this.leftState);
        this.rightItem = (IVersionable)result.get(this.rightState);
    }

    public IRemoteFunction<FileState> getLeft() {
        return new IRemoteFunction<FileState>(){

            public FileState compute(IProgressMonitor monitor) throws TeamRepositoryException {
                FileStateComputer.this.fetchItems(monitor);
                return ClientFileStateFactory.create((ITeamRepository)FileStateComputer.this.repo, (IVersionable)FileStateComputer.this.leftItem);
            }
        };
    }

    public IRemoteFunction<FileState> getRight() {
        return new IRemoteFunction<FileState>(){

            public FileState compute(IProgressMonitor monitor) throws TeamRepositoryException {
                FileStateComputer.this.fetchItems(monitor);
                return ClientFileStateFactory.create((ITeamRepository)FileStateComputer.this.repo, (IVersionable)FileStateComputer.this.rightItem);
            }
        };
    }
}

