/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.compare.CompareFilePropertiesState;
import com.ibm.team.filesystem.rcp.ui.internal.compare.CompareFilePropertiesViewerPane;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileStateComputer;
import com.ibm.team.filesystem.rcp.ui.internal.compare.SimpleConflictCompareEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.SimpleTypedElement;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConstantFunction;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileChangeEditorInput
extends CompareEditorInput {
    private String leftLabel = null;
    private String rightLabel = null;
    private IRemoteFunction<FileState> left;
    private IRemoteFunction<FileState> right;
    private String leftFilename;
    private String rightFilename;
    private CompareFilePropertiesState fileProperties;
    private boolean fileStreamChanges;
    private boolean isCreateOrDelete = false;

    private FileChangeEditorInput(IRemoteFunction<FileState> left, IRemoteFunction<FileState> right, String leftFilename, String rightFilename) {
        super(new CompareConfiguration());
        this.left = left;
        this.right = right;
        this.leftFilename = leftFilename;
        this.rightFilename = rightFilename;
    }

    public static FileChangeEditorInput createFrom(ITeamRepository repo, StateId<IFileItem> left, IPath leftPath, StateId<IFileItem> right, IPath rightPath) {
        return FileChangeEditorInput.createFrom(repo, left, FileChangeEditorInput.getFilename(leftPath), right, FileChangeEditorInput.getFilename(rightPath));
    }

    public static FileChangeEditorInput createFrom(ITeamRepository repo, StateId<IFileItem> left, String leftFilename, StateId<IFileItem> right, String rightFilename) {
        FileStateComputer comp = new FileStateComputer(repo, left, right);
        return FileChangeEditorInput.createFrom(comp.getLeft(), comp.getRight(), leftFilename, rightFilename);
    }

    public static String getFilename(IPath path) {
        String result = path.lastSegment();
        if (result == null) {
            return Messages.FileChangeEditorInput_0;
        }
        return result;
    }

    public static FileChangeEditorInput createFrom(IRemoteFunction<FileState> left, IRemoteFunction<FileState> right, String leftFilename, String rightFilename) {
        return new FileChangeEditorInput(left, right, leftFilename, rightFilename);
    }

    public static FileChangeEditorInput createFrom(FileState left, FileState right) {
        return FileChangeEditorInput.createFrom((IRemoteFunction<FileState>)new ConstantFunction((Object)left), (IRemoteFunction<FileState>)new ConstantFunction((Object)right), FileChangeEditorInput.getName(left), FileChangeEditorInput.getName(right));
    }

    public static FileChangeEditorInput createFrom(FileChange theChange) {
        return FileChangeEditorInput.createFrom(theChange.getFinal(), theChange.getInitial());
    }

    public String getTitle() {
        String beforeName = this.rightFilename;
        String afterName = this.leftFilename;
        boolean sameFile = beforeName.equals(afterName);
        if (sameFile) {
            return afterName;
        }
        return NLS.bind((String)Messages.FileChangeEditorInput_1, (Object)beforeName, (Object)afterName);
    }

    public void setLabels(String leftLabel, String rightLabel) {
        this.leftLabel = leftLabel;
        this.rightLabel = rightLabel;
    }

    public Object prepareInput(IProgressMonitor pm) throws InvocationTargetException {
        ITypedElement right;
        ITypedElement left;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm, (int)100);
        CompareConfiguration cc = this.getCompareConfiguration();
        try {
            FileState leftState = (FileState)this.left.compute((IProgressMonitor)progress.newChild(25));
            FileState rightState = (FileState)this.right.compute((IProgressMonitor)progress.newChild(25));
            this.isCreateOrDelete = leftState.isDeleted() || rightState.isDeleted();
            left = FileChangeEditorInput.getTypedElement(leftState, (IProgressMonitor)progress.newChild(50));
            right = FileChangeEditorInput.getTypedElement(rightState, (IProgressMonitor)progress.newChild(50));
            this.fileProperties = new CompareFilePropertiesState(leftState, rightState);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        catch (TeamRepositoryException e) {
            throw new InvocationTargetException(e);
        }
        cc.setLeftLabel(this.leftLabel == null ? left.getName() : NLS.bind((String)Messages.FileChangeEditorInput_2, (Object)left.getName(), (Object)this.leftLabel));
        cc.setRightLabel(this.rightLabel == null ? right.getName() : NLS.bind((String)Messages.FileChangeEditorInput_3, (Object)right.getName(), (Object)this.rightLabel));
        Object diff = new Differencer().findDifferences(false, pm, null, null, (Object)left, (Object)right);
        boolean bl = this.fileStreamChanges = diff != null;
        if (diff == null && !this.fileProperties.isLeftSameAsRight()) {
            return new DiffNode(7, null, left, right);
        }
        return diff;
    }

    public static ITypedElement getTypedElement(FileState state, IProgressMonitor monitor) throws IOException {
        DisposableInputStreamProvider buffer = TemporaryOutputStream.createLocalBuffer((IInputStreamProvider)state.getContents(), (IProgressMonitor)monitor);
        String encoding = SimpleConflictCompareEditorInput.getEncoding(state.getCharacterEncoding(), buffer, monitor);
        return new SimpleTypedElement(buffer, FileChangeEditorInput.getName(state), FileChangeEditorInput.getExtension(state), encoding);
    }

    private static String getExtension(FileState state) {
        return state.getPath().getFileExtension();
    }

    private static String getName(FileState state) {
        String title = state.getPath().lastSegment();
        if (state.isDeleted()) {
            title = Messages.FileChangeEditorInput_4;
        }
        if (title == null) {
            return Messages.FileChangeEditorInput_5;
        }
        return title;
    }

    public Control createContents(Composite parent) {
        if (this.isCreateOrDelete || this.fileProperties.isLeftSameAsRight()) {
            return super.createContents(parent);
        }
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        CompareFilePropertiesViewerPane compareFilePropertiesViewerPane = new CompareFilePropertiesViewerPane(composite, this.getCompareConfiguration(), this.fileProperties, this.getWorkbenchPart().getSite()){

            protected void firePropertyChange(PropertyChangeEvent event) {
                FileChangeEditorInput.this.firePropertyChange(event);
            }
        };
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)compareFilePropertiesViewerPane);
        if (this.fileStreamChanges) {
            Control c = super.createContents(composite);
            GridDataFactory.fillDefaults().grab(true, true).applyTo(c);
        } else {
            Composite c = CompareFilePropertiesViewerPane.createNoStreamChangesLabel(composite);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)c);
        }
        return composite;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FileChangeEditorInput other = (FileChangeEditorInput)((Object)obj);
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        return !(this.right == null ? other.right != null : !this.right.equals(other.right));
    }

    public boolean canRunAsJob() {
        return true;
    }

    protected void handleDispose() {
        super.handleDispose();
        Object compareResult = this.getCompareResult();
        if (compareResult instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)compareResult;
            this.dispose(ci.getLeft());
            this.dispose(ci.getRight());
            this.dispose(ci.getAncestor());
        }
    }

    private void dispose(ITypedElement element) {
        Object adapter;
        if (element instanceof IAdaptable && (adapter = ((IAdaptable)element).getAdapter(DisposableInputStreamProvider.class)) instanceof DisposableInputStreamProvider) {
            DisposableInputStreamProvider disp = (DisposableInputStreamProvider)adapter;
            try {
                disp.dispose();
            }
            catch (IOException iOException) {}
        }
    }
}

