/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.restproxy;

import com.ibm.team.filesystem.client.internal.daemon.FSDaemon;
import com.ibm.team.filesystem.client.restproxy.HttpClientWrapper;
import com.ibm.team.filesystem.client.restproxy.IClientNotificationChannel;
import com.ibm.team.filesystem.client.restproxy.INotificationListener;
import com.ibm.team.filesystem.client.restproxy.ProgressRestParticipant;
import com.ibm.team.filesystem.client.restproxy.RestInvocationHandler;
import com.ibm.team.filesystem.client.restproxy.RestInvocationParticipant;
import com.ibm.team.filesystem.client.restproxy.StatisticsRestParticipant;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestDiscoveryException;
import com.ibm.team.filesystem.client.restproxy.notification.ClientNotificationChannel;
import com.ibm.team.filesystem.client.restproxy.notification.KeyInUseException;
import com.ibm.team.filesystem.client.restproxy.notification.ProgressNotificationParm;
import com.ibm.team.repository.client.IStatistics;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesystemRestClientDiscovery {
    public static final FilesystemRestClientDiscovery RESOLVER = new FilesystemRestClientDiscovery();
    private static final String DEBUG_TIMING_PROPERTY = "com.ibm.team.filesystem.client/debug/timing";
    public static final boolean DEBUG_TIMING = "true".equalsIgnoreCase(System.getProperty("com.ibm.team.filesystem.client/debug/timing"));
    private final Map<File, Client> clients = new HashMap<File, Client>();
    private final Map<File, Thread> threads = Collections.synchronizedMap(new HashMap());

    private FilesystemRestClientDiscovery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeLostReferences() {
        LinkedList<Client> toPurge = new LinkedList<Client>();
        Map<File, Client> map = this.clients;
        synchronized (map) {
            for (Client client : this.clients.values()) {
                if (client == null || !client.isStale()) continue;
                toPurge.add(client);
            }
            for (Client client : toPurge) {
                this.deregisterClient(client.path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientProxy findProxy(Class<?> type, File f) throws InterruptedException {
        Map<File, Client> map = this.clients;
        synchronized (map) {
            Client client;
            block6: {
                this.purgeLostReferences();
                client = this.clients.get(f);
                if (client != null) break block6;
                return null;
            }
            ClientProxy proxy = client.proxies.get(type);
            if (proxy == null && client.proxies.containsKey(type)) {
                this.clients.wait(10000L);
                client = this.clients.get(f);
                if (client != null) {
                    proxy = client.proxies.get(type);
                }
            }
            return proxy;
        }
    }

    public boolean hasInMemoryClientAt(File path) {
        return this.threads.containsKey(path);
    }

    public IClientLocation findLocation(Class<?> type, File f) {
        ClientProxy proxy;
        try {
            proxy = this.findProxy(type, f);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        if (proxy == null) {
            return null;
        }
        return proxy.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IClientLocation find(Object o) {
        Map<File, Client> map = this.clients;
        synchronized (map) {
            this.purgeLostReferences();
            for (Client client : this.clients.values()) {
                if (client == null) continue;
                for (ClientProxy proxy : client.proxies.values()) {
                    if (proxy.proxy.get() != o) continue;
                    return client;
                }
            }
        }
        return null;
    }

    public IStatistics findStatistics(Object o) {
        Client client = (Client)this.find(o);
        if (client == null || client.stats == null) {
            return null;
        }
        return client.stats.getStatistics();
    }

    public IStatistics printStatistics(Object o, PrintStream stream) {
        IStatistics stats = this.findStatistics(o);
        if (stats == null) {
            return null;
        }
        StatisticsRestParticipant.printStatistics(stats, stream);
        return stats;
    }

    public void joinInProcess(Object o) {
        Client client = (Client)this.find(o);
        if (client == null) {
            throw new IllegalArgumentException("Passed object is not a proxy to a filesystem daemon");
        }
        this.joinInProcessFromClient(client);
    }

    protected void joinInProcessFromClient(Client client) {
        Thread t = client.inProcessThread;
        if (t == null) {
            throw new IllegalStateException(NLS.bind((String)"Unknown daemon at path {0}", (Object)client.getPath()));
        }
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.deregisterClient(client.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterClient(Class<?> type, File pathToRoot) {
        Map<File, Client> map = this.clients;
        synchronized (map) {
            Client client = this.clients.get(pathToRoot);
            if (client == null) {
                this.clients.remove(pathToRoot);
                return;
            }
            client.removeProxy(type);
            if (client.isStale()) {
                this.deregisterClient(pathToRoot);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterClient(File pathToRoot) {
        Client c;
        Map<File, Client> map = this.clients;
        synchronized (map) {
            c = this.clients.remove(pathToRoot);
        }
        if (c != null) {
            c.cleanup();
        }
    }

    public <T> T resolve(Class<T> clazz, File pathToRoot, boolean runInProcess, boolean allowStart) throws RestDiscoveryException {
        DiscoveryParams params = new DiscoveryParams();
        params.setInterface(clazz);
        params.setPathToRoot(pathToRoot);
        params.setRunInProcess(runInProcess);
        params.setAllowStart(allowStart);
        return this.resolve(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T resolve(DiscoveryParams params) throws RestDiscoveryException {
        ClientProxy proxy;
        params.verify();
        Map<File, Client> map = this.clients;
        synchronized (map) {
            Object thing;
            try {
                proxy = this.findProxy(params.getType(), params.getPathToRoot());
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            if (proxy != null && (thing = proxy.proxy.get()) != null) {
                return thing;
            }
            Client client = this.clients.get(params.getPathToRoot());
            if (client == null) {
                assert (!this.clients.containsKey(params.getPathToRoot()));
                this.clients.put(params.getPathToRoot(), null);
                boolean completed = false;
                try {
                    try {
                        client = this.createClient(params);
                        completed = true;
                    }
                    catch (InterruptedException interruptedException) {
                        if (!completed || !params.isAllowStart() && client == null) {
                            this.deregisterClient(params.getType(), params.getPathToRoot());
                        }
                        return null;
                    }
                }
                finally {
                    if (!completed || !params.isAllowStart() && client == null) {
                        this.deregisterClient(params.getType(), params.getPathToRoot());
                    }
                }
            }
            if (client == null) {
                return null;
            }
            this.connectToDaemon(params, client);
            proxy = client.getProxy(params.type);
        }
        if (proxy == null) {
            return null;
        }
        return proxy.proxy.get();
    }

    private Client createClient(DiscoveryParams params) throws RestDiscoveryException, InterruptedException {
        String url;
        FSDaemon.ILockFile lockFile;
        try {
            lockFile = FSDaemon.readLock(params.pathToRoot);
        }
        catch (IOException e) {
            throw new RestDiscoveryException("Unable to read lockfile in " + params.getPathToRoot().getPath(), e);
        }
        catch (InterruptedException e) {
            throw new RestDiscoveryException("Interrupted while reading location file in " + params.getPathToRoot().getPath(), e);
        }
        Thread inProcessThread = null;
        FSDaemon daemon = null;
        if (lockFile == null && params.isAllowStart()) {
            if (params.isRunInProcess()) {
                daemon = this.startInProcess(params.getPathToRoot());
                if (daemon != null) {
                    lockFile = daemon.getLockFile();
                }
                if ((inProcessThread = this.threads.get(params.getPathToRoot())) == null) {
                    throw new IllegalStateException("in-process FSDaemon failed too quickly");
                }
            } else {
                lockFile = this.startOutOfProcess(params.getPathToRoot(), params.getDaemonExecutable(), Arrays.asList(params.getExtraArguments()));
            }
        }
        if (lockFile == null) {
            return null;
        }
        try {
            url = new URI("http", null, InetAddress.getByName(null).getHostAddress(), lockFile.getPort(), "/", null, null).toASCIIString();
        }
        catch (UnknownHostException e) {
            throw new RestDiscoveryException(e);
        }
        catch (URISyntaxException e) {
            throw new RestDiscoveryException(e);
        }
        StatisticsRestParticipant srp = null;
        if (DEBUG_TIMING || params.isEnableStats()) {
            srp = new StatisticsRestParticipant();
        }
        Client client = new Client(url, lockFile.getKey(), params.getPathToRoot(), lockFile.getPort(), srp, daemon, this.threads.get(params.getPathToRoot()));
        this.clients.put(params.pathToRoot, client);
        return client;
    }

    private ClientProxy connectToDaemon(DiscoveryParams params, final Client client) {
        RestInvocationHandler handler = new RestInvocationHandler(params.getType(), client.url, client.getClient());
        handler.addParticipant(new RestInvocationParticipant(){

            public void preRequest(RestInvocationParticipant.CallKey key, HttpMethod request) {
                request.addRequestHeader("X-Secret-Key", client.key);
            }
        });
        handler.addParticipant(new ProgressRestParticipant());
        final File pathToRoot = params.getPathToRoot();
        final Method[] terminationMethods = new Method[params.getTerminationMethods().length];
        System.arraycopy(params.getTerminationMethods(), 0, terminationMethods, 0, terminationMethods.length);
        handler.addParticipant(new RestInvocationParticipant(){

            public void postInvoke(RestInvocationParticipant.CallKey key, Object proxy, Method method, Object[] args, Object returnValue, Throwable exception) {
                if (exception == null) {
                    Method[] methodArray = terminationMethods;
                    int n = terminationMethods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method m = methodArray[n2];
                        if (m.equals(method)) {
                            FilesystemRestClientDiscovery.this.deregisterClient(pathToRoot);
                        }
                        ++n2;
                    }
                }
            }
        });
        StatisticsRestParticipant srp = client.stats;
        if (srp != null) {
            handler.addParticipant(srp);
        }
        Object wrapped = Proxy.newProxyInstance(params.getType().getClassLoader(), new Class[]{params.getType()}, (InvocationHandler)handler);
        return client.addProxy(params.getType(), wrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FSDaemon startInProcess(final File pathToRoot) throws RestDiscoveryException {
        final FSDaemon fsd = new FSDaemon(pathToRoot);
        final SnitchingLifecycleListener listener = new SnitchingLifecycleListener(pathToRoot);
        Thread t = new Thread(new Runnable(){

            public void run() {
                fsd.start(listener);
                FilesystemRestClientDiscovery.this.deregisterClient(pathToRoot);
                FilesystemRestClientDiscovery.this.threads.remove(pathToRoot);
            }
        });
        SnitchingLifecycleListener snitchingLifecycleListener = listener;
        synchronized (snitchingLifecycleListener) {
            try {
                t.start();
                if (!listener.waitForStart(40000L)) {
                    throw new IllegalStateException("Waited for 40000ms, but FSDaemon failed to come up");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unexpected interruption", e);
            }
        }
        this.threads.put(pathToRoot, t);
        return fsd;
    }

    private FSDaemon.ILockFile startOutOfProcess(File pathToRoot, String executable, List<String> extraArgs) throws InterruptedException {
        ArrayList<String> argsToRun = new ArrayList<String>(4);
        argsToRun.add(executable);
        argsToRun.add("daemon");
        argsToRun.add("start");
        argsToRun.add(pathToRoot.getAbsolutePath());
        argsToRun.addAll(extraArgs);
        HashMap<String, Pattern> patterns = new HashMap<String, Pattern>();
        patterns.put("port", Pattern.compile("Port: (\\d+)", 8));
        patterns.put("key", Pattern.compile("Key: ([0-9A-F]+)", 8));
        ProcessBuilder pb = new ProcessBuilder(argsToRun);
        Process process = null;
        try {
            process = pb.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to start client", e);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        final ExpectReader reader = new ExpectReader(process.getInputStream(), out, patterns);
        reader.join(20000L);
        return new FSDaemon.ILockFile(){

            public int getPort() {
                return Integer.parseInt(reader.getValue("port"));
            }

            public String getKey() {
                return reader.getValue("key");
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Client
    implements IClientLocation {
        final String url;
        final String key;
        final File path;
        final int port;
        final Map<Class<?>, ClientProxy> proxies = new HashMap();
        HttpClientWrapper connectionPool;
        final StatisticsRestParticipant stats;
        final FSDaemon daemon;
        final ClientNotificationChannel channel;
        private final Thread inProcessThread;

        public Client(String url, String k, File path, int port, StatisticsRestParticipant stats, FSDaemon daemon, Thread inProcessThread) {
            this.url = url;
            this.key = k;
            this.path = path;
            this.port = port;
            this.stats = stats;
            this.daemon = daemon;
            this.inProcessThread = inProcessThread;
            this.connectionPool = new HttpClientWrapper(this.createHttpClient());
            this.channel = new ClientNotificationChannel(url, this.key, this.connectionPool);
            this.channel.addType(ProgressNotificationParm.TYPE, ProgressNotificationParm.class);
        }

        private HttpClient createHttpClient() {
            MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
            HttpConnectionManagerParams parms = new HttpConnectionManagerParams();
            parms.setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, Integer.MAX_VALUE);
            parms.setMaxTotalConnections(Integer.MAX_VALUE);
            manager.setParams(parms);
            return new HttpClient((HttpConnectionManager)manager);
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public File getPath() {
            return this.path;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        HttpClientWrapper getClient() {
            return this.connectionPool;
        }

        public boolean isStale() {
            this.purgeLostReferences();
            if (this.proxies.isEmpty()) {
                return true;
            }
            for (ClientProxy proxy : this.proxies.values()) {
                if (proxy.isStale()) continue;
                return false;
            }
            return true;
        }

        private void purgeLostReferences() {
            Iterator<Map.Entry<Class<?>, ClientProxy>> i = this.proxies.entrySet().iterator();
            while (i.hasNext()) {
                ClientProxy proxy = i.next().getValue();
                if (!proxy.isStale()) continue;
                i.remove();
            }
        }

        public ClientProxy addProxy(Class<?> type, Object proxy) {
            ClientProxy p = new ClientProxy(this, proxy, type, this.inProcessThread == null ? null : proxy);
            this.proxies.put(type, p);
            RestInvocationHandler handler = (RestInvocationHandler)Proxy.getInvocationHandler(proxy);
            handler.setNotificationChannel(this.channel);
            return p;
        }

        public void removeProxy(Class<?> type) {
            RestInvocationHandler handler;
            ClientProxy proxy = this.proxies.remove(type);
            if (proxy == null) {
                return;
            }
            try {
                handler = (RestInvocationHandler)Proxy.getInvocationHandler(proxy);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            handler.setNotificationChannel(null);
        }

        public ClientProxy getProxy(Class<?> type) {
            return this.proxies.get(type);
        }

        @Override
        public String addListener(String key, INotificationListener l, boolean keyMustBeUnique) throws KeyInUseException {
            return this.channel.addListener(key, l, keyMustBeUnique);
        }

        @Override
        public void removeListener(String key, INotificationListener l) {
            this.channel.removeListener(key, l);
        }

        @Override
        public void addType(String typeName, Class<? extends IParameterWrapper> toInstantiate) {
            this.channel.addType(typeName, toInstantiate);
        }

        @Override
        public void removeType(String typeName, Class<? extends IParameterWrapper> toRemove) {
            this.channel.removeType(typeName, toRemove);
        }

        @Override
        public void shutdown() {
            this.daemon.stop();
            try {
                RESOLVER.joinInProcessFromClient(this);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }

        public void cleanup() {
            this.connectionPool.shutdown = true;
            this.connectionPool.lock.writeLock().lock();
            try {
                ((MultiThreadedHttpConnectionManager)this.connectionPool.client.getHttpConnectionManager()).shutdown();
            }
            finally {
                this.connectionPool.lock.writeLock().unlock();
            }
        }

        @Override
        public String getURI() {
            return this.url;
        }

        @Override
        public FSDaemon getInProcessServer() {
            if (this.inProcessThread != null) {
                return this.daemon;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClientProxy {
        final Client client;
        final WeakReference<Object> proxy;
        final Object inProcessProxy;
        final Class<?> type;

        ClientProxy(Client client, Object proxy, Class<?> type, Object inProcessProxy) {
            this.client = client;
            this.proxy = new WeakReference<Object>(proxy);
            this.type = type;
            this.inProcessProxy = inProcessProxy;
        }

        boolean isStale() {
            return this.proxy.get() == null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DiscoveryParams {
        public static String DEFAULT_EXECUTABLE = "scm";
        Class<?> type = null;
        File pathToRoot = null;
        boolean runInProcess = true;
        boolean allowStart = false;
        boolean enableStats = false;
        String daemonExecutable = DEFAULT_EXECUTABLE;
        Method[] terminationMethods = new Method[0];
        private String[] extraArgs = new String[0];

        public Class<?> getInterface() {
            return this.type;
        }

        public void setInterface(Class<?> newClass) {
            this.type = newClass;
        }

        public File getPathToRoot() {
            return this.pathToRoot;
        }

        public void setPathToRoot(File newPathToRoot) {
            this.pathToRoot = newPathToRoot;
        }

        public boolean isRunInProcess() {
            return this.runInProcess;
        }

        public void setRunInProcess(boolean newRunInProcess) {
            this.runInProcess = newRunInProcess;
        }

        public boolean isAllowStart() {
            return this.allowStart;
        }

        public void setAllowStart(boolean newAllowStart) {
            this.allowStart = newAllowStart;
        }

        public boolean isEnableStats() {
            return this.enableStats;
        }

        public void setEnableStats(boolean newEnableStats) {
            this.enableStats = newEnableStats;
        }

        public String getDaemonExecutable() {
            return this.daemonExecutable;
        }

        public void setDaemonExecutable(String newDaemonExecutable) {
            this.daemonExecutable = newDaemonExecutable;
        }

        public void setTerminationMethods(Method ... methods) {
            this.terminationMethods = methods;
        }

        public Method[] getTerminationMethods() {
            return this.terminationMethods;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setExtraArguments(String ... args) {
            this.extraArgs = args;
        }

        public String[] getExtraArguments() {
            return this.extraArgs;
        }

        protected void verify() {
            if (this.pathToRoot == null) {
                throw new IllegalArgumentException("Must set path to root");
            }
            if (this.runInProcess && (this.extraArgs == null || this.extraArgs.length != 0)) {
                throw new IllegalArgumentException("May only specify extra arguments when running out of process");
            }
            if (this.runInProcess && !DEFAULT_EXECUTABLE.equals(this.daemonExecutable)) {
                throw new IllegalArgumentException("May not specify external executable when running in process");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExpectReader
    implements Runnable {
        final InputStream in;
        final ByteArrayOutputStream out;
        final Map<String, Pattern> expected;
        final Map<String, String> values = new HashMap<String, String>();
        final List<String> unmatchedKeys;
        IOException error;

        protected ExpectReader(InputStream in, ByteArrayOutputStream out, Map<String, Pattern> expected) {
            this.in = in;
            this.out = out;
            this.expected = expected;
            this.unmatchedKeys = new ArrayList<String>(expected.size());
            this.unmatchedKeys.addAll((Collection<String>)expected.keySet());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
            while ((line = this.readLine(reader)) != null) {
                Iterator<String> i = this.unmatchedKeys.iterator();
                while (i.hasNext()) {
                    String key = i.next();
                    Matcher m = this.expected.get(key).matcher(line);
                    if (!m.find()) continue;
                    this.values.put(key, m.group(1));
                    i.remove();
                }
                if (this.unmatchedKeys.size() != 0) continue;
                ExpectReader expectReader = this;
                synchronized (expectReader) {
                    this.notifyAll();
                }
                return;
            }
        }

        private String readLine(BufferedReader reader) {
            try {
                return reader.readLine();
            }
            catch (IOException e) {
                this.error = e;
                return null;
            }
        }

        public IOException getError() {
            return this.error;
        }

        public String getValue(String key) {
            return this.values.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void join(long timeout) throws InterruptedException {
            Thread t = new Thread(this);
            ExpectReader expectReader = this;
            synchronized (expectReader) {
                t.start();
                if (this.unmatchedKeys.size() == 0) {
                    return;
                }
                this.wait(timeout);
            }
        }
    }

    public static interface IClientLocation
    extends IClientNotificationChannel {
        public File getPath();

        public int getPort();

        public String getKey();

        public String getURI();

        public void shutdown();

        public FSDaemon getInProcessServer();
    }

    private class SnitchingLifecycleListener
    implements FSDaemon.ILifecycleListener {
        public int port;
        public String secret;
        public final File pathToRoot;
        private boolean hasStarted = false;

        public SnitchingLifecycleListener(File pathToRoot) {
            this.pathToRoot = pathToRoot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initialized(FSDaemon fsd) {
            this.port = fsd.getPort();
            this.secret = fsd.getKey();
            SnitchingLifecycleListener snitchingLifecycleListener = this;
            synchronized (snitchingLifecycleListener) {
                this.hasStarted = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown(FSDaemon fsd) {
            SnitchingLifecycleListener snitchingLifecycleListener = this;
            synchronized (snitchingLifecycleListener) {
                this.notifyAll();
            }
            FilesystemRestClientDiscovery.this.deregisterClient(this.pathToRoot);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean waitForStart(long timeout) throws InterruptedException {
            SnitchingLifecycleListener snitchingLifecycleListener = this;
            synchronized (snitchingLifecycleListener) {
                long stoppingTime = System.currentTimeMillis() + timeout;
                if (this.hasStarted) {
                    return true;
                }
                do {
                    this.wait(timeout);
                    if (!this.hasStarted) continue;
                    return true;
                } while (timeout == 0L || (timeout = stoppingTime - System.currentTimeMillis()) > 0L);
                return false;
            }
        }
    }
}

