/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.http;

import com.ibm.team.filesystem.client.internal.http.HttpConnection;
import com.ibm.team.filesystem.client.internal.http.HttpRequest;
import com.ibm.team.filesystem.client.internal.http.IExternalManager;
import com.ibm.team.filesystem.client.internal.http.LengthLimitedOutputStream;
import com.ibm.team.filesystem.client.internal.http.constants.HttpMethod;
import com.ibm.team.filesystem.client.internal.http.constants.ResponseCode;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;

public class HttpResponse {
    protected static final String HTTP_VERSION = "HTTP/1.1";
    protected final OutputStream responseStream;
    protected final HttpConnection connection;
    protected final HttpRequest request;
    protected HttpResponse predecessor;
    protected long responseLength = -1L;
    protected State state = State.code;
    protected boolean allowedBody;
    protected boolean isInfoResponse;
    protected boolean mustDisconnect;
    protected LengthLimitedOutputStream responseBody;
    protected boolean finished;
    protected boolean ignoreWriteErrors;
    protected volatile IExternalManager externalManager;

    public HttpResponse(OutputStream out, HttpConnection connection, HttpRequest request, HttpResponse predecessor) {
        this.responseStream = new WaitingOutputStream(out);
        this.request = request;
        this.allowedBody = false;
        this.isInfoResponse = false;
        this.mustDisconnect = false;
        this.connection = connection;
        this.predecessor = predecessor;
    }

    protected void setMustClose(boolean mustClose) {
        if (this.state != State.code) {
            throw new IllegalStateException();
        }
        this.mustDisconnect = mustClose;
    }

    public void setCode(int code, String reason) throws IOException {
        if (code < 0 || code > 999) {
            throw new IllegalArgumentException();
        }
        if (this.state != State.code) {
            if (!this.isInfoResponse) {
                throw new IllegalStateException();
            }
            this.writeLine("");
        }
        String codeStr = code < 10 ? "00" + Integer.toString(code) : (code < 100 ? "0" + Integer.toString(code) : Integer.toString(code));
        this.writeLine("HTTP/1.1 " + codeStr + " " + reason);
        this.isInfoResponse = code >= 100 && code <= 199;
        this.allowedBody = !this.isInfoResponse && this.request.getMethod() != HttpMethod.HEAD && code != ResponseCode.NO_CONTENT.getCode() && code != ResponseCode.NOT_MODIFIED.getCode();
        this.state = State.headers;
    }

    public void writeHeader(String key, String value) throws IOException {
        if (this.state != State.headers) {
            throw new IllegalStateException();
        }
        if (this.allowedBody && key.toLowerCase(Locale.ENGLISH).equals("Content-Length".toLowerCase(Locale.ENGLISH))) {
            this.responseLength = Long.valueOf(value);
        }
        this.writeLine(String.valueOf(key) + ": " + value);
    }

    public OutputStream getResponseStream() throws IOException {
        if (this.state != State.headers && this.state != State.body) {
            throw new IllegalStateException();
        }
        if (!this.allowedBody) {
            throw new IllegalStateException();
        }
        if (this.state == State.headers) {
            if (this.responseLength == -1L) {
                this.writeHeader("Connection", "close");
                this.mustDisconnect = true;
            } else if (this.mustDisconnect) {
                this.writeHeader("Connection", "close");
            }
            this.writeLine("");
        }
        this.state = State.body;
        if (this.responseLength == -1L) {
            return this.responseStream;
        }
        if (this.responseBody == null) {
            this.responseBody = new LengthLimitedOutputStream(this.responseStream, this.responseLength);
        }
        return this.responseBody;
    }

    protected void writeLine(String line) throws IOException {
        this.responseStream.write(line.getBytes("ISO-8859-1"));
        this.responseStream.write("\r\n".getBytes("ISO-8859-1"));
    }

    public void flushResponse() throws IOException {
        switch (this.state) {
            case code: 
            case done: {
                return;
            }
            case headers: {
                if (this.responseLength != -1L) {
                    if (this.responseLength != 0L) {
                        throw new IOException("Didn't write all the content that was promised");
                    }
                } else if (this.allowedBody) {
                    this.writeHeader("Content-Length", "0");
                }
                if (!this.isInfoResponse && this.mustDisconnect) {
                    this.writeHeader("Connection", "close");
                }
                this.writeLine("");
                this.responseStream.flush();
                if (this.isInfoResponse) {
                    this.state = State.code;
                    break;
                }
                this.state = State.done;
                break;
            }
            case body: {
                if (this.responseBody != null && this.responseBody.getLengthRemaining() != 0L) {
                    throw new IOException("Didn't write all the content that was promised");
                }
                this.responseStream.flush();
                this.state = State.done;
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void finish() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isClientConnected() {
        return this.connection.isClientConnected();
    }

    protected boolean shouldDisconnect() {
        return this.mustDisconnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        HttpResponse httpResponse = this;
        synchronized (httpResponse) {
            return this.finished;
        }
    }

    public boolean isExternallyManaged() {
        return this.externalManager != null;
    }

    public void setExternallyManaged(IExternalManager mgr) {
        if (this.externalManager != null) {
            throw new IllegalStateException();
        }
        this.externalManager = mgr;
        if (this.connection.server.shutdown) {
            mgr.shutdown();
        }
    }

    public void setIgnoreWriteErrors(boolean value) {
        this.ignoreWriteErrors = value;
    }

    public boolean shouldShutdown() {
        return this.connection.server.shutdown;
    }

    public void close() {
        this.connection.finishResponse(this.request, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilFinished() throws IOException {
        HttpResponse httpResponse = this;
        synchronized (httpResponse) {
            while (!this.finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    IOException ex = new IOException(e.getMessage());
                    ex.initCause(e);
                    throw ex;
                }
            }
        }
        return this.mustDisconnect;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        code,
        headers,
        body,
        done;

    }

    protected class WaitingOutputStream
    extends OutputStream {
        public OutputStream out;

        public WaitingOutputStream(OutputStream out) {
            this.out = out;
        }

        public void awaitOurTurn() throws IOException {
            if (HttpResponse.this.predecessor != null) {
                if (HttpResponse.this.predecessor.waitUntilFinished()) {
                    HttpResponse.this.mustDisconnect = true;
                    throw new IOException("Error sending response to pipelined request, previous response closed connection");
                }
                HttpResponse.this.predecessor = null;
            }
        }

        public void write(int b) throws IOException {
            this.awaitOurTurn();
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.awaitOurTurn();
            this.out.write(b, off, len);
        }

        public void flush() throws IOException {
            this.awaitOurTurn();
            this.out.flush();
        }
    }
}

