var previous = null;
var conversationID = null;
var scTop = 0;
var scHeight = 0;
var scCHeight = 0;
var isChat = true;

function highlightNode(samenode) {
	var parent = samenode.parentNode.parentNode;
	var userid = parent.getAttribute("username");
	if (!isChat) {
		if (previous == userid) {
			unhighlight(previous);
			previous = null;
			return;
		}
		highlight(userid);	
		return;
	}
	if (conversationID != null) {
		var chatwindow = JavaPackages.com.ibm.collaboration.realtime.chatwindow.ImChatPlugin.getChatWindow(conversationID);
		if (chatwindow != null) {
			if (chatwindow.isMultiChat()) {
				if (previous == userid) {
					unhighlight(previous);
					previous = null;
					return;
				}
				highlight(userid);	
				chatwindow.selectPartner(userid);				
			}
		}
	}
}

function highlight(userid) {
	unhighlight(previous);
	previous = userid;
	var nodelist = document.evaluate("//div[@class='messageBlock' and @username='" + userid + "']", 
				document, 
                                null, 
                                XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, 
                                null);
	if (nodelist) {
		for (var i=0; i<nodelist.snapshotLength; i++) {
			var div = nodelist.snapshotItem(i);
			div.setAttribute("class", "messageBlock highlight");
		}
	}
}

function unhighlight(userid) {
	if (userid == null || userid == '') {
		return;
	}
	var nodelist = document.evaluate("//div[@class='messageBlock highlight' and @username='" + userid + "']", 
				document, 
                                null, 
                                XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, 
                                null);
	if (nodelist) {
		for (var i=0; i<nodelist.snapshotLength; i++) {
			var div = nodelist.snapshotItem(i);
			div.setAttribute("class", "messageBlock");
		}
	}
}

function collapseDay(daystamp) {

}

function onclickDocument(evt) {
	if (evt.target != null && evt.target.nodeName == 'NOBR') {
		highlightNode(evt.target);
	} else {
		unhighlight(previous);
	}
	/*if (evt.target != null && evt.target.nodeName == 'DIV') {
		if (evt.target.getAttribute("class") == 'daystamp dsDisplay') {
			collapseDay(evt.target);
		}
	}*/
}

function hideEndDiv() {
	var gotoend = document.getElementById("gotoend");
	if (gotoend) {
		gotoend.style.visibility = "hidden";
	}
}

function showGoToEndDiv() {
	var gotoend = document.getElementById("gotoend");
	if (!gotoend) {
		gotoend = document.createElement("div");
		gotoend.id = "gotoend";
		
		gotoend.style.border = "1px #808080 solid";
		gotoend.style.backgroundColor = "#f8c048";
		gotoend.style.cursor = "pointer";
		gotoend.style.padding = "2 2 2 2";
		gotoend.style.fontWeight = "bold";
		gotoend.appendChild(document.createTextNode(newMessage));
		gotoend.style.left = "0px";
		gotoend.style.position = "absolute";
		gotoend.style.zIndex = 1000;
		gotoend.style.visibility = "hidden";
		gotoend.style.color = "#ffffff";
		gotoend.addEventListener("click", gotoEnd, false);

		var body = document.getElementsByTagName("body")[0];
		body.appendChild(gotoend);
	}
	var ht = gotoend.clientHeight;
	gotoend.style.top = (document.body.clientHeight - (ht + 1)) + "px"; //(document.body.scrollTop + document.body.clientHeight - 22) + "px";			
	gotoend.style.visibility = "visible";
}

function gotoEnd() {
	var divT = document.getElementById("divTranscript");
	divT.scrollTop = divT.scrollHeight;
	
	scTop = divT.scrollHeight;
	scHeight = divT.scrollHeight;
	scCHeight = (document.body.clientHeight - getTopAreaHeight());
	
	hideEndDiv();
}

function checkScroll() {
	var gotoend = document.getElementById("gotoend");
	if (gotoend) {
		if (gotoend.style.visibility == "visible") {
			gotoend.style.top = (document.body.scrollTop + document.body.clientHeight - 22) + "px";		
			if (document.body.scrollHeight == document.body.clientHeight + document.body.scrollTop) {
				hideEndDiv();
			}
		}		
	}
}

function setscroll() {

	var divT = document.getElementById("divTranscript");
	scTop = divT.scrollTop;
	scHeight = divT.scrollHeight;
	scCHeight = scCHeight = (document.body.clientHeight - document.getElementById("divBody").clientHeight);
	
	if (scTop+scCHeight >= scHeight) {
		hideEndDiv();
	}
}

function resize() {
	var divT = document.getElementById("divTranscript");
	divT.style.height = (document.body.clientHeight - getTopAreaHeight()) + "px";
	divT.style.width = (document.body.clientWidth) + "px";
	divT.style.overflow = "auto";
	divT.style.position = "absolute";
	divT.style.left = "0px";
	divT.style.top = getTopAreaHeight() + "px";

	if (!isChat) {
		return;
	}
	var hide = false;
	// scroll to end
	if (scTop + scCHeight >= scHeight) { //divT.scrollTop + divT.clientHeight != divT.scrollHeight) {
		divT.scrollTop = divT.scrollHeight;
		hide = true;
	}

	scTop = divT.scrollHeight;
	scHeight = divT.scrollHeight;
	scCHeight = (document.body.clientHeight - getTopAreaHeight());
	
	if (hide) {
		hideEndDiv();
	}
}

function resizeNewChat() {
	var divT = document.getElementById("divTranscript");
	divT.style.height = (document.body.clientHeight - getTopAreaHeight()) + "px";
	divT.style.width = (document.body.clientWidth) + "px";
	divT.style.overflow = "auto";
	divT.style.position = "absolute";
	divT.style.left = "0px";
	divT.style.top = getTopAreaHeight() + "px";

	var hide = false;
	// scroll to end
	if (scTop + scCHeight >= scHeight) { //divT.scrollTop + divT.clientHeight != divT.scrollHeight) {
		divT.scrollTop = divT.scrollHeight;
		hide = true;
	}

	scTop = divT.scrollTop;
	scHeight = divT.scrollHeight;
	scCHeight = (document.body.clientHeight - getTopAreaHeight());

	if (hide) {
		hideEndDiv();
	} else {
		showGoToEndDiv();
	}
}

function getTopAreaHeight() {
	var chatAlert = document.getElementById("chatAlert");
	if (chatAlert) {
		return chatAlert.clientHeight;
	}
	return document.getElementById("divBody").clientHeight;
}

function mouseOverClose() {
	var chatClose = document.getElementById("chatAlertClose");
	chatClose.firstChild.firstChild.src = closeHoverSrc;
}

function mouseOutClose() {
	var chatClose = document.getElementById("chatAlertClose");
	chatClose.firstChild.firstChild.src = closeSrc;
}

function hideChatAlertArea() {
	var chatAlert = document.getElementById("chatAlert");
	chatAlert.style.display = "none";
	resize();
}

function showChatAlertArea(img, line1, line2) {
	var chatAlert = document.getElementById("chatAlert");
	var chatImg = document.getElementById("chatAlertImage");
	var chatText = document.getElementById("chatAlertText");
	var chatClose = document.getElementById("chatAlertClose");

	if (!chatAlert) {
		chatAlert = document.createElement("div");
		chatAlert.id = "chatAlert";
		chatAlert.style.background = "url('" + alertGradient + "');";

		var body = document.getElementById("divBody");
		body.appendChild(chatAlert);

		chatImg = document.createElement("div");
		chatImg.id = "chatAlertImage";
		chatAlert.appendChild(chatImg);
		chatText = document.createElement("div");
		chatText.id = "chatAlertText";
		chatAlert.appendChild(chatText);
		chatClose = document.createElement("div");
		chatClose.id = "chatAlertClose";
		chatAlert.appendChild(chatClose);
		var aClose = document.createElement("a");
		aClose.href = "#";
		aClose.addEventListener("click", hideChatAlertArea, false);
		var closeImg = document.createElement("img");
		closeImg.src = closeSrc;
		closeImg.border = "0";
		chatClose.addEventListener("mouseover", mouseOverClose, false);
		chatClose.addEventListener("mouseout", mouseOutClose, false);
		chatClose.appendChild(aClose);
		aClose.appendChild(closeImg);
	} else {
		chatAlert.style.display = "block";
	}
	if (img) {
		if (chatImg.firstChild) {
			chatImg.firstChild.src = img;
		} else {
			var imgTag = document.createElement("img");
			imgTag.src = img;
			chatImg.appendChild(imgTag);
		}
	}
	var str = "";
	if (line1) {
		str += "<b>" + line1 + "</b>";
	}
	if (line1 && line2) {
		str += "<br />";	
	}
	if (line2) {
		str += line2;
	}
	chatText.innerHTML = str;
	resize();
}

window.onscroll = setscroll;
window.onclick = onclickDocument;