/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.swt.custom;

import com.ibm.collaboration.realtime.ui.util.ColorCache;
import com.ibm.rcp.swt.custom.CollapseComposite;
import com.ibm.rcp.swt.custom.GrabbyBar;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CollapseableSashForm
extends CollapseComposite {
    private static int MINWIDTH = 20;
    GrabbyBar collapseBar;
    boolean collapsed = false;
    int expandedHeight = 150;
    private int minSibSize = 0;
    boolean resize = false;
    protected boolean resizedByClicking = false;
    private int sizeToRemove = 0;
    private boolean resized = false;
    private int prevDir = -1;
    private int[] weights = null;
    private boolean sashVisible = true;
    Rectangle newBounds = null;
    int delta = 0;

    public static void main(String[] args) {
        Display d = new Display();
        Shell s = new Shell(d);
        s.setLayout((Layout)new FillLayout());
        CollapseableSashForm form = new CollapseableSashForm((Composite)s, 131072);
        form.setWindowResizeOnCollapse(true);
        Text text = new Text((Composite)form, 0);
        text.setText("whatever");
        Button text2 = new Button((Composite)form, 0);
        text2.setText("nope");
        text2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                CollapseableSashForm.this.setMaximizedControl(null);
            }
        });
        form.setWeights(new int[]{1, 2});
        form.setMaximizedControl((Control)text2);
        s.setSize(300, 400);
        s.open();
        while (!s.isDisposed()) {
            if (d.readAndDispatch()) continue;
            d.sleep();
        }
    }

    public CollapseableSashForm(Composite parent, int style) {
        super(parent, style);
        this.collapseBar = new GrabbyBar(this, style);
        if (PlatformUI.isWorkbenchRunning()) {
            this.collapseBar.setForeground(ColorCache.getColor("WINDOW_STATUS_BACKGROUND"));
            this.collapseBar.setBackground(ColorCache.getColor("WINDOW_STATUS_BACKGROUND"));
            this.collapseBar.setGradientBeginColor(ColorCache.getColor("WINDOW_STATUS_BACKGROUND"));
            this.collapseBar.setGradientEndColor(ColorCache.getColor("TEXT_BACKGROUND"));
        } else {
            this.collapseBar.setForeground(this.getDisplay().getSystemColor(21));
            this.collapseBar.setBackground(this.getDisplay().getSystemColor(25));
            this.collapseBar.setGradientBeginColor(this.getDisplay().getSystemColor(22));
            this.collapseBar.setGradientEndColor(this.getDisplay().getSystemColor(22));
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 11: {
                        CollapseableSashForm.this.onResize();
                    }
                }
            }
        };
        int[] folderEvents = new int[]{12, 11};
        int i = 0;
        while (i < folderEvents.length) {
            this.addListener(folderEvents[i], listener);
            ++i;
        }
    }

    public void setWindowResizeOnCollapse(boolean resize) {
        this.resize = resize;
    }

    public GrabbyBar getGrabbyBar() {
        return this.collapseBar;
    }

    public void setSiblingMinimumSize(int min) {
        this.minSibSize = min;
    }

    public int getSiblingMinimumSize() {
        return this.minSibSize;
    }

    public void onResize() {
        this.layout(false);
    }

    public boolean getCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        if (!this.collapsed) {
            this.expandedHeight = (this.getStyle() & 0x20000) != 0 ? this.sizeToRemove : this.getBounds().height;
        }
        if (this.collapsed != collapsed) {
            this.resized = false;
        }
        this.collapsed = collapsed;
        this.layout(true);
    }

    private void layoutParent() {
        Object layoutData = this.getLayoutData();
        if (layoutData instanceof GridData) {
            GridData gd = (GridData)layoutData;
            if ((this.getStyle() & 0x20000) != 0) {
                gd.widthHint = this.collapsed ? GrabbyBar.SIZE : this.expandedHeight;
            } else if ((this.getStyle() & 0x400) != 0) {
                gd.heightHint = this.collapsed ? GrabbyBar.SIZE : this.expandedHeight;
            }
            this.setLayoutData(gd);
        } else if (layoutData instanceof FormData) {
            FormData fd = (FormData)layoutData;
            if ((this.getStyle() & 0x20000) != 0) {
                fd.width = this.collapsed ? GrabbyBar.SIZE : this.expandedHeight;
            } else if ((this.getStyle() & 0x400) != 0) {
                fd.height = this.collapsed ? GrabbyBar.SIZE : this.expandedHeight;
            }
            this.setLayoutData(fd);
        }
        this.getParent().layout();
    }

    public void layout(boolean changed) {
        Rectangle rect = this.getClientArea();
        if (rect.width == 0) {
            return;
        }
        boolean isFocused = this.collapseBar.isFocusControl();
        if ((this.getStyle() & 0x20000) != 0) {
            Control[] children = this.getChildren();
            if (children != null && children.length == 3) {
                Rectangle one = children[1].getBounds();
                Rectangle two = children[2].getBounds();
                int leftDelta = this.delta;
                int rightDelta = this.delta;
                int prevprevDir = this.prevDir;
                if (this.collapsed) {
                    if (this.collapseBar.getCollapsedDir() == 131072) {
                        this.sizeToRemove = two.width;
                        if (this.sizeToRemove != 0) {
                            this.expandedHeight = this.sizeToRemove;
                        }
                        if (this.resize && !this.resized) {
                            rect.width -= this.sizeToRemove;
                        }
                        if (this.sashVisible) {
                            children[1].setBounds(rect.x, rect.y, rect.width - GrabbyBar.SIZE, rect.height);
                            this.collapseBar.setBounds(rect.x + rect.width - GrabbyBar.SIZE, rect.y, GrabbyBar.SIZE, rect.height);
                            children[2].setBounds(rect.x + rect.width, rect.y, 0, rect.height);
                        } else {
                            children[1].setBounds(rect.x, rect.y, rect.width, rect.height);
                            children[2].setBounds(rect.x + rect.width, rect.y, 0, rect.height);
                        }
                        children[1].setVisible(true);
                        children[2].setVisible(false);
                        children[1].redraw();
                        this.setTabList(new Control[]{children[1], this.collapseBar});
                        if (this.resize) {
                            this.resizeShell();
                        }
                        this.prevDir = 131072;
                        if (this.weights != null && this.expandedHeight < this.weights[1]) {
                            this.expandedHeight = this.weights[1];
                        }
                        return;
                    }
                    if (this.collapseBar.getCollapsedDir() == 16384) {
                        this.sizeToRemove = one.width;
                        if (this.sizeToRemove != 0) {
                            this.expandedHeight = this.sizeToRemove;
                        }
                        if (this.resize && !this.resized) {
                            rect.width -= this.sizeToRemove;
                        }
                        if (this.sashVisible) {
                            this.collapseBar.setBounds(rect.x, rect.y, GrabbyBar.SIZE, rect.height);
                            children[2].setBounds(rect.x + GrabbyBar.SIZE, rect.y, rect.width - GrabbyBar.SIZE, rect.height);
                            children[1].setBounds(rect.x, rect.y, 0, rect.height);
                        } else {
                            children[2].setBounds(rect.x, rect.y, rect.width, rect.height);
                            children[1].setBounds(rect.x, rect.y, 0, rect.height);
                        }
                        children[2].setVisible(true);
                        children[1].setVisible(false);
                        children[2].redraw();
                        this.setTabList(new Control[]{this.collapseBar, children[2]});
                        if (this.resize) {
                            this.resizeShell();
                        }
                        this.prevDir = 16384;
                        return;
                    }
                } else {
                    int[] wts;
                    this.sizeToRemove = -this.sizeToRemove;
                    int extraSize = 0;
                    if (this.prevDir == 16384) {
                        if (this.expandedHeight == 0) {
                            wts = this.weights;
                            if (wts != null) {
                                double ratio = (double)wts[0] / ((double)wts[0] + (double)wts[1]);
                                extraSize = (int)((double)(rect.width - GrabbyBar.SIZE) * ratio);
                                this.sizeToRemove = -extraSize;
                            }
                        } else {
                            extraSize = this.expandedHeight;
                            this.sizeToRemove = -this.expandedHeight;
                        }
                        one.width = extraSize;
                        if (two.width < rect.width - GrabbyBar.SIZE - extraSize) {
                            two.width = rect.width - GrabbyBar.SIZE - extraSize;
                        }
                        if (two.width == rect.width) {
                            two.width = rect.width - one.width - GrabbyBar.SIZE;
                        }
                        two.x = rect.x + extraSize + GrabbyBar.SIZE;
                    } else if (this.prevDir == 131072) {
                        if (this.expandedHeight == 0) {
                            wts = this.weights;
                            if (wts != null) {
                                double ratio = (double)wts[1] / ((double)wts[0] + (double)wts[1]);
                                extraSize = (int)((double)(rect.width - GrabbyBar.SIZE) * ratio);
                                this.sizeToRemove = -extraSize;
                            }
                        } else {
                            extraSize = this.expandedHeight;
                            this.sizeToRemove = -this.expandedHeight;
                        }
                        if (one.width < rect.width - GrabbyBar.SIZE - extraSize) {
                            one.width = rect.width - GrabbyBar.SIZE - extraSize;
                        }
                        two.width = extraSize;
                        two.x = rect.x + rect.width - GrabbyBar.SIZE;
                    } else {
                        wts = this.weights;
                        if (this.delta != 0) {
                            wts[0] = one.width;
                            wts[1] = two.width;
                        } else {
                            double change = rect.width - GrabbyBar.SIZE - (one.width + two.width);
                            double ratio = (double)wts[0] / ((double)wts[0] + (double)wts[1]);
                            if (one.width != 0) {
                                leftDelta = (int)(change * ratio);
                                rightDelta = -((int)change - leftDelta);
                            } else {
                                one.width = (int)(change * ratio);
                                two.width = (int)change - one.width;
                            }
                        }
                    }
                    if (this.sizeToRemove > 0) {
                        this.sizeToRemove = -this.sizeToRemove;
                    }
                    this.prevDir = -1;
                    if (!children[1].isVisible()) {
                        children[1].setVisible(true);
                    }
                    if (!children[2].isVisible()) {
                        children[2].setVisible(true);
                    }
                }
                if (one.width == 0) {
                    one.width = (rect.width - GrabbyBar.SIZE) / 2;
                }
                if (two.width == 0) {
                    two.width = (rect.width - GrabbyBar.SIZE) / 2;
                }
                int cxOne = one.width + leftDelta;
                if (this.prevDir == -1 && prevprevDir == -1) {
                    if (cxOne < MINWIDTH) {
                        cxOne = MINWIDTH;
                    }
                    if (cxOne > rect.width - (MINWIDTH + GrabbyBar.SIZE)) {
                        cxOne = rect.width - (MINWIDTH + GrabbyBar.SIZE);
                    }
                }
                int cxTwo = rect.width - (cxOne + GrabbyBar.SIZE);
                if (this.prevDir == -1 && prevprevDir != -1) {
                    cxTwo = two.width - rightDelta;
                }
                children[1].setBounds(rect.x, rect.y, cxOne, rect.height);
                this.collapseBar.setBounds(rect.x + cxOne, rect.y, GrabbyBar.SIZE, rect.height);
                children[2].setBounds(rect.x + cxOne + GrabbyBar.SIZE, rect.y, cxTwo, rect.height);
                if (children[1] instanceof Composite) {
                    ((Composite)children[1]).layout(true);
                }
                children[1].redraw();
                if (children[2] instanceof Composite) {
                    ((Composite)children[2]).layout(true);
                }
                children[2].redraw();
                this.setTabList(new Control[]{children[1], this.collapseBar, children[2]});
            }
        } else {
            this.collapseBar.setBounds(rect.x, rect.y, rect.width, GrabbyBar.SIZE);
            Control[] children = this.getChildren();
            if (children != null && children.length > 1) {
                children[1].setBounds(rect.x, rect.y + GrabbyBar.SIZE, rect.width, rect.height - GrabbyBar.SIZE);
                if (children[1] instanceof Composite) {
                    ((Composite)children[1]).layout();
                } else {
                    children[1].redraw();
                }
            }
        }
        if (changed) {
            this.layoutParent();
        }
        if (this.resize || this.resizedByClicking) {
            this.resizeShell();
        }
        if (isFocused) {
            this.collapseBar.setFocus();
        }
    }

    private void resizeShell() {
        if (this.resized) {
            return;
        }
        if (this.resizedByClicking) {
            this.resizedByClicking = false;
        }
        this.resized = true;
        Shell shell = this.getShell();
        Rectangle bounds = shell.getBounds();
        bounds.width -= this.sizeToRemove;
        shell.setBounds(bounds);
        shell.layout(true);
    }

    public Rectangle getClientArea() {
        if (this.collapsed && (this.getStyle() & 0x20000) == 0) {
            if ((this.getStyle() & 0x20000) != 0) {
                Rectangle bounds = super.getClientArea();
                Rectangle rect = new Rectangle(0, 0, 0, 0);
                rect.x = bounds.x + bounds.width - GrabbyBar.SIZE;
                rect.y = bounds.y;
                rect.width = GrabbyBar.SIZE;
                rect.height = bounds.height;
                return rect;
            }
            Rectangle bounds = super.getClientArea();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            rect.x = bounds.x;
            rect.y = bounds.y + bounds.height - GrabbyBar.SIZE;
            rect.width = bounds.width;
            rect.height = GrabbyBar.SIZE;
            return rect;
        }
        return super.getClientArea();
    }

    public void setWeights(int[] weights) {
        this.weights = weights;
    }

    public int[] getWeights() {
        return this.weights;
    }

    public void setMaximizedControl(Control control) {
        this.resizedByClicking = false;
        if (control == null) {
            this.collapseBar.setCollapsedDir(-1);
            this.layout(true);
            this.getParent().layout();
            return;
        }
        Control[] children = this.getChildren();
        if (children != null && children.length == 3) {
            if (children[1].equals(control)) {
                this.collapseBar.setCollapsedDir(131072);
                this.prevDir = 131072;
                this.layout(true);
            } else if (children[2].equals(control)) {
                this.collapseBar.setCollapsedDir(16384);
                this.prevDir = 16384;
                this.layout(true);
            }
        }
    }

    public void collapse(int dir) {
        this.resizedByClicking = true;
        this.collapseBar.setCollapsedDir(dir);
        this.layout(true);
        this.getParent().layout();
    }

    public Control getMaximizedControl() {
        if (this.collapseBar.getCollapsedDir() == -1) {
            return null;
        }
        if (this.collapseBar.getCollapsedDir() == 131072) {
            return this.getChildren()[1];
        }
        return this.getChildren()[2];
    }

    public void setSashVisibleOnCollapse(boolean sashVisible) {
        this.sashVisible = sashVisible;
    }

    public void setNewBounds(Rectangle arg0) {
        this.newBounds = arg0;
    }

    public void setDelta(int delta) {
        this.delta = delta;
    }
}

