/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.swt.custom;

import com.ibm.collaboration.realtime.ui.util.ColorCache;
import com.ibm.rcp.swt.custom.CollapseComposite;
import com.ibm.rcp.swt.custom.GrabbyBar;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class CollapseableArea
extends CollapseComposite {
    GrabbyBar collapseBar;
    boolean collapsed = false;
    int expandedHeight = 150;
    private int minSibSize = 0;

    public CollapseableArea(Composite parent, int style) {
        super(parent, style);
        this.collapseBar = new GrabbyBar(this, style);
        if (PlatformUI.isWorkbenchRunning()) {
            this.collapseBar.setForeground(ColorCache.getColor("WINDOW_STATUS_BACKGROUND"));
            this.collapseBar.setBackground(ColorCache.getColor("WINDOW_STATUS_BACKGROUND"));
            this.collapseBar.setGradientBeginColor(ColorCache.getColor("WINDOW_STATUS_BACKGROUND"));
            this.collapseBar.setGradientEndColor(ColorCache.getColor("TEXT_BACKGROUND"));
        } else {
            this.collapseBar.setForeground(this.getDisplay().getSystemColor(22));
            this.collapseBar.setBackground(this.getDisplay().getSystemColor(25));
            this.collapseBar.setGradientBeginColor(this.getDisplay().getSystemColor(22));
            this.collapseBar.setGradientEndColor(this.getDisplay().getSystemColor(25));
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 11: {
                        CollapseableArea.this.onResize();
                    }
                }
            }
        };
        int[] folderEvents = new int[]{12, 11};
        int i = 0;
        while (i < folderEvents.length) {
            this.addListener(folderEvents[i], listener);
            ++i;
        }
    }

    public GrabbyBar getGrabbyBar() {
        return this.collapseBar;
    }

    public void setSiblingMinimumSize(int min) {
        this.minSibSize = min;
    }

    public int getSiblingMinimumSize() {
        return this.minSibSize;
    }

    public void onResize() {
        this.layout(false);
    }

    public boolean getCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        if (!this.collapsed) {
            this.expandedHeight = (this.getStyle() & 0x20000) != 0 ? this.getBounds().width : this.getBounds().height;
        }
        this.collapsed = collapsed;
        this.layout(true);
    }

    private void layoutParent() {
        Object layoutData = this.getLayoutData();
        if (layoutData instanceof GridData) {
            GridData gd = (GridData)layoutData;
            if ((this.getStyle() & 0x20000) != 0) {
                gd.widthHint = this.collapsed ? GrabbyBar.SIZE : this.expandedHeight;
            } else if ((this.getStyle() & 0x400) != 0) {
                gd.heightHint = this.collapsed ? GrabbyBar.SIZE : this.expandedHeight;
            }
            this.setLayoutData(gd);
        } else if (layoutData instanceof FormData) {
            FormData fd = (FormData)layoutData;
            if ((this.getStyle() & 0x20000) != 0) {
                fd.width = this.collapsed ? GrabbyBar.SIZE : this.expandedHeight;
            } else if ((this.getStyle() & 0x400) != 0) {
                fd.height = this.collapsed ? GrabbyBar.SIZE : this.expandedHeight;
            }
            this.setLayoutData(fd);
        }
        this.getParent().layout();
    }

    public void layout(boolean changed) {
        Rectangle rect = this.getClientArea();
        boolean isFocused = this.collapseBar.isFocusControl();
        if (!this.collapsed) {
            if ((this.getStyle() & 0x20000) != 0) {
                this.collapseBar.setBounds(rect.x, rect.y, GrabbyBar.SIZE, rect.height);
                Control[] children = this.getChildren();
                if (children != null && children.length > 1) {
                    children[1].setBounds(rect.x + GrabbyBar.SIZE, rect.y, rect.width - GrabbyBar.SIZE, rect.height);
                    if (rect.width > GrabbyBar.SIZE) {
                        this.expandedHeight = rect.width;
                    }
                    if (children[1] instanceof Composite) {
                        ((Composite)children[1]).layout();
                    } else {
                        children[1].redraw();
                    }
                }
            } else {
                this.collapseBar.setBounds(rect.x, rect.y, rect.width, GrabbyBar.SIZE);
                Control[] children = this.getChildren();
                if (children != null && children.length > 1) {
                    children[1].setBounds(rect.x, rect.y + GrabbyBar.SIZE, rect.width, rect.height - GrabbyBar.SIZE);
                    if (rect.height > GrabbyBar.SIZE) {
                        this.expandedHeight = rect.height;
                    }
                    if (children[1] instanceof Composite) {
                        ((Composite)children[1]).layout();
                    } else {
                        children[1].redraw();
                    }
                }
            }
        }
        if (changed) {
            this.layoutParent();
        }
        if (isFocused) {
            this.collapseBar.setFocus();
        }
    }

    public Rectangle getClientArea() {
        if (this.collapsed) {
            if ((this.getStyle() & 0x20000) != 0) {
                Rectangle bounds = super.getClientArea();
                Rectangle rect = new Rectangle(0, 0, 0, 0);
                rect.x = bounds.x + bounds.width - GrabbyBar.SIZE;
                rect.y = bounds.y;
                rect.width = GrabbyBar.SIZE;
                rect.height = bounds.height;
                return rect;
            }
            Rectangle bounds = super.getClientArea();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            rect.x = bounds.x;
            rect.y = bounds.y + bounds.height - GrabbyBar.SIZE;
            rect.width = bounds.width;
            rect.height = GrabbyBar.SIZE;
            return rect;
        }
        return super.getClientArea();
    }
}

